/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.blocks;

import com.google.common.collect.Maps;
import com.vulp.druidcraft.Druidcraft;
import com.vulp.druidcraft.api.IKnifeable;
import com.vulp.druidcraft.api.RopeConnectionType;
import com.vulp.druidcraft.blocks.GrowthLampBlock;
import com.vulp.druidcraft.blocks.RopeLanternBlock;
import com.vulp.druidcraft.blocks.RopeableLanternBlock;
import com.vulp.druidcraft.blocks.SmallBeamBlock;
import com.vulp.druidcraft.registry.BlockRegistry;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RopeBlock
extends SixWayBlock
implements IKnifeable {
    private static final Direction[] FACING_VALUES = Direction.values();
    public static final EnumProperty<RopeConnectionType> NORTH = EnumProperty.func_177709_a((String)"north", RopeConnectionType.class);
    public static final EnumProperty<RopeConnectionType> EAST = EnumProperty.func_177709_a((String)"east", RopeConnectionType.class);
    public static final EnumProperty<RopeConnectionType> SOUTH = EnumProperty.func_177709_a((String)"south", RopeConnectionType.class);
    public static final EnumProperty<RopeConnectionType> WEST = EnumProperty.func_177709_a((String)"west", RopeConnectionType.class);
    public static final EnumProperty<RopeConnectionType> UP = EnumProperty.func_177709_a((String)"up", RopeConnectionType.class);
    public static final EnumProperty<RopeConnectionType> DOWN = EnumProperty.func_177709_a((String)"down", RopeConnectionType.class);
    public static final BooleanProperty KNOTTED = BooleanProperty.func_177716_a((String)"knotted");
    protected final VoxelShape[] collisionShapes = this.makeCollisionShapes(0.125f);
    public static final Map<Direction, EnumProperty<RopeConnectionType>> FACING_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
        map.put(Direction.UP, UP);
        map.put(Direction.DOWN, DOWN);
    });

    public RopeBlock(Block.Properties properties) {
        super(0.12f, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(NORTH, (Comparable)((Object)RopeConnectionType.NONE))).func_206870_a(EAST, (Comparable)((Object)RopeConnectionType.NONE))).func_206870_a(SOUTH, (Comparable)((Object)RopeConnectionType.NONE))).func_206870_a(WEST, (Comparable)((Object)RopeConnectionType.NONE))).func_206870_a(UP, (Comparable)((Object)RopeConnectionType.NONE))).func_206870_a(DOWN, (Comparable)((Object)RopeConnectionType.NONE))).func_206870_a((IProperty)KNOTTED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ActionResultType onKnife(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos);
        Vec3d relative = context.func_221532_j().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Druidcraft.LOGGER.debug("onKnife: {}", (Object)relative);
        Direction side = RopeBlock.getClickedConnection(relative);
        if (side != null && !(world.func_180495_p(pos.func_177972_a(side)).func_177230_c() instanceof RopeBlock)) {
            BlockState state1 = this.cycleProperty(state, (IProperty)FACING_TO_PROPERTY_MAP.get(side), context);
            world.func_180501_a(pos, state1, 18);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private <T extends Comparable<T>> BlockState cycleProperty(BlockState state, IProperty<T> propertyIn, ItemUseContext context) {
        Comparable value = RopeBlock.getAdjacentValue(propertyIn.func_177700_c(), state.func_177229_b(propertyIn));
        if (value != RopeConnectionType.NONE) {
            return this.calculateKnot((BlockState)state.func_206870_a(propertyIn, (Comparable)((Object)RopeConnectionType.NONE)));
        }
        if (!((Boolean)state.func_177229_b((IProperty)KNOTTED)).booleanValue() && context.func_195999_j().func_70093_af()) {
            return (BlockState)state.func_206870_a((IProperty)KNOTTED, (Comparable)Boolean.valueOf(true));
        }
        return this.calculateState(state, (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    private static <T> T getAdjacentValue(Iterable<T> p_195959_0_, @Nullable T p_195959_1_) {
        return (T)Util.func_195647_a(p_195959_0_, p_195959_1_);
    }

    @Nullable
    private static Direction getClickedConnection(Vec3d relative) {
        if (relative.field_72450_a < 0.25) {
            return Direction.WEST;
        }
        if (relative.field_72450_a > 0.75) {
            return Direction.EAST;
        }
        if (relative.field_72448_b < 0.25) {
            return Direction.DOWN;
        }
        if (relative.field_72448_b > 0.75) {
            return Direction.UP;
        }
        if (relative.field_72449_c < 0.25) {
            return Direction.NORTH;
        }
        if (relative.field_72449_c > 0.75) {
            return Direction.SOUTH;
        }
        return null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.field_196493_C[this.func_196486_i(state)];
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.collisionShapes[this.func_196486_i(state)];
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    private VoxelShape[] makeCollisionShapes(float apothem) {
        float f = 0.5f - apothem;
        float f1 = 0.5f + apothem;
        VoxelShape voxelshape = Block.func_208617_a((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f));
        VoxelShape[] avoxelshape = new VoxelShape[FACING_VALUES.length];
        for (int i = 0; i < FACING_VALUES.length; ++i) {
            Direction direction = FACING_VALUES[i];
            avoxelshape[i] = VoxelShapes.func_197873_a((double)(0.5 + Math.min((double)(-apothem), (double)direction.func_82601_c() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.func_96559_d() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.func_82599_e() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.func_82601_c() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.func_96559_d() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.func_82599_e() * 0.5)));
        }
        VoxelShape[] avoxelshape1 = new VoxelShape[64];
        for (int k = 0; k < 64; ++k) {
            VoxelShape voxelshape1 = voxelshape;
            for (int j = 0; j < FACING_VALUES.length; ++j) {
                if ((k & 1 << j) == 0) continue;
                voxelshape1 = VoxelShapes.func_197872_a((VoxelShape)voxelshape1, (VoxelShape)avoxelshape[j]);
            }
            avoxelshape1[k] = voxelshape1;
        }
        return avoxelshape1;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, KNOTTED});
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.calculateState(this.func_176223_P(), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    private BlockState calculateKnot(BlockState currentState) {
        int count = 0;
        for (Direction dir : Direction.values()) {
            EnumProperty<RopeConnectionType> prop = FACING_TO_PROPERTY_MAP.get(dir);
            if (prop == null || currentState.func_177229_b(prop) == RopeConnectionType.NONE) continue;
            ++count;
        }
        boolean doKnot = count >= 3 || count == 0;
        return (BlockState)currentState.func_206870_a((IProperty)KNOTTED, (Comparable)Boolean.valueOf(doKnot));
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return this.calculateState(state, world, currentPos);
    }

    public static RopeConnectionType beamChecker(BlockState directionState, Direction direction) {
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            if (((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.X_AXIS)).booleanValue()) {
                if (!((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.Z_AXIS)).booleanValue()) {
                    return RopeConnectionType.TIED_BEAM_2;
                }
                return RopeConnectionType.REGULAR;
            }
            if (((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.Y_AXIS)).booleanValue()) {
                if (!((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.Z_AXIS)).booleanValue()) {
                    return RopeConnectionType.TIED_BEAM_1;
                }
                return RopeConnectionType.REGULAR;
            }
            if (((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.Z_AXIS)).booleanValue()) {
                return RopeConnectionType.REGULAR;
            }
        }
        if (direction == Direction.EAST || direction == Direction.WEST) {
            if (((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.X_AXIS)).booleanValue()) {
                return RopeConnectionType.REGULAR;
            }
            if (((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.Y_AXIS)).booleanValue()) {
                if (!((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.X_AXIS)).booleanValue()) {
                    return RopeConnectionType.TIED_BEAM_1;
                }
                return RopeConnectionType.REGULAR;
            }
            if (((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.Z_AXIS)).booleanValue()) {
                if (!((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.X_AXIS)).booleanValue()) {
                    return RopeConnectionType.TIED_BEAM_2;
                }
                return RopeConnectionType.REGULAR;
            }
        }
        if (direction == Direction.UP || direction == Direction.DOWN) {
            if (((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.X_AXIS)).booleanValue()) {
                if (!((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.Y_AXIS)).booleanValue()) {
                    return RopeConnectionType.TIED_BEAM_2;
                }
                return RopeConnectionType.REGULAR;
            }
            if (((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.Y_AXIS)).booleanValue()) {
                return RopeConnectionType.REGULAR;
            }
            if (((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.Z_AXIS)).booleanValue()) {
                if (!((Boolean)directionState.func_177229_b((IProperty)SmallBeamBlock.Y_AXIS)).booleanValue()) {
                    return RopeConnectionType.TIED_BEAM_1;
                }
                return RopeConnectionType.REGULAR;
            }
        }
        return RopeConnectionType.NONE;
    }

    private BlockState calculateState(BlockState currentState, IWorld world, BlockPos pos) {
        RopeConnectionType northType = RopeConnectionType.NONE;
        BlockState northState = world.func_180495_p(pos.func_177972_a(Direction.NORTH));
        if (northState.func_224755_d((IBlockReader)world, pos.func_177972_a(Direction.NORTH), Direction.NORTH.func_176734_d()) || northState.func_177230_c() == this) {
            northType = RopeConnectionType.REGULAR;
        } else if (northState.func_177230_c().func_203417_a(BlockTags.field_219748_G)) {
            northType = RopeConnectionType.TIED_FENCE;
        } else if (northState.func_177230_c() instanceof SmallBeamBlock) {
            northType = RopeBlock.beamChecker(northState, Direction.NORTH);
        }
        RopeConnectionType eastType = RopeConnectionType.NONE;
        BlockState eastState = world.func_180495_p(pos.func_177972_a(Direction.EAST));
        if (eastState.func_224755_d((IBlockReader)world, pos.func_177972_a(Direction.EAST), Direction.EAST.func_176734_d()) || eastState.func_177230_c() == this) {
            eastType = RopeConnectionType.REGULAR;
        } else if (eastState.func_177230_c().func_203417_a(BlockTags.field_219748_G)) {
            eastType = RopeConnectionType.TIED_FENCE;
        } else if (eastState.func_177230_c() instanceof SmallBeamBlock) {
            eastType = RopeBlock.beamChecker(eastState, Direction.EAST);
        }
        RopeConnectionType southType = RopeConnectionType.NONE;
        BlockState southState = world.func_180495_p(pos.func_177972_a(Direction.SOUTH));
        if (southState.func_224755_d((IBlockReader)world, pos.func_177972_a(Direction.SOUTH), Direction.SOUTH.func_176734_d()) || southState.func_177230_c() == this) {
            southType = RopeConnectionType.REGULAR;
        } else if (southState.func_177230_c().func_203417_a(BlockTags.field_219748_G)) {
            southType = RopeConnectionType.TIED_FENCE;
        } else if (southState.func_177230_c() instanceof SmallBeamBlock) {
            southType = RopeBlock.beamChecker(southState, Direction.SOUTH);
        }
        RopeConnectionType westType = RopeConnectionType.NONE;
        BlockState westState = world.func_180495_p(pos.func_177972_a(Direction.WEST));
        if (westState.func_224755_d((IBlockReader)world, pos.func_177972_a(Direction.WEST), Direction.WEST.func_176734_d()) || westState.func_177230_c() == this) {
            westType = RopeConnectionType.REGULAR;
        } else if (westState.func_177230_c().func_203417_a(BlockTags.field_219748_G)) {
            westType = RopeConnectionType.TIED_FENCE;
        } else if (westState.func_177230_c() instanceof SmallBeamBlock) {
            westType = RopeBlock.beamChecker(westState, Direction.WEST);
        }
        RopeConnectionType upType = RopeConnectionType.NONE;
        BlockState upState = world.func_180495_p(pos.func_177972_a(Direction.UP));
        if (upState.func_224755_d((IBlockReader)world, pos.func_177972_a(Direction.UP), Direction.UP.func_176734_d()) || upState.func_177230_c() == this || upState.func_177230_c().func_203417_a(BlockTags.field_219748_G)) {
            upType = RopeConnectionType.REGULAR;
        } else if (upState.func_177230_c() instanceof SmallBeamBlock) {
            upType = RopeBlock.beamChecker(upState, Direction.UP);
        }
        RopeConnectionType downType = RopeConnectionType.NONE;
        BlockState downState = world.func_180495_p(pos.func_177972_a(Direction.DOWN));
        if (downState.func_224755_d((IBlockReader)world, pos.func_177972_a(Direction.DOWN), Direction.DOWN.func_176734_d()) || downState.func_177230_c() == this || downState.func_177230_c().func_203417_a(BlockTags.field_219748_G) || downState.func_177230_c() instanceof RopeLanternBlock || downState.func_177230_c() instanceof GrowthLampBlock || downState.func_177230_c() instanceof RopeableLanternBlock && ((Boolean)downState.func_177229_b((IProperty)RopeableLanternBlock.HANGING)).booleanValue() && ((Boolean)downState.func_177229_b((IProperty)RopeableLanternBlock.ROPED)).booleanValue()) {
            downType = RopeConnectionType.REGULAR;
        } else if (downState.func_177230_c() instanceof SmallBeamBlock) {
            downType = RopeBlock.beamChecker(downState, Direction.DOWN);
        }
        return this.calculateKnot((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)currentState.func_206870_a(NORTH, (Comparable)((Object)northType))).func_206870_a(EAST, (Comparable)((Object)eastType))).func_206870_a(SOUTH, (Comparable)((Object)southType))).func_206870_a(WEST, (Comparable)((Object)westType))).func_206870_a(UP, (Comparable)((Object)upType))).func_206870_a(DOWN, (Comparable)((Object)downType)));
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item == Items.field_222111_pQ && hit.func_216354_b() == Direction.DOWN && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76222_j()) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            worldIn.func_175656_a(pos.func_177977_b(), BlockRegistry.rope_lantern.func_176223_P());
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_219640_fO, SoundCategory.BLOCKS, 1.0f, 0.88f, true);
            return true;
        }
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected int func_196486_i(BlockState state) {
        int i = 0;
        for (int j = 0; j < Direction.values().length; ++j) {
            if (state.func_177229_b((IProperty)FACING_TO_PROPERTY_MAP.get(Direction.values()[j])) == RopeConnectionType.NONE) continue;
            i |= 1 << j;
        }
        return i;
    }

    public static RopeConnectionType getConnection(BlockState state, Direction side) {
        return (RopeConnectionType)((Object)state.func_177229_b((IProperty)FACING_TO_PROPERTY_MAP.get(side)));
    }
}

