/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WetMudBlock
extends Block {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private Block block;
    private int maxTicks = 0;

    public WetMudBlock(Block convertedBlock, Block.Properties properties) {
        super(properties);
        this.block = convertedBlock;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_196265_a(BlockState state, World worldIn, BlockPos pos, Random random) {
        super.func_196265_a(state, worldIn, pos, random);
        if (!this.isNextToWater((IBlockReader)worldIn, pos)) {
            if (!(worldIn.field_72995_K || worldIn.field_73012_v.nextInt(6) != 0 && this.maxTicks < 10)) {
                worldIn.func_175656_a(pos, this.block.func_176223_P());
            } else {
                ++this.maxTicks;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        tooltip.add(new TranslationTextComponent("block.druidcraft.wet_mud_bricks.description1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA).func_150217_b(Boolean.valueOf(true))));
    }

    private boolean isNextToWater(IBlockReader p_203943_1_, BlockPos p_203943_2_) {
        Direction[] var3;
        for (Direction direction : var3 = Direction.values()) {
            IFluidState ifluidstate = p_203943_1_.func_204610_c(p_203943_2_.func_177972_a(direction));
            if (!ifluidstate.func_206884_a(FluidTags.field_206959_a)) continue;
            return true;
        }
        return false;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(0.5, 1.0, 0.5));
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return true;
    }
}

