/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.entities.AI.goals;

import com.vulp.druidcraft.entities.TameableFlyingMonsterEntity;
import com.vulp.druidcraft.pathfinding.FlyingFishPathNavigator;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class FollowOwnerGoalMonster
extends Goal {
    private final TameableFlyingMonsterEntity tameable;
    private LivingEntity owner;
    protected final IWorldReader world;
    private final double followSpeed;
    private final FlyingFishPathNavigator navigator;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;

    public FollowOwnerGoalMonster(TameableFlyingMonsterEntity tameableIn, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.tameable = tameableIn;
        this.world = tameableIn.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.navigator = tameableIn.getNavigator();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = this.tameable.getOwner();
        if (livingentity == null) {
            return false;
        }
        if (livingentity instanceof PlayerEntity && livingentity.func_175149_v()) {
            return false;
        }
        if (this.tameable.isSitting()) {
            return false;
        }
        if (this.tameable.func_70068_e((Entity)livingentity) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean func_75253_b() {
        return !this.navigator.func_75500_f() && this.tameable.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist) && !this.tameable.isSitting();
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tameable.func_184643_a(PathNodeType.WATER);
        this.tameable.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigator.func_75499_g();
        this.tameable.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.tameable.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.tameable.func_70646_bf());
        if (!this.tameable.isSitting() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.tameable.func_110167_bD() && !this.tameable.func_184218_aH() && this.tameable.func_70068_e((Entity)this.owner) > 576.0) {
                int i = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
                int j = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
                int k = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.canTeleportToBlock(new BlockPos(i + l, k - 1, j + i1))) continue;
                        this.tameable.func_70012_b((float)(i + l) + 0.5f, k + 1, (float)(j + i1) + 0.5f, this.tameable.field_70177_z, this.tameable.field_70125_A);
                        this.navigator.func_75499_g();
                    }
                }
            }
            this.navigator.func_75497_a((Entity)this.owner, this.followSpeed);
        }
    }

    private boolean canTeleportToBlock(BlockPos pos) {
        BlockState blockstate = this.world.func_180495_p(pos);
        return blockstate.func_215682_a((IBlockReader)this.world, pos, (Entity)this.tameable) && this.world.func_175623_d(pos.func_177981_b(2)) && this.world.func_175623_d(pos.func_177981_b(3));
    }
}

