/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.entities;

import com.vulp.druidcraft.entities.AI.goals.FollowOwnerGoalMonster;
import com.vulp.druidcraft.entities.AI.goals.NonTamedTargetGoalMonster;
import com.vulp.druidcraft.entities.AI.goals.OwnerHurtByTargetGoalMonster;
import com.vulp.druidcraft.entities.AI.goals.OwnerHurtTargetGoalMonster;
import com.vulp.druidcraft.entities.AI.goals.RandomFlyingGoal;
import com.vulp.druidcraft.entities.AI.goals.SitGoalMonster;
import com.vulp.druidcraft.entities.TameableFlyingMonsterEntity;
import com.vulp.druidcraft.entities.TameableMonsterEntity;
import com.vulp.druidcraft.events.EventFactory;
import com.vulp.druidcraft.pathfinding.FlyingFishPathNavigator;
import com.vulp.druidcraft.registry.ParticleRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class DreadfishEntity
extends TameableFlyingMonsterEntity {
    private static final Predicate<LivingEntity> isPlayer;
    private static final DataParameter<Integer> SMOKE_COLOR;
    private static final Map<DyeColor, int[]> DYE_COLOR_MAP;
    private FlyingFishPathNavigator navigator;
    private DyeColor smokeColor = null;

    public DreadfishEntity(EntityType<? extends TameableFlyingMonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.navigator = (FlyingFishPathNavigator)this.func_175447_b(worldIn);
        this.setTamed(false);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.sitGoal = new SitGoalMonster(this);
        this.field_70714_bg.func_75776_a(1, (Goal)this.sitGoal);
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 3.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoalMonster(this, 5.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new SwimGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoalMonster(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoalMonster(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new NonTamedTargetGoalMonster<PlayerEntity>(this, PlayerEntity.class, false, isPlayer));
        this.field_70715_bh.func_75776_a(5, new NonTamedTargetGoalMonster<IronGolemEntity>(this, IronGolemEntity.class, false));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.975);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SMOKE_COLOR, (Object)DyeColor.PURPLE.func_196059_a());
    }

    public static boolean placement(EntityType<?> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && DreadfishEntity.isValidLightLevel(worldIn, pos, randomIn);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.2f;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    private static boolean isValidLightLevel(IWorld world, BlockPos pos, Random rand) {
        if (world.func_175642_b(LightType.SKY, pos) > rand.nextInt(32)) {
            return false;
        }
        int i = world.func_201672_e().func_72911_I() ? world.func_205049_d(pos, 10) : world.func_201696_r(pos);
        return i <= rand.nextInt(8);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.sitGoal != null) {
            this.sitGoal.setSitting(false);
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Hostile", this.isHostile());
        compound.func_74774_a("SmokeColor", (byte)this.getSmokeColor().func_196059_a());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHostile(compound.func_74767_n("Hostile"));
        if (compound.func_150297_b("SmokeColor", 99)) {
            this.setSmokeColor(DyeColor.func_196056_a((int)compound.func_74762_e("SmokeColor")));
        }
    }

    public boolean func_189652_ae() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new FlyingFishPathNavigator((MobEntity)this, worldIn);
    }

    public void func_213352_e(Vec3d relative) {
        if (this.func_70613_aW()) {
            this.func_213309_a(0.01f, relative);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(relative);
        }
    }

    protected boolean execute() {
        return true;
    }

    @Override
    public void setTamed(boolean tamed) {
        super.setTamed(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        if (entitylivingbaseIn == null) {
            this.setHostile(false);
        } else if (!this.isTamed()) {
            this.setHostile(true);
        }
    }

    public int[] getSmokeColorArray() {
        return DYE_COLOR_MAP.getOrDefault(this.getSmokeColor(), new int[]{0, 0, 0});
    }

    public DyeColor getSmokeColor() {
        if (this.smokeColor == null) {
            this.smokeColor = DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(SMOKE_COLOR)));
        }
        return this.smokeColor;
    }

    public void setSmokeColor(DyeColor smokeColor) {
        this.field_70180_af.func_187227_b(SMOKE_COLOR, (Object)smokeColor.func_196059_a());
        this.smokeColor = smokeColor;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (this.isTamed()) {
            if (!itemstack.func_190926_b()) {
                DyeColor dyecolor;
                if (item == Items.field_151103_aS && this.func_110143_aJ() < this.func_110138_aP()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    this.func_70691_i(4.0f);
                    return true;
                }
                if (item instanceof DyeItem && (dyecolor = ((DyeItem)item).func_195962_g()) != this.getSmokeColor()) {
                    this.setSmokeColor(dyecolor);
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    return true;
                }
            }
            if (!(!this.isOwner((LivingEntity)player) || this.field_70170_p.field_72995_K || item == Items.field_151103_aS && item instanceof DyeItem)) {
                this.sitGoal.setSitting(!this.isSitting());
                this.field_70703_bu = false;
                this.navigator.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (item == Items.field_179563_cD) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !EventFactory.onMonsterTame(this, player)) {
                    this.playTameEffect(true);
                    this.setTamedBy(player);
                    this.navigator.func_75499_g();
                    this.func_70624_b(null);
                    this.sitGoal.setSitting(true);
                    this.func_70606_j(24.0f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.playTameEffect(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean shouldAttackEntity(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity)) {
            TameableEntity tameableEntity;
            TameableMonsterEntity monsterEntity;
            if (target instanceof TameableMonsterEntity && (monsterEntity = (TameableMonsterEntity)target).isTamed() && monsterEntity.getOwner() == this.getOwner()) {
                return false;
            }
            if (target instanceof TameableEntity && (tameableEntity = (TameableEntity)target).func_70909_n() && tameableEntity.func_70902_q() == this.getOwner()) {
                return false;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof CatEntity) || !((CatEntity)target).func_70909_n();
        }
        return false;
    }

    @Override
    public boolean func_184652_a(PlayerEntity player) {
        return !this.isHostile() && !this.isTamed();
    }

    public boolean isHostile() {
        return ((Byte)this.field_70180_af.func_187225_a(TAMED) & 2) != 0;
    }

    public void setHostile(boolean hostile) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(TAMED);
        if (hostile) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            int[] color = this.getSmokeColorArray();
            this.field_70170_p.func_195590_a((IParticleData)ParticleRegistry.magic_smoke, false, this.field_70165_t, this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5 + 0.2) / 3.0 + 0.2, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5 + 0.2) / 3.0, (double)((float)color[0] / 255.0f), (double)((float)color[1] / 255.0f), (double)((float)color[2] / 255.0f));
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.isHostile()) {
            this.setHostile(false);
        }
    }

    public boolean func_70617_f_() {
        return false;
    }

    static {
        SMOKE_COLOR = EntityDataManager.func_187226_a(DreadfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
        DYE_COLOR_MAP = new HashMap<DyeColor, int[]>();
        DYE_COLOR_MAP.put(DyeColor.BLACK, new int[]{15, 15, 15});
        DYE_COLOR_MAP.put(DyeColor.RED, new int[]{255, 50, 40});
        DYE_COLOR_MAP.put(DyeColor.GREEN, new int[]{15, 150, 45});
        DYE_COLOR_MAP.put(DyeColor.BROWN, new int[]{130, 70, 45});
        DYE_COLOR_MAP.put(DyeColor.BLUE, new int[]{30, 60, 225});
        DYE_COLOR_MAP.put(DyeColor.PURPLE, new int[]{135, 45, 245});
        DYE_COLOR_MAP.put(DyeColor.CYAN, new int[]{20, 125, 130});
        DYE_COLOR_MAP.put(DyeColor.LIGHT_GRAY, new int[]{160, 160, 155});
        DYE_COLOR_MAP.put(DyeColor.GRAY, new int[]{90, 90, 90});
        DYE_COLOR_MAP.put(DyeColor.PINK, new int[]{255, 115, 170});
        DYE_COLOR_MAP.put(DyeColor.LIME, new int[]{135, 250, 35});
        DYE_COLOR_MAP.put(DyeColor.YELLOW, new int[]{240, 240, 50});
        DYE_COLOR_MAP.put(DyeColor.LIGHT_BLUE, new int[]{50, 200, 255});
        DYE_COLOR_MAP.put(DyeColor.MAGENTA, new int[]{230, 65, 170});
        DYE_COLOR_MAP.put(DyeColor.ORANGE, new int[]{240, 135, 30});
        DYE_COLOR_MAP.put(DyeColor.WHITE, new int[]{215, 215, 215});
        isPlayer = type -> {
            EntityType entitytype = type.func_200600_R();
            return entitytype == EntityType.field_200729_aH;
        };
    }

    static class MoveHelperController
    extends MovementController {
        private final DreadfishEntity dreadfishEntity;

        MoveHelperController(DreadfishEntity dreadfishEntity) {
            super((MobEntity)dreadfishEntity);
            this.dreadfishEntity = dreadfishEntity;
        }

        public void func_75641_c() {
            this.dreadfishEntity.func_213317_d(this.dreadfishEntity.func_213322_ci().func_72441_c(0.0, 0.0, 0.0));
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.dreadfishEntity.getNavigator().func_75500_f()) {
                double d0 = this.field_75646_b - this.dreadfishEntity.field_70165_t;
                double d1 = this.field_75647_c - this.dreadfishEntity.field_70163_u;
                double d2 = this.field_75644_d - this.dreadfishEntity.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.dreadfishEntity.field_70761_aq = this.dreadfishEntity.field_70177_z = this.func_75639_a(this.dreadfishEntity.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.dreadfishEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.dreadfishEntity.func_70659_e(MathHelper.func_219799_g((float)1.5f, (float)this.dreadfishEntity.func_70689_ay(), (float)f1));
                this.dreadfishEntity.func_213317_d(this.dreadfishEntity.func_213322_ci().func_72441_c(0.0, (double)this.dreadfishEntity.func_70689_ay() * (d1 /= d3) * 0.01, 0.0));
            } else {
                this.dreadfishEntity.func_70659_e(0.0f);
            }
        }
    }

    static class SwimGoal
    extends RandomFlyingGoal {
        private final DreadfishEntity dreadfishEntity;

        public SwimGoal(DreadfishEntity dreadfishEntity) {
            super(dreadfishEntity, 0.8, 40);
            this.dreadfishEntity = dreadfishEntity;
        }

        public boolean func_75250_a() {
            return this.dreadfishEntity.execute() && super.func_75250_a();
        }
    }
}

