/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.entities;

import com.vulp.druidcraft.entities.LunarMothColors;
import com.vulp.druidcraft.items.LunarMothJarItem;
import com.vulp.druidcraft.registry.ItemRegistry;
import com.vulp.druidcraft.registry.ParticleRegistry;
import com.vulp.druidcraft.registry.SoundEventRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class LunarMothEntity
extends AnimalEntity {
    private static final DataParameter<Boolean> RESTING = EntityDataManager.func_187226_a(LunarMothEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Direction> IDLING = EntityDataManager.func_187226_a(LunarMothEntity.class, (IDataSerializer)DataSerializers.field_187202_l);
    public static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(LunarMothEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final EntityPredicate entityPredicate = new EntityPredicate().func_221013_a(4.0).func_221011_b();
    public int timeUntilDropGlowstone;
    private BlockPos spawnPosition;

    public LunarMothEntity(EntityType<? extends LunarMothEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.timeUntilDropGlowstone = this.field_70146_Z.nextInt(10000) + 10000;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RESTING, (Object)false);
        this.field_70180_af.func_187214_a(IDLING, (Object)Direction.NORTH);
        this.field_70180_af.func_187214_a(COLOR, (Object)LunarMothColors.colorToInt(LunarMothColors.randomColor(this.field_70146_Z)));
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (item == Items.field_151069_bo) {
            player.func_130014_f_().func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEventRegistry.fill_bottle, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            this.bottleToMothJar(itemstack, player);
            this.func_70106_y();
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void bottleToMothJar(ItemStack itemstack, PlayerEntity player) {
        itemstack.func_190918_g(1);
        ItemStack stack = LunarMothJarItem.getItemStackByColor(this.getColor());
        CompoundNBT entityData = new CompoundNBT();
        this.func_213281_b(entityData);
        stack.func_196082_o().func_218657_a("EntityTag", (INBT)entityData);
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    public boolean getMothResting() {
        return (Boolean)this.field_70180_af.func_187225_a(RESTING);
    }

    public LunarMothColors getColor() {
        return LunarMothColors.colorArray().get((Integer)this.field_70180_af.func_187225_a(COLOR));
    }

    public Direction getMothIdleDirection() {
        return (Direction)this.field_70180_af.func_187225_a(IDLING);
    }

    public void setMothResting(boolean resting) {
        this.field_70180_af.func_187227_b(RESTING, (Object)resting);
    }

    public void setMothIdleDirection(Direction direction) {
        this.field_70180_af.func_187227_b(IDLING, (Object)direction);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getMothResting()) {
            this.func_213317_d(Vec3d.field_186680_a);
        } else {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = new BlockPos((Entity)this);
        BlockPos blockpos1 = blockpos.func_177984_a();
        if (this.getMothResting()) {
            if (this.field_70170_p.func_180495_p(blockpos1).func_215686_e((IBlockReader)this.field_70170_p, blockpos)) {
                if (this.field_70146_Z.nextInt(200) == 0) {
                    this.field_70759_as = this.field_70146_Z.nextInt(360);
                }
                if (this.field_70170_p.func_217370_a(entityPredicate, (LivingEntity)this) != null) {
                    this.setMothResting(false);
                    this.field_70170_p.func_217378_a(null, 1025, blockpos, 0);
                }
            } else {
                this.setMothResting(false);
                this.field_70170_p.func_217378_a(null, 1025, blockpos, 0);
            }
        } else {
            if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
                this.spawnPosition = null;
            }
            if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_218137_a((IPosition)this.func_213303_ch(), 2.0)) {
                this.spawnPosition = new BlockPos(this.field_70165_t + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7), this.field_70163_u + (double)this.field_70146_Z.nextInt(6) - 2.0, this.field_70161_v + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7));
            }
            double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.field_70165_t;
            double d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.field_70163_u;
            double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.field_70161_v;
            Vec3d vec3d = this.func_213322_ci();
            Vec3d vec3d1 = vec3d.func_72441_c((Math.signum(d0) * 0.5 - vec3d.field_72450_a) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.field_72448_b) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.field_72449_c) * (double)0.1f);
            this.func_213317_d(vec3d1);
            float f = (float)(MathHelper.func_181159_b((double)vec3d1.field_72449_c, (double)vec3d1.field_72450_a) * 57.2957763671875) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += f1;
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.getMothResting()) {
            this.setMothResting(false);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(RESTING, (Object)compound.func_74767_n("MothResting"));
        this.field_70180_af.func_187227_b(IDLING, (Object)Direction.func_82600_a((int)compound.func_74771_c("MothIdleDirection")));
        this.field_70180_af.func_187227_b(COLOR, (Object)compound.func_74762_e("Color"));
        if (compound.func_74764_b("GlowstoneDropTime")) {
            this.timeUntilDropGlowstone = compound.func_74762_e("GlowstoneDropTime");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("MothResting", ((Boolean)this.field_70180_af.func_187225_a(RESTING)).booleanValue());
        compound.func_74774_a("MothIdleDirection", (byte)((Direction)this.field_70180_af.func_187225_a(IDLING)).func_176745_a());
        compound.func_74768_a("Color", ((Integer)this.field_70180_af.func_187225_a(COLOR)).intValue());
        compound.func_74768_a("GlowstoneDropTime", this.timeUntilDropGlowstone);
    }

    public static boolean placement(EntityType<LunarMothEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150350_a;
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && --this.timeUntilDropGlowstone <= 0) {
            if (this.field_70146_Z.nextInt(7) == 0) {
                int eggColor;
                ItemStack eggItem;
                if (this.getColor() == LunarMothColors.LIME) {
                    eggItem = new ItemStack((IItemProvider)ItemRegistry.lunar_moth_egg_lime);
                    eggColor = 2;
                } else if (this.getColor() == LunarMothColors.ORANGE) {
                    eggItem = new ItemStack((IItemProvider)ItemRegistry.lunar_moth_egg_orange);
                    eggColor = 4;
                } else if (this.getColor() == LunarMothColors.YELLOW) {
                    eggItem = new ItemStack((IItemProvider)ItemRegistry.lunar_moth_egg_yellow);
                    eggColor = 3;
                } else if (this.getColor() == LunarMothColors.PINK) {
                    eggItem = new ItemStack((IItemProvider)ItemRegistry.lunar_moth_egg_pink);
                    eggColor = 5;
                } else if (this.getColor() == LunarMothColors.WHITE) {
                    eggItem = new ItemStack((IItemProvider)ItemRegistry.lunar_moth_egg_white);
                    eggColor = 1;
                } else {
                    eggItem = new ItemStack((IItemProvider)ItemRegistry.lunar_moth_egg_turquoise);
                    eggColor = 0;
                }
                CompoundNBT tag = eggItem.func_196082_o();
                CompoundNBT entityData = new CompoundNBT();
                entityData.func_74768_a("Color", eggColor);
                tag.func_218657_a("EntityData", (INBT)entityData);
                this.func_199701_a_(eggItem);
            } else {
                this.func_199703_a((IItemProvider)Items.field_151114_aO);
            }
            this.timeUntilDropGlowstone = this.field_70146_Z.nextInt(10000) + 10000;
        }
        if (this.field_70170_p.field_72995_K) {
            int red = 1;
            int green = 1;
            int blue = 1;
            if (this.getColor() == LunarMothColors.TURQUOISE) {
                red = 85;
                green = 255;
                blue = 160;
            }
            if (this.getColor() == LunarMothColors.PINK) {
                red = 255;
                green = 200;
                blue = 240;
            }
            if (this.getColor() == LunarMothColors.LIME) {
                red = 180;
                green = 255;
                blue = 110;
            }
            if (this.getColor() == LunarMothColors.ORANGE) {
                red = 255;
                green = 200;
                blue = 80;
            }
            if (this.getColor() == LunarMothColors.WHITE) {
                red = 255;
                green = 250;
                blue = 240;
            }
            if (this.getColor() == LunarMothColors.YELLOW) {
                red = 255;
                green = 255;
                blue = 140;
            }
            float colorMod = this.field_70146_Z.nextInt(3) == 3 ? 1.1f : (this.field_70146_Z.nextInt(3) == 3 ? 0.9f : 1.0f);
            if (this.field_70146_Z.nextBoolean()) {
                this.field_70170_p.func_195590_a((IParticleData)ParticleRegistry.magic_glitter, false, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) / 3.0, this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5) / 3.0 + 0.2, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) / 3.0, (double)((float)red / 255.0f * colorMod), (double)((float)green / 255.0f * colorMod), (double)((float)blue / 255.0f * colorMod));
            }
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b / 2.0f;
    }
}

