/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.registry;

import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FeatureRegistry {
    public static Feature<NoFeatureConfig> elder_tree;
    public static Feature<NoFeatureConfig> blueberry_bush;
    public static Feature<NoFeatureConfig> lavender;

    public static <V extends R, R extends IForgeRegistryEntry<R>> V register(IForgeRegistry<R> registry, V feature, String name) {
        ResourceLocation id = new ResourceLocation("druidcraft", name);
        feature.setRegistryName(id);
        registry.register(feature);
        return feature;
    }

    public static void spawnFeatures() {
        FeatureRegistry.addBlueberryBushes();
        FeatureRegistry.addElderTrees();
        FeatureRegistry.addLavenderPatches();
    }

    public static void addElderTrees() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if ((BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.FOREST) || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.HILLS) || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.PLAINS) || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.MOUNTAIN)) && BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.WET)) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(elder_tree, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.02f, 1)));
                continue;
            }
            if (!BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.FOREST) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.HILLS) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.PLAINS) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.MOUNTAIN)) continue;
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(elder_tree, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.01f, 1)));
        }
    }

    public static void addBlueberryBushes() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (!BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.FOREST) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.HILLS) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.PLAINS) || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.CONIFEROUS)) continue;
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(blueberry_bush, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(1)));
        }
    }

    public static void addLavenderPatches() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (!BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.PLAINS) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.FOREST)) continue;
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(lavender, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(1)));
        }
    }
}

