/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.world.features;

import com.mojang.datafixers.Dynamic;
import com.vulp.druidcraft.blocks.WoodBlock;
import com.vulp.druidcraft.registry.BlockRegistry;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class ElderTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState TRUNK = BlockRegistry.elder_log.func_176223_P();
    private static final BlockState BASE = (BlockState)BlockRegistry.elder_wood.func_176223_P().func_206870_a((IProperty)WoodBlock.dropSelf, (Comparable)Boolean.valueOf(false));
    private static final BlockState LEAF = BlockRegistry.elder_leaves.func_176223_P();

    public ElderTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean doBlockNotifyOnPlace) {
        super(config, doBlockNotifyOnPlace);
        this.setSapling((IPlantable)BlockRegistry.elder_sapling);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundsIn) {
        int height = rand.nextInt(2) + 6;
        boolean canGrow = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int cy = position.func_177956_o(); cy <= position.func_177956_o() + 1 + height; ++cy) {
                int k = 1;
                if (cy == position.func_177956_o()) {
                    k = 0;
                }
                if (cy >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int cx = position.func_177958_n() - k; cx <= position.func_177958_n() + k && canGrow; ++cx) {
                    for (int cz = position.func_177952_p() - k; cz <= position.func_177952_p() + k && canGrow; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            if (ElderTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(cx, cy, cz))) continue;
                            canGrow = false;
                            continue;
                        }
                        canGrow = false;
                    }
                }
            }
            if (!canGrow) {
                return false;
            }
            if (ElderTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - height - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int posY = 0;
                int logSide1 = rand.nextInt(3);
                int logSide2 = rand.nextInt(3);
                if (logSide2 == logSide1 && (logSide2 = rand.nextInt(3)) == logSide1) {
                    logSide2 = 4;
                }
                for (int base = 0; base < height; ++base) {
                    int currentY = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, currentY, posZ);
                    if (!ElderTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) continue;
                    if (base == 0) {
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos.func_177978_c().func_177977_b())) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177978_c().func_177977_b(), boundsIn, true);
                            } else {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177978_c(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos.func_177974_f().func_177977_b())) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177974_f().func_177977_b(), boundsIn, true);
                            } else {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177974_f(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos.func_177968_d().func_177977_b())) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177968_d().func_177977_b(), boundsIn, true);
                            } else {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177968_d(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos.func_177976_e().func_177977_b())) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177976_e().func_177977_b(), boundsIn, true);
                            } else {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177976_e(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos.func_177978_c().func_177974_f().func_177977_b())) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177978_c().func_177974_f().func_177977_b(), boundsIn, true);
                            } else {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177978_c().func_177974_f(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos.func_177978_c().func_177976_e().func_177977_b())) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177978_c().func_177976_e().func_177977_b(), boundsIn, true);
                            } else {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177978_c().func_177976_e(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos.func_177968_d().func_177974_f().func_177977_b())) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177968_d().func_177974_f().func_177977_b(), boundsIn, true);
                            } else {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177968_d().func_177974_f(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos.func_177968_d().func_177976_e().func_177977_b())) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177968_d().func_177976_e().func_177977_b(), boundsIn, true);
                            } else {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177968_d().func_177976_e(), boundsIn, true);
                            }
                        }
                        this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos, boundsIn, false);
                    }
                    if (base <= height - 1) {
                        this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos, boundsIn, false);
                        if (base == height - 2 || base == height - 3) {
                            if (logSide1 == 0) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177964_d(1), boundsIn, Direction.Axis.Z);
                            }
                            if (logSide1 == 1) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177965_g(1), boundsIn, Direction.Axis.X);
                            }
                            if (logSide1 == 2) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177970_e(1), boundsIn, Direction.Axis.Z);
                            }
                            if (logSide1 == 3) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177985_f(1), boundsIn, Direction.Axis.X);
                            }
                        }
                        if (base == height - 2 || base == height - 3) {
                            if (logSide1 == 0) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177964_d(1), boundsIn, Direction.Axis.Z);
                            }
                            if (logSide1 == 1) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177965_g(1), boundsIn, Direction.Axis.X);
                            }
                            if (logSide1 == 2) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177970_e(1), boundsIn, Direction.Axis.Z);
                            }
                            if (logSide1 == 3) {
                                this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177985_f(1), boundsIn, Direction.Axis.X);
                            }
                        }
                    }
                    posY = currentY;
                }
                BlockPos blockpos2 = new BlockPos(posX, posY, posZ).func_177977_b();
                for (int leafLayer1and3X = -3; leafLayer1and3X <= 3; ++leafLayer1and3X) {
                    for (int leafLayer1and3Z = -3; leafLayer1and3Z <= 3; ++leafLayer1and3Z) {
                        if ((leafLayer1and3X == 3 || leafLayer1and3X == -3) && (leafLayer1and3Z == 3 || leafLayer1and3Z == -3)) continue;
                        if (leafLayer1and3X == -3 && (leafLayer1and3Z == -2 || leafLayer1and3Z == 2) || leafLayer1and3X == 3 && (leafLayer1and3Z == -2 || leafLayer1and3Z == 2) || leafLayer1and3Z == -3 && (leafLayer1and3X == -2 || leafLayer1and3X == 2) || leafLayer1and3Z == 3 && (leafLayer1and3X == -2 || leafLayer1and3X == 2)) {
                            if (rand.nextBoolean() || rand.nextBoolean()) {
                                this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(leafLayer1and3X, 0, leafLayer1and3Z), boundsIn);
                            }
                            if (!rand.nextBoolean() && !rand.nextBoolean()) continue;
                            this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(leafLayer1and3X, -2, leafLayer1and3Z), boundsIn);
                            continue;
                        }
                        this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(leafLayer1and3X, 0, leafLayer1and3Z), boundsIn);
                        this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(leafLayer1and3X, -2, leafLayer1and3Z), boundsIn);
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int leafLayer4X = -2; leafLayer4X <= 2; ++leafLayer4X) {
                    for (int leafLayer4Z = -2; leafLayer4Z <= 2; ++leafLayer4Z) {
                        if (leafLayer4X != -2 && leafLayer4X != 2 || leafLayer4Z != -2 && leafLayer4Z != 2) {
                            this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(leafLayer4X, 0, leafLayer4Z), boundsIn);
                            continue;
                        }
                        if (!rand.nextBoolean()) continue;
                        this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(leafLayer4X, 0, leafLayer4Z), boundsIn);
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int leafLayer5X = -1; leafLayer5X <= 1; ++leafLayer5X) {
                    for (int leafLayer5Z = -1; leafLayer5Z <= 1; ++leafLayer5Z) {
                        if ((leafLayer5X == -1 || leafLayer5X == 1) && (leafLayer5Z == -1 || leafLayer5Z == 1)) continue;
                        this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(leafLayer5X, 0, leafLayer5Z), boundsIn);
                    }
                }
                blockpos2 = blockpos2.func_177979_c(3);
                for (int leafLayer2X = -3; leafLayer2X <= 3; ++leafLayer2X) {
                    for (int leafLayer2Z = -3; leafLayer2Z <= 3; ++leafLayer2Z) {
                        if ((leafLayer2X == -3 || leafLayer2X == 3) && (leafLayer2Z == -3 || leafLayer2Z == 3)) continue;
                        this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(leafLayer2X, 0, leafLayer2Z), boundsIn);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLogAt(Set<BlockPos> setPos, IWorldWriter writer, BlockPos pos, MutableBoundingBox boundingBox, boolean isBaseWood) {
        BlockState blockType = TRUNK;
        Random rand = new Random();
        if (isBaseWood) {
            blockType = rand.nextInt(3) == 0 ? (BlockState)BASE.func_206870_a((IProperty)WoodBlock.field_176298_M, (Comparable)Direction.Axis.X) : (rand.nextInt(3) == 0 ? (BlockState)BASE.func_206870_a((IProperty)WoodBlock.field_176298_M, (Comparable)Direction.Axis.Y) : (BlockState)BASE.func_206870_a((IProperty)WoodBlock.field_176298_M, (Comparable)Direction.Axis.Z));
        }
        this.func_208520_a(setPos, writer, pos, blockType, boundingBox);
    }

    private void placeLogAt(Set<BlockPos> setPos, IWorldWriter writer, BlockPos pos, MutableBoundingBox boundingBox, Direction.Axis setAxis) {
        BlockState blockType = (BlockState)TRUNK.func_177230_c().func_176223_P().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)setAxis);
        this.func_208520_a(setPos, writer, pos, blockType, boundingBox);
    }

    private void placeLeafAt(Set<BlockPos> worldIn, IWorldGenerationReader writer, BlockPos pos, MutableBoundingBox boundingBox) {
        if (ElderTreeFeature.func_214572_g((IWorldGenerationBaseReader)writer, (BlockPos)pos)) {
            this.func_208520_a(worldIn, (IWorldWriter)writer, pos, LEAF, boundingBox);
        }
    }
}

