/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.blocks;

import com.vulp.druidcraft.blocks.DynamicCropBlock;
import com.vulp.druidcraft.registry.ItemRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class AloeVeraBlock
extends DynamicCropBlock
implements IGrowable,
IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208167_T;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0)};

    public AloeVeraBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_AGE[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
    }

    @Override
    public IntegerProperty func_185524_e() {
        return AGE;
    }

    public int func_185526_g() {
        return 2;
    }

    @Override
    public boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return BlockTags.field_203436_u.func_199685_a_((Object)state.func_177230_c());
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        float f;
        int i;
        super.func_225534_a_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= 9 && (i = this.func_185527_x(state)) < this.func_185526_g() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / (f = AloeVeraBlock.getGrowthChance((Block)this, (IBlockReader)worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, this.func_185528_e(i + 1), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public static float getGrowthChance(Block blockIn, IBlockReader worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (blockstate.canSustainPlant(worldIn, blockpos.func_177982_a(i, 0, j), Direction.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(worldIn, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos3).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos1).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f / 3.0f;
    }

    protected IItemProvider func_199772_f() {
        return ItemRegistry.aloe_vera;
    }

    protected int func_185529_b(World worldIn) {
        return 1;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE});
    }
}

