/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeDimension;

public class BedrollBlock
extends BedBlock
implements IBucketPickupHandler,
ILiquidContainer {
    private final DyeColor color;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BedrollBlock(DyeColor colorIn, Block.Properties properties) {
        super(colorIn, properties);
        this.color = colorIn;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((IProperty)field_176471_b, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, field_176472_a, field_176471_b, WATERLOGGED});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        if (state.func_177229_b((IProperty)field_176472_a) != BedPart.HEAD && (state = worldIn.func_180495_p(pos = pos.func_177972_a((Direction)state.func_177229_b((IProperty)field_185512_D)))).func_177230_c() != this) {
            return ActionResultType.CONSUME;
        }
        IForgeDimension.SleepResult sleepResult = worldIn.field_73011_w.canSleepAt(player, pos);
        if (sleepResult != IForgeDimension.SleepResult.BED_EXPLODES) {
            if (sleepResult == IForgeDimension.SleepResult.DENY) {
                return ActionResultType.SUCCESS;
            }
            if (((Boolean)state.func_177229_b((IProperty)field_176471_b)).booleanValue()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("block.druidcraft.bedroll.occupied", new Object[0]), true);
                return ActionResultType.SUCCESS;
            }
            player.func_213819_a(pos).ifLeft(p_220173_1_ -> {
                if (p_220173_1_ != null) {
                    player.func_146105_b(p_220173_1_.func_221259_a(), true);
                }
            });
            return ActionResultType.SUCCESS;
        }
        worldIn.func_217377_a(pos, false);
        BlockPos blockpos = pos.func_177972_a(((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176734_d());
        if (worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_217377_a(blockpos, false);
        }
        worldIn.func_217401_a((Entity)null, DamageSource.func_199683_a(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
        return ActionResultType.SUCCESS;
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return fluidIn == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        if (fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            }
            return true;
        }
        return false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean water = context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() == Blocks.field_150355_j;
        BlockState state = super.func_196258_a(context);
        if (state == null) {
            return null;
        }
        return (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        if (!Screen.hasShiftDown()) {
            tooltip.add(new TranslationTextComponent("block.druidcraft.hold_shift", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true))));
        } else {
            tooltip.add(new TranslationTextComponent("block.druidcraft.bedroll.description1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true))));
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b((IProperty)field_176472_a) == BedPart.FOOT) {
            Direction direction = (Direction)state.func_177229_b((IProperty)field_185512_D);
            if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                return Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)16.0);
            }
            return Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)15.0);
        }
        Direction direction = ((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176734_d();
        VoxelShape matNS = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)16.0);
        VoxelShape matEW = Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)15.0);
        switch (direction) {
            case NORTH: {
                return VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)9.0, (double)14.0, (double)4.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)3.0, (double)8.0)), (VoxelShape)matNS);
            }
            case SOUTH: {
                return VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)2.0, (double)2.0, (double)1.0, (double)14.0, (double)4.0, (double)7.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0, (double)14.0)), (VoxelShape)matNS);
            }
            case WEST: {
                return VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)9.0, (double)0.0, (double)2.0, (double)15.0, (double)4.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)0.0, (double)8.0, (double)3.0, (double)16.0)), (VoxelShape)matEW);
            }
        }
        return VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)2.0, (double)7.0, (double)4.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)14.0, (double)3.0, (double)16.0)), (VoxelShape)matEW);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((IProperty)field_185512_D);
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                return Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)16.0);
            }
        }
        return Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)15.0);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

