/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.blocks;

import com.google.common.collect.Maps;
import com.vulp.druidcraft.Druidcraft;
import com.vulp.druidcraft.api.IKnifeable;
import com.vulp.druidcraft.blocks.GrowthLampBlock;
import com.vulp.druidcraft.blocks.RopeLanternBlock;
import com.vulp.druidcraft.blocks.RopeableLanternBlock;
import com.vulp.druidcraft.blocks.SmallBeamBlock;
import com.vulp.druidcraft.registry.BlockRegistry;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RopeBlock
extends Block
implements IKnifeable {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty KNOTTED = BooleanProperty.func_177716_a((String)"knotted");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, EAST);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
        map.put(Direction.UP, UP);
        map.put(Direction.DOWN, DOWN);
    });

    public RopeBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)KNOTTED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ActionResultType onKnife(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos);
        Vec3d relative = context.func_221532_j().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Druidcraft.LOGGER.debug("onKnife: {}", (Object)relative);
        Direction side = RopeBlock.getClickedConnection(relative);
        if (side != null && !(world.func_180495_p(pos.func_177972_a(side)).func_177230_c() instanceof RopeBlock)) {
            BlockState state1 = this.cycleProperty(state, side, context);
            world.func_180501_a(pos, state1, 18);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private BlockState cycleProperty(BlockState state, Direction sideUsed, ItemUseContext context) {
        BooleanProperty property = FACING_TO_PROPERTY_MAP.get(sideUsed);
        if (!context.func_195999_j().func_225608_bj_()) {
            if (((Boolean)state.func_177229_b((IProperty)property)).booleanValue()) {
                return this.calculateKnot((BlockState)state.func_206870_a((IProperty)property, (Comparable)Boolean.valueOf(false)));
            }
            if (context.func_195991_k().func_180495_p(context.func_195995_a()).func_224755_d((IBlockReader)context.func_195991_k(), context.func_195995_a().func_177972_a(sideUsed), sideUsed)) {
                return this.calculateKnot((BlockState)state.func_206870_a((IProperty)property, (Comparable)Boolean.valueOf(true)));
            }
        } else if (context.func_195999_j().func_225608_bj_()) {
            if (!((Boolean)state.func_177229_b((IProperty)KNOTTED)).booleanValue()) {
                return (BlockState)state.func_206870_a((IProperty)KNOTTED, (Comparable)Boolean.valueOf(true));
            }
            if (!((Boolean)this.calculateKnot(state).func_177229_b((IProperty)KNOTTED)).booleanValue()) {
                return (BlockState)state.func_206870_a((IProperty)KNOTTED, (Comparable)Boolean.valueOf(false));
            }
        }
        return this.calculateState(state, (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    @Nullable
    private static Direction getClickedConnection(Vec3d relative) {
        if (relative.field_72450_a < 0.25) {
            return Direction.WEST;
        }
        if (relative.field_72450_a > 0.75) {
            return Direction.EAST;
        }
        if (relative.field_72448_b < 0.25) {
            return Direction.DOWN;
        }
        if (relative.field_72448_b > 0.75) {
            return Direction.UP;
        }
        if (relative.field_72449_c < 0.25) {
            return Direction.NORTH;
        }
        if (relative.field_72449_c > 0.75) {
            return Direction.SOUTH;
        }
        return null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0));
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0));
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0));
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0));
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
        }
        return shape;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, KNOTTED, WATERLOGGED});
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.calculateState(this.func_176223_P(), (IWorld)context.func_195991_k(), context.func_195995_a()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    private BlockState calculateKnot(BlockState currentState) {
        int count = 0;
        if (((Boolean)currentState.func_177229_b((IProperty)NORTH)).booleanValue()) {
            ++count;
        }
        if (((Boolean)currentState.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            ++count;
        }
        if (((Boolean)currentState.func_177229_b((IProperty)EAST)).booleanValue()) {
            ++count;
        }
        if (((Boolean)currentState.func_177229_b((IProperty)WEST)).booleanValue()) {
            ++count;
        }
        if (((Boolean)currentState.func_177229_b((IProperty)UP)).booleanValue()) {
            ++count;
        }
        if (((Boolean)currentState.func_177229_b((IProperty)DOWN)).booleanValue()) {
            ++count;
        }
        boolean doKnot = count > 2 || count == 0;
        return (BlockState)currentState.func_206870_a((IProperty)KNOTTED, (Comparable)Boolean.valueOf(doKnot));
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return this.calculateState(state, world, currentPos);
    }

    private BlockState calculateState(BlockState currentState, IWorld world, BlockPos pos) {
        BlockState finalState;
        boolean northType = false;
        BlockState northState = world.func_180495_p(pos.func_177972_a(Direction.NORTH));
        if (northState.func_224755_d((IBlockReader)world, pos.func_177972_a(Direction.NORTH), Direction.NORTH.func_176734_d()) || northState.func_177230_c() instanceof RopeBlock || northState.func_177230_c() instanceof SmallBeamBlock) {
            northType = true;
        }
        boolean eastType = false;
        BlockState eastState = world.func_180495_p(pos.func_177972_a(Direction.EAST));
        if (eastState.func_224755_d((IBlockReader)world, pos.func_177972_a(Direction.EAST), Direction.EAST.func_176734_d()) || eastState.func_177230_c() instanceof RopeBlock || eastState.func_177230_c() instanceof SmallBeamBlock) {
            eastType = true;
        }
        boolean southType = false;
        BlockState southState = world.func_180495_p(pos.func_177972_a(Direction.SOUTH));
        if (southState.func_224755_d((IBlockReader)world, pos.func_177972_a(Direction.SOUTH), Direction.SOUTH.func_176734_d()) || southState.func_177230_c() instanceof RopeBlock || southState.func_177230_c() instanceof SmallBeamBlock) {
            southType = true;
        }
        boolean westType = false;
        BlockState westState = world.func_180495_p(pos.func_177972_a(Direction.WEST));
        if (westState.func_224755_d((IBlockReader)world, pos.func_177972_a(Direction.WEST), Direction.WEST.func_176734_d()) || westState.func_177230_c() instanceof RopeBlock || westState.func_177230_c() instanceof SmallBeamBlock) {
            westType = true;
        }
        boolean upType = false;
        BlockState upState = world.func_180495_p(pos.func_177972_a(Direction.UP));
        if (upState.func_224755_d((IBlockReader)world, pos.func_177972_a(Direction.UP), Direction.UP.func_176734_d()) || upState.func_177230_c() instanceof RopeBlock || upState.func_177230_c() instanceof SmallBeamBlock) {
            upType = true;
        }
        boolean downType = false;
        BlockState downState = world.func_180495_p(pos.func_177972_a(Direction.DOWN));
        if (downState.func_224755_d((IBlockReader)world, pos.func_177972_a(Direction.DOWN), Direction.DOWN.func_176734_d()) || downState.func_177230_c() instanceof RopeBlock || downState.func_177230_c() instanceof RopeLanternBlock || downState.func_177230_c() instanceof SmallBeamBlock || (downState.func_177230_c() instanceof RopeableLanternBlock || downState.func_177230_c() instanceof GrowthLampBlock) && ((Boolean)downState.func_177229_b((IProperty)RopeableLanternBlock.HANGING)).booleanValue() && ((Boolean)downState.func_177229_b((IProperty)RopeableLanternBlock.ROPED)).booleanValue()) {
            downType = true;
        }
        if ((finalState = this.calculateKnot((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)currentState.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(northType))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(eastType))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(southType))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(westType))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(upType))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(downType)))) == currentState) {
            return currentState;
        }
        return finalState;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item == Items.field_222111_pQ && hit.func_216354_b() == Direction.DOWN && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76222_j()) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            worldIn.func_175656_a(pos.func_177977_b(), BlockRegistry.rope_lantern.func_176223_P());
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_219640_fO, SoundCategory.BLOCKS, 1.0f, 0.88f, true);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }
}

