/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.blocks.tileentities;

import com.vulp.druidcraft.api.CrateIndex;
import com.vulp.druidcraft.api.CrateType;
import com.vulp.druidcraft.blocks.CrateBlock;
import com.vulp.druidcraft.inventory.container.CrateContainer;
import com.vulp.druidcraft.registry.BlockRegistry;
import com.vulp.druidcraft.registry.GUIRegistry;
import com.vulp.druidcraft.registry.SoundEventRegistry;
import com.vulp.druidcraft.registry.TileEntityRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class CrateTileEntity
extends TileEntity
implements INamedContainerProvider {
    private ItemStackHandler inventory = new ItemStackHandler(27);
    private int numPlayersUsing;
    private UUID crateId = UUID.randomUUID();
    private ITextComponent displayName;

    public CrateTileEntity() {
        super(TileEntityRegistry.crate);
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        compound.func_186854_a("uuid", this.crateId);
        return compound;
    }

    public void func_145839_a(@Nonnull CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("Items", 9)) {
            NonNullList items = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)items);
            this.inventory = new ItemStackHandler(items);
        } else {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (compound.func_186855_b("uuid")) {
            this.crateId = compound.func_186857_a("uuid");
        } else if (this.crateId == null) {
            this.crateId = UUID.randomUUID();
        }
    }

    public void crateTick() {
        if (this.field_145850_b == null) {
            return;
        }
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        BlockState blockState = this.field_145850_b.func_180495_p(new BlockPos(i, j, k));
        this.numPlayersUsing = CrateTileEntity.calculatePlayersUsing(this.field_145850_b, i, j, k);
        if (this.numPlayersUsing > 0) {
            this.scheduleTick();
        } else {
            BlockState blockstate = this.func_195044_w();
            if (blockstate.func_177230_c() != BlockRegistry.crate) {
                this.func_145843_s();
                return;
            }
            boolean flag = (Boolean)blockstate.func_177229_b((IProperty)CrateBlock.PROPERTY_OPEN);
            if (flag) {
                if (((CrateIndex)((Object)blockState.func_177229_b(CrateBlock.INDEX))).isParent()) {
                    this.playSound(blockState, SoundEventRegistry.close_crate);
                }
                this.setCrateState(blockstate, false);
            }
        }
    }

    private static int calculatePlayersUsing(World world, int posX, int posY, int posZ) {
        int i = 0;
        float f = 6.0f;
        HashSet inventoryIds = new HashSet();
        CrateBlock.getBlockPositions(world, new BlockPos(posX, posY, posZ)).forEach(o -> {
            TileEntity te = world.func_175625_s(o);
            if (te instanceof CrateTileEntity) {
                inventoryIds.add(((CrateTileEntity)te).getCrateId());
            }
        });
        for (PlayerEntity playerentity : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)posX - f), (double)((float)posY - f), (double)((float)posZ - f), (double)((float)(posX + 1) + f), (double)((float)(posY + 1) + f), (double)((float)(posZ + 1) + f)))) {
            CrateContainer crate;
            CrateTileEntity tile;
            if (!(playerentity.field_71070_bA instanceof CrateContainer) || (tile = (crate = (CrateContainer)playerentity.field_71070_bA).getCrate()) == null || !inventoryIds.contains(tile.getCrateId())) continue;
            ++i;
        }
        return i;
    }

    public void openInventory(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            BlockState blockstate = this.func_195044_w();
            boolean flag = (Boolean)blockstate.func_177229_b((IProperty)CrateBlock.PROPERTY_OPEN);
            if (!flag) {
                if (((CrateIndex)((Object)blockstate.func_177229_b(CrateBlock.INDEX))).isParent()) {
                    this.playSound(blockstate, SoundEventRegistry.open_crate);
                }
                this.setCrateState(blockstate, true);
            }
            this.scheduleTick();
        }
    }

    private void scheduleTick() {
        if (this.field_145850_b != null) {
            Block block = this.func_195044_w().func_177230_c();
            this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)block, 5);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(this::getFullInventory).cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Nonnull
    private IItemHandlerModifiable getFullInventory() {
        if (this.field_145850_b == null) {
            return this.inventory;
        }
        ArrayList<BlockPos> neighbors = CrateBlock.getBlockPositions(this.field_145850_b, this.field_174879_c);
        int size = neighbors.size();
        if (size != 2 && size != 4 && size != 8) {
            return this.getInventory();
        }
        List tiles = neighbors.stream().map(o -> this.field_145850_b.func_175625_s(o)).collect(Collectors.toList());
        ArrayList<CrateTileEntity> crates = new ArrayList<CrateTileEntity>();
        for (TileEntity te : tiles) {
            if (!(te instanceof CrateTileEntity)) {
                throw new IllegalStateException("Neighbouring tile entity of crate is not a crate tile entity.");
            }
            crates.add((CrateTileEntity)te);
        }
        crates.sort(Comparator.comparing(CrateTileEntity::getCrateId));
        ItemStackHandler[] handlers = (ItemStackHandler[])crates.stream().map(CrateTileEntity::getInventory).toArray(ItemStackHandler[]::new);
        return new CombinedInvWrapper((IItemHandlerModifiable[])handlers);
    }

    private UUID getCrateId() {
        return this.crateId;
    }

    public void closeInventory(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
        }
    }

    private void setCrateState(BlockState state, boolean open) {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)state.func_206870_a((IProperty)CrateBlock.PROPERTY_OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    private float checkCrateShape(BlockState state) {
        CrateType type = ((CrateIndex)((Object)state.func_177229_b(CrateBlock.INDEX))).getType();
        if (type == CrateType.DOUBLE_X || type == CrateType.DOUBLE_Y || type == CrateType.DOUBLE_Z) {
            return 0.8f;
        }
        if (type == CrateType.QUAD_X || type == CrateType.QUAD_Y || type == CrateType.QUAD_Z) {
            return 0.7f;
        }
        if (type == CrateType.OCTO) {
            return 0.6f;
        }
        return 0.9f;
    }

    private void playSound(BlockState state, SoundEvent p_213965_2_) {
        if (this.field_145850_b != null) {
            double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
            double d1 = (double)this.field_174879_c.func_177956_o() + 0.5;
            double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
            this.field_145850_b.func_184148_a(null, d0, d1, d2, p_213965_2_, SoundCategory.BLOCKS, 0.65f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + this.checkCrateShape(state));
        }
    }

    public void setDisplayName(ITextComponent name) {
        this.displayName = name;
    }

    public ITextComponent func_145748_c_() {
        return this.displayName == null ? new TranslationTextComponent("block.druidcraft.crate", new Object[0]) : this.displayName;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        ContainerType type;
        IItemHandlerModifiable inventory = this.getFullInventory();
        int numRows = inventory.getSlots() / 9;
        switch (numRows) {
            default: {
                type = GUIRegistry.generic_9X3;
                break;
            }
            case 6: {
                type = GUIRegistry.generic_9X6;
                break;
            }
            case 12: {
                type = GUIRegistry.generic_9X12;
                break;
            }
            case 24: {
                type = GUIRegistry.generic_9X24;
            }
        }
        return new CrateContainer(type, i, playerInventory, (IItemHandler)inventory, numRows, this);
    }
}

