/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.vulp.druidcraft.inventory.container.WoodcutterContainer;
import com.vulp.druidcraft.recipes.WoodcuttingRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WoodcutterScreen
extends ContainerScreen<WoodcutterContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("textures/gui/container/stonecutter.png");
    private float sliderProgress;
    private boolean clickedOnSroll;
    private int recipeIndexOffset;
    private boolean hasItemsInInputSlot;

    public WoodcutterScreen(WoodcutterContainer p_i51076_1_, PlayerInventory p_i51076_2_, ITextComponent p_i51076_3_) {
        super((Container)p_i51076_1_, p_i51076_2_, p_i51076_3_);
        p_i51076_1_.setInventoryUpdateListener(this::onInventoryUpdate);
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        super.render(p_render_1_, p_render_2_, p_render_3_);
        this.func_191948_b(p_render_1_, p_render_2_);
    }

    protected void func_146979_b(int p_146979_1_, int p_146979_2_) {
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 4.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 94), 0x404040);
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        this.blit(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        int progress = (int)(41.0f * this.sliderProgress);
        this.blit(left + 119, top + 15 + progress, 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int offsetX = this.field_147003_i + 52;
        int offsetY = this.field_147009_r + 14;
        int recipeOffset = this.recipeIndexOffset + 12;
        this.drawRecipesBackground(p_146976_2_, p_146976_3_, offsetX, offsetY, recipeOffset);
        this.drawRecipesItems(offsetX, offsetY, recipeOffset);
    }

    private void drawRecipesBackground(int p_214141_1_, int p_214141_2_, int p_214141_3_, int p_214141_4_, int p_214141_5_) {
        for (int lvt_6_1_ = this.recipeIndexOffset; lvt_6_1_ < p_214141_5_ && lvt_6_1_ < ((WoodcutterContainer)this.field_147002_h).getRecipeListSize(); ++lvt_6_1_) {
            int lvt_7_1_ = lvt_6_1_ - this.recipeIndexOffset;
            int lvt_8_1_ = p_214141_3_ + lvt_7_1_ % 4 * 16;
            int lvt_9_1_ = lvt_7_1_ / 4;
            int lvt_10_1_ = p_214141_4_ + lvt_9_1_ * 18 + 2;
            int lvt_11_1_ = this.field_147000_g;
            if (lvt_6_1_ == ((WoodcutterContainer)this.field_147002_h).getSelectedRecipe()) {
                lvt_11_1_ += 18;
            } else if (p_214141_1_ >= lvt_8_1_ && p_214141_2_ >= lvt_10_1_ && p_214141_1_ < lvt_8_1_ + 16 && p_214141_2_ < lvt_10_1_ + 18) {
                lvt_11_1_ += 36;
            }
            this.blit(lvt_8_1_, lvt_10_1_ - 1, 0, lvt_11_1_, 16, 18);
        }
    }

    private void drawRecipesItems(int p_214142_1_, int p_214142_2_, int p_214142_3_) {
        RenderHelper.func_227780_a_();
        List<WoodcuttingRecipe> lvt_4_1_ = ((WoodcutterContainer)this.field_147002_h).getRecipeList();
        for (int lvt_5_1_ = this.recipeIndexOffset; lvt_5_1_ < p_214142_3_ && lvt_5_1_ < ((WoodcutterContainer)this.field_147002_h).getRecipeListSize(); ++lvt_5_1_) {
            int lvt_6_1_ = lvt_5_1_ - this.recipeIndexOffset;
            int lvt_7_1_ = p_214142_1_ + lvt_6_1_ % 4 * 16;
            int lvt_8_1_ = lvt_6_1_ / 4;
            int lvt_9_1_ = p_214142_2_ + lvt_8_1_ * 18 + 2;
            this.minecraft.func_175599_af().func_180450_b(lvt_4_1_.get(lvt_5_1_).func_77571_b(), lvt_7_1_, lvt_9_1_);
        }
        RenderHelper.func_74518_a();
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.clickedOnSroll = false;
        if (this.hasItemsInInputSlot) {
            int lvt_6_1_ = this.field_147003_i + 52;
            int lvt_7_1_ = this.field_147009_r + 14;
            int lvt_8_1_ = this.recipeIndexOffset + 12;
            for (int lvt_9_1_ = this.recipeIndexOffset; lvt_9_1_ < lvt_8_1_; ++lvt_9_1_) {
                int lvt_10_1_ = lvt_9_1_ - this.recipeIndexOffset;
                double lvt_11_1_ = p_mouseClicked_1_ - (double)(lvt_6_1_ + lvt_10_1_ % 4 * 16);
                double lvt_13_1_ = p_mouseClicked_3_ - (double)(lvt_7_1_ + lvt_10_1_ / 4 * 18);
                if (!(lvt_11_1_ >= 0.0) || !(lvt_13_1_ >= 0.0) || !(lvt_11_1_ < 16.0) || !(lvt_13_1_ < 18.0) || !((WoodcutterContainer)this.field_147002_h).func_75140_a((PlayerEntity)this.minecraft.field_71439_g, lvt_9_1_)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219720_mm, (float)1.0f));
                this.minecraft.field_71442_b.func_78756_a(((WoodcutterContainer)this.field_147002_h).field_75152_c, lvt_9_1_);
                return true;
            }
            lvt_6_1_ = this.field_147003_i + 119;
            lvt_7_1_ = this.field_147009_r + 9;
            if (p_mouseClicked_1_ >= (double)lvt_6_1_ && p_mouseClicked_1_ < (double)(lvt_6_1_ + 12) && p_mouseClicked_3_ >= (double)lvt_7_1_ && p_mouseClicked_3_ < (double)(lvt_7_1_ + 54)) {
                this.clickedOnSroll = true;
            }
        }
        return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.clickedOnSroll && this.canScroll()) {
            int lvt_10_1_ = this.field_147009_r + 14;
            int lvt_11_1_ = lvt_10_1_ + 54;
            this.sliderProgress = ((float)p_mouseDragged_3_ - (float)lvt_10_1_ - 7.5f) / ((float)(lvt_11_1_ - lvt_10_1_) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (this.canScroll()) {
            int lvt_7_1_ = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - p_mouseScrolled_5_ / (double)lvt_7_1_);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)lvt_7_1_) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && ((WoodcutterContainer)this.field_147002_h).getRecipeListSize() > 12;
    }

    protected int getHiddenRows() {
        return (((WoodcutterContainer)this.field_147002_h).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((WoodcutterContainer)this.field_147002_h).hasItemsinInputSlot();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }
}

