/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.entities;

import com.vulp.druidcraft.entities.AI.goals.NonTamedTargetGoalMonster;
import com.vulp.druidcraft.entities.AI.goals.OwnerHurtByTargetGoalMonster;
import com.vulp.druidcraft.entities.AI.goals.OwnerHurtTargetGoalMonster;
import com.vulp.druidcraft.entities.TameableMonsterEntity;
import com.vulp.druidcraft.events.EventFactory;
import com.vulp.druidcraft.inventory.container.BeetleInventoryContainer;
import com.vulp.druidcraft.registry.ItemRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class BeetleEntity
extends TameableMonsterEntity
implements IInventoryChangedListener,
INamedContainerProvider {
    private static final DataParameter<Boolean> SADDLE = EntityDataManager.func_187226_a(BeetleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CHEST = EntityDataManager.func_187226_a(BeetleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private Inventory beetleChest;
    private LazyOptional<?> itemHandler = null;

    public BeetleEntity(EntityType<? extends BeetleEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 10;
        this.initBeetleChest();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLE, (Object)false);
        this.field_70180_af.func_187214_a(CHEST, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.2f));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoalMonster(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoalMonster(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new NonTamedTargetGoalMonster<PlayerEntity>(this, PlayerEntity.class, false, null));
        this.field_70715_bh.func_75776_a(5, new NonTamedTargetGoalMonster<IronGolemEntity>(this, IronGolemEntity.class, false));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111128_a(1.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    public static boolean placement(EntityType<?> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (worldIn.func_201696_r(pos) >= 8 && randomIn.nextInt(5) == 0) {
            return false;
        }
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && block == Blocks.field_196658_i;
    }

    public boolean hasSaddle() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLE);
    }

    private void setSaddled(boolean saddled) {
        this.field_70180_af.func_187227_b(SADDLE, (Object)saddled);
    }

    public boolean hasChest() {
        return (Boolean)this.field_70180_af.func_187225_a(CHEST);
    }

    private void setChested(boolean chested) {
        this.field_70180_af.func_187227_b(CHEST, (Object)chested);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.8f;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("saddled", this.hasSaddle());
        compound.func_74757_a("chested", this.hasChest());
        if (this.hasChest()) {
            ListNBT listnbt = new ListNBT();
            for (int i = 2; i < this.beetleChest.func_70302_i_(); ++i) {
                ItemStack itemstack = this.beetleChest.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(compoundnbt);
                listnbt.add((Object)compoundnbt);
            }
            compound.func_218657_a("Items", (INBT)listnbt);
        }
        if (!this.beetleChest.func_70301_a(0).func_190926_b()) {
            compound.func_218657_a("SaddleItem", (INBT)this.beetleChest.func_70301_a(0).func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        ItemStack itemstack;
        super.func_70037_a(compound);
        this.setSaddled(compound.func_74767_n("saddled"));
        this.setChested(compound.func_74767_n("chested"));
        if (this.hasChest()) {
            ListNBT listnbt = compound.func_150295_c("Items", 10);
            this.initBeetleChest();
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                int j = compoundnbt.func_74771_c("Slot") & 0xFF;
                if (j < 2 || j >= this.beetleChest.func_70302_i_()) continue;
                this.beetleChest.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)compoundnbt));
            }
        }
        if (compound.func_150297_b("SaddleItem", 10) && (itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("SaddleItem"))).func_77973_b() == Items.field_151141_av) {
            this.beetleChest.func_70299_a(0, itemstack);
        }
        this.updateBeetleSlots();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (inventorySlot == 499) {
            if (this.hasChest() && itemStackIn.func_190926_b()) {
                this.setChested(false);
                this.initBeetleChest();
                return true;
            }
            if (!this.hasChest() && itemStackIn.func_77973_b() == Items.field_221675_bZ) {
                this.setChested(true);
                this.initBeetleChest();
                return true;
            }
        }
        return super.func_174820_d(inventorySlot, itemStackIn);
    }

    private int getInventorySize() {
        if (this.hasChest()) {
            return 65;
        }
        return 1;
    }

    private boolean canBeSaddled() {
        return true;
    }

    @Override
    public boolean shouldAttackEntity(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity)) {
            TameableEntity tameableEntity;
            TameableMonsterEntity monsterEntity;
            if (target instanceof TameableMonsterEntity && (monsterEntity = (TameableMonsterEntity)target).isTamed() && monsterEntity.getOwner() == this.getOwner()) {
                return false;
            }
            if (target instanceof TameableEntity && (tameableEntity = (TameableEntity)target).func_70909_n() && tameableEntity.func_70902_q() == this.getOwner()) {
                return false;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof CatEntity) || !((CatEntity)target).func_70909_n();
        }
        return false;
    }

    private void updateBeetleSlots() {
        if (!this.field_70170_p.field_72995_K) {
            this.setSaddled(!this.beetleChest.func_70301_a(0).func_190926_b() && this.canBeSaddled());
        }
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (this.isTamed() && player.func_225608_bj_()) {
            this.openGUI(player);
            return true;
        }
        if (!itemstack.func_190926_b()) {
            if (item == Items.field_151034_e && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(8.0f);
                return true;
            }
            if (!this.isTamed() || itemstack.func_77973_b() == Items.field_151057_cb) {
                if (itemstack.func_77973_b() == Items.field_151153_ao) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        if (this.field_70146_Z.nextInt(3) == 0 && !EventFactory.onMonsterTame(this, player)) {
                            this.playTameEffect(true);
                            this.setTamedBy(player);
                            this.field_70699_by.func_75499_g();
                            this.func_70624_b(null);
                            this.func_70606_j(32.0f);
                            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        } else {
                            this.playTameEffect(false);
                            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                        }
                    }
                    return true;
                }
                if (itemstack.func_111282_a(player, (LivingEntity)this, hand)) {
                    return true;
                }
            } else if (this.isTamed() && !this.field_70170_p.field_72995_K) {
                if (!this.hasChest() && itemstack.func_77973_b() == Items.field_221675_bZ) {
                    this.setChested(true);
                    this.playChestEquipSound();
                    this.initBeetleChest();
                    if (!player.func_184812_l_()) {
                        itemstack.func_190918_g(1);
                    }
                    return true;
                }
                if (!this.hasSaddle() && itemstack.func_77973_b() == Items.field_151141_av) {
                    this.openGUI(player);
                    return true;
                }
            }
        } else if (!this.field_70170_p.field_72995_K && this.hasSaddle() && !this.func_184207_aI()) {
            this.mountTo(player);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    private void mountTo(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            player.func_184220_m((Entity)this);
        }
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof MobEntity) {
            MobEntity mobentity = (MobEntity)passenger;
            this.field_70761_aq = mobentity.field_70761_aq;
            passenger.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W(), this.func_226281_cx_());
        }
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new BeetleInventoryContainer(i, playerInventory, (IInventory)this.beetleChest, this.func_145782_y());
    }

    private void openGUI(PlayerEntity playerEntity) {
        if (!this.field_70170_p.field_72995_K && (!this.func_184207_aI() || this.func_184196_w((Entity)playerEntity)) && this.isTamed()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)this, packetBuffer -> {
                packetBuffer.writeInt(this.func_145782_y());
                packetBuffer.writeInt(this.getInventorySize());
            });
        }
    }

    private void initBeetleChest() {
        Inventory inventory = this.beetleChest;
        this.beetleChest = new Inventory(this.getInventorySize());
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inventory.func_70302_i_(), this.beetleChest.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.beetleChest.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.beetleChest.func_110134_a((IInventoryChangedListener)this);
        this.updateBeetleSlots();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.beetleChest));
    }

    private void playChestEquipSound() {
        this.func_184185_a(SoundEvents.field_187584_ax, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (!this.field_70170_p.field_72995_K) {
            if (this.isTamed()) {
                if (this.hasChest()) {
                    this.func_199703_a((IItemProvider)Blocks.field_150486_ae);
                    this.setChested(false);
                    for (int i = 0; i < this.beetleChest.func_70302_i_(); ++i) {
                        ItemStack itemstack = this.beetleChest.func_70301_a(i);
                        if (itemstack.func_190926_b()) continue;
                        this.func_199701_a_(itemstack);
                    }
                }
                if (this.hasSaddle()) {
                    this.func_199703_a((IItemProvider)Items.field_151141_av);
                    this.setSaddled(false);
                }
            } else {
                int j = this.field_70146_Z.nextInt(2);
                for (int k = 0; k <= j; ++k) {
                    this.func_199703_a((IItemProvider)ItemRegistry.chitin);
                }
            }
        }
    }

    public void func_76316_a(IInventory invBasic) {
        boolean flag = this.hasSaddle();
        this.updateBeetleSlots();
        if (this.field_70173_aa > 20 && !flag && this.hasSaddle()) {
            this.func_184185_a(SoundEvents.field_187726_cu, 0.5f, 1.0f);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() - 0.15;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public void func_213352_e(Vec3d vec) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.hasSaddle()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                this.field_70138_W = 1.0f;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg * 1.0f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    super.func_213352_e(new Vec3d((double)f, vec.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vec3d.field_186680_a);
                }
            } else {
                this.field_70138_W = 0.5f;
                super.func_213352_e(vec);
            }
        }
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(BeetleEntity beetle) {
            super((CreatureEntity)beetle, 0.85, true);
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }
}

