/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.entities.projectiles;

import com.vulp.druidcraft.entities.DreadfishEntity;
import com.vulp.druidcraft.registry.EntityRegistry;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class DreadfishFireBurst
extends DamagingProjectileEntity
implements IProjectile {
    public DreadfishEntity projectile_owner;
    public CompoundNBT owner_NBT;

    public DreadfishFireBurst(EntityType<? extends DreadfishFireBurst> entity, World world) {
        super(entity, world);
    }

    public DreadfishFireBurst(World worldIn, DreadfishEntity entity) {
        this(EntityRegistry.dreadfish_fire_burst, worldIn);
        this.projectile_owner = entity;
        double x = entity.func_226277_ct_() - (double)(entity.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(entity.field_70761_aq * ((float)Math.PI / 180)));
        double y = entity.func_226280_cw_() - (double)0.1f;
        double z = entity.func_226281_cx_() + (double)(entity.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(entity.field_70761_aq * ((float)Math.PI / 180)));
        this.func_70107_b(entity.func_226277_ct_() - (double)(entity.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(entity.field_70761_aq * ((float)Math.PI / 180))), entity.func_226280_cw_() - (double)0.1f, entity.func_226281_cx_() + (double)(entity.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(entity.field_70761_aq * ((float)Math.PI / 180))));
        this.create(worldIn, x, y, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void create(World worldIn, double x, double y, double z) {
        this.func_70107_b(x, y, z);
        double altX = 0.0;
        double altY = 0.0;
        double altZ = 0.0;
        for (int i = 0; i < 7; ++i) {
            double d0 = 0.4 + 0.1 * (double)i;
            altX = MathHelper.func_151237_a((double)this.field_70232_b, (double)-3.9, (double)3.9) / 8000.0 * 8000.0 * d0;
            altY = MathHelper.func_151237_a((double)this.field_70233_c, (double)-3.9, (double)3.9) / 8000.0 * 8000.0;
            altZ = MathHelper.func_151237_a((double)this.field_70230_d, (double)-3.9, (double)3.9) * 8000.0 / 8000.0 * d0;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197602_M, x, y, z, altX, altY, altZ);
        }
        this.func_213293_j(altX, altY, altZ);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.owner_NBT != null) {
            this.restoreOwnerFromSave();
        }
        Vec3d vec3d = this.func_213322_ci();
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(vec3d).func_186662_g(1.0), p_213879_1_ -> !p_213879_1_.func_175149_v() && p_213879_1_ != this.projectile_owner, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.OUTLINE, (boolean)true);
        if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((DamagingProjectileEntity)this, (RayTraceResult)raytraceresult)) {
            this.onHit(raytraceresult);
        }
        double d0 = this.func_226277_ct_() + vec3d.field_72450_a;
        double d1 = this.func_226278_cu_() + vec3d.field_72448_b;
        double d2 = this.func_226281_cx_() + vec3d.field_72449_c;
        float f = MathHelper.func_76133_a((double)DreadfishFireBurst.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        float f1 = 0.99f;
        float f2 = 0.06f;
        if (!this.field_70170_p.func_72875_a(this.func_174813_aQ(), Material.field_151579_a)) {
            this.func_70106_y();
        } else if (this.func_203005_aq()) {
            this.func_70106_y();
        } else {
            this.func_213317_d(vec3d.func_186678_a((double)0.99f));
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.06f, 0.0));
            }
            this.func_70107_b(d0, d1, d2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3d vec3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)DreadfishFireBurst.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)z) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void onHit(RayTraceResult p_190536_1_) {
        RayTraceResult.Type raytraceresult$type = p_190536_1_.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY && this.owner_NBT != null) {
            ((EntityRayTraceResult)p_190536_1_).func_216348_a().func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)this.projectile_owner).func_76349_b(), 1.0f);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    public void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Owner", 10)) {
            this.owner_NBT = compound.func_74775_l("Owner");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        if (this.projectile_owner != null) {
            CompoundNBT compoundnbt = new CompoundNBT();
            UUID uuid = this.projectile_owner.func_110124_au();
            compoundnbt.func_186854_a("OwnerUUID", uuid);
            compound.func_218657_a("Owner", (INBT)compoundnbt);
        }
    }

    private void restoreOwnerFromSave() {
        if (this.owner_NBT != null && this.owner_NBT.func_186855_b("OwnerUUID")) {
            UUID uuid = this.owner_NBT.func_186857_a("OwnerUUID");
            for (DreadfishEntity dreadfish : this.field_70170_p.func_217357_a(DreadfishEntity.class, this.func_174813_aQ().func_186662_g(15.0))) {
                if (!dreadfish.func_110124_au().equals(uuid)) continue;
                this.projectile_owner = dreadfish;
                break;
            }
        }
        this.owner_NBT = null;
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }
}

