/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.inventory.container;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.vulp.druidcraft.recipes.IModdedRecipeType;
import com.vulp.druidcraft.recipes.WoodcuttingRecipe;
import com.vulp.druidcraft.registry.BlockRegistry;
import com.vulp.druidcraft.registry.GUIRegistry;
import com.vulp.druidcraft.registry.SoundEventRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WoodcutterContainer
extends Container {
    static final ImmutableList<Tag<Item>> ACCEPTED_INPUT_ITEMS = ImmutableList.of((Object)ItemTags.field_200038_h, (Object)ItemTags.field_199905_b);
    private final IWorldPosCallable worldPosCallable;
    private final IntReferenceHolder selectedRecipe = IntReferenceHolder.func_221492_a();
    private final World world;
    private List<WoodcuttingRecipe> recipes = Lists.newArrayList();
    private ItemStack itemStackInput = ItemStack.field_190927_a;
    private long lastOnTake;
    final Slot inputInventorySlot;
    final Slot outputInventorySlot;
    private Runnable inventoryUpdateListener = () -> {};
    public final IInventory inputInventory = new Inventory(1){

        public void func_70296_d() {
            super.func_70296_d();
            WoodcutterContainer.this.func_75130_a((IInventory)this);
            WoodcutterContainer.this.inventoryUpdateListener.run();
        }
    };
    private final CraftResultInventory inventory = new CraftResultInventory();

    public WoodcutterContainer(int windowIdIn, PlayerInventory playerInventoryIn) {
        this(windowIdIn, playerInventoryIn, IWorldPosCallable.field_221489_a);
    }

    public WoodcutterContainer(int windowIdIn, PlayerInventory playerInventoryIn, final IWorldPosCallable worldPosCallableIn) {
        super(GUIRegistry.woodcutter, windowIdIn);
        this.worldPosCallable = worldPosCallableIn;
        this.world = playerInventoryIn.field_70458_d.field_70170_p;
        this.inputInventorySlot = this.func_75146_a(new Slot(this.inputInventory, 0, 20, 33));
        this.outputInventorySlot = this.func_75146_a(new Slot((IInventory)this.inventory, 1, 143, 33){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
                ItemStack itemstack = WoodcutterContainer.this.inputInventorySlot.func_75209_a(1);
                if (!itemstack.func_190926_b()) {
                    WoodcutterContainer.this.updateRecipeResultSlot();
                }
                stack.func_77973_b().func_77622_d(stack, thePlayer.field_70170_p, thePlayer);
                worldPosCallableIn.func_221486_a((p_216954_1_, p_216954_2_) -> {
                    long l = p_216954_1_.func_82737_E();
                    if (WoodcutterContainer.this.lastOnTake != l) {
                        p_216954_1_.func_184133_a((PlayerEntity)null, p_216954_2_, SoundEventRegistry.wood_cutter_take, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        WoodcutterContainer.this.lastOnTake = l;
                    }
                });
                return super.func_190901_a(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventoryIn, k, 8 + k * 18, 142));
        }
        this.func_216958_a(this.selectedRecipe);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSelectedRecipe() {
        return this.selectedRecipe.func_221495_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<WoodcuttingRecipe> getRecipeList() {
        return this.recipes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRecipeListSize() {
        return this.recipes.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasItemsinInputSlot() {
        return this.inputInventorySlot.func_75216_d() && !this.recipes.isEmpty();
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return WoodcutterContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)BlockRegistry.woodcutter);
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        if (id >= 0 && id < this.recipes.size()) {
            this.selectedRecipe.func_221494_a(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    public void func_75130_a(IInventory inventoryIn) {
        ItemStack itemstack = this.inputInventorySlot.func_75211_c();
        if (itemstack.func_77973_b() != this.itemStackInput.func_77973_b()) {
            this.itemStackInput = itemstack.func_77946_l();
            this.updateAvailableRecipes(inventoryIn, itemstack);
        }
    }

    private void updateAvailableRecipes(IInventory inventoryIn, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.func_221494_a(-1);
        this.outputInventorySlot.func_75215_d(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            this.recipes = this.world.func_199532_z().func_215370_b(IModdedRecipeType.woodcutting, inventoryIn, this.world);
        }
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty()) {
            WoodcuttingRecipe woodcuttingRecipe = this.recipes.get(this.selectedRecipe.func_221495_b());
            this.outputInventorySlot.func_75215_d(woodcuttingRecipe.func_77572_b(this.inputInventory));
        } else {
            this.outputInventorySlot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    public ContainerType<?> func_216957_a() {
        return GUIRegistry.woodcutter;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return false;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            Item item = itemstack1.func_77973_b();
            itemstack = itemstack1.func_77946_l();
            if (index == 1) {
                item.func_77622_d(itemstack1, playerIn.field_70170_p, playerIn);
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index == 0 ? !this.func_75135_a(itemstack1, 2, 38, false) : (this.world.func_199532_z().func_215371_a(IModdedRecipeType.woodcutting, (IInventory)new Inventory(new ItemStack[]{itemstack1}), this.world).isPresent() ? !this.func_75135_a(itemstack1, 0, 1, false) : (index < 29 ? !this.func_75135_a(itemstack1, 29, 38, false) : index < 38 && !this.func_75135_a(itemstack1, 2, 29, false)))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
            this.func_75142_b();
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.inventory.func_70304_b(1);
        this.worldPosCallable.func_221486_a((p_217079_2_, p_217079_3_) -> this.func_193327_a(playerIn, playerIn.field_70170_p, this.inputInventory));
    }
}

