/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.items;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.vulp.druidcraft.items.EffectiveSickleItem;
import com.vulp.druidcraft.items.ItemProperties;
import com.vulp.druidcraft.items.RadialToolItem;
import com.vulp.druidcraft.util.SickleHarvestUtil;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class SickleItem
extends ToolItem
implements RadialToolItem,
EffectiveSickleItem {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150349_c});
    private static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151585_k, (Object)Material.field_203243_f, (Object)Material.field_151582_l);
    private final int radius;

    public SickleItem(ItemProperties builder) {
        super((float)builder.getAttackDamage(), builder.getAttackSpeed(), builder.getTier(), EFFECTIVE_ON, builder.addToolType(ToolType.get((String)"sickle"), builder.getTier().func_200925_d()));
        this.radius = builder.getRadius();
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    public boolean func_150897_b(BlockState blockIn) {
        if (blockIn.getHarvestTool() == ToolType.get((String)"sickle")) {
            return true;
        }
        Material material = blockIn.func_185904_a();
        return EFFECTIVE_MATERIALS.contains(material);
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            SickleHarvestUtil.breakNeighbours(stack, world, pos, (PlayerEntity)entity);
        }
        return super.func_179218_a(stack, world, state, pos, entity);
    }

    @Override
    public Set<Block> getEffectiveBlocks() {
        return EFFECTIVE_ON;
    }

    @Override
    public Set<Material> getEffectiveMaterials() {
        return EFFECTIVE_MATERIALS;
    }
}

