/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.registry;

import com.vulp.druidcraft.DruidcraftRegistry;
import com.vulp.druidcraft.config.EntitySpawnConfig;
import com.vulp.druidcraft.entities.BeetleEntity;
import com.vulp.druidcraft.entities.DreadfishEntity;
import com.vulp.druidcraft.entities.LunarMothEntity;
import com.vulp.druidcraft.entities.projectiles.DreadfishFireBurst;
import com.vulp.druidcraft.registry.ItemRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EntityRegistry {
    public static final EntityType<DreadfishEntity> dreadfish_entity = EntityRegistry.createEntity(DreadfishEntity::new, EntityClassification.MONSTER, "dreadfish", 0.8f, 0.4f);
    public static final EntityType<BeetleEntity> beetle_entity = EntityRegistry.createEntity(BeetleEntity::new, EntityClassification.MONSTER, "beetle", 1.5f, 1.5f);
    public static final EntityType<LunarMothEntity> lunar_moth_entity = EntityRegistry.createEntity(LunarMothEntity::new, EntityClassification.CREATURE, "lunar_moth", 0.5f, 0.5f);
    public static final EntityType<DreadfishFireBurst> dreadfish_fire_burst = EntityRegistry.createEntity(DreadfishFireBurst::new, EntityClassification.MISC, "dreadfish_fire_burst", 0.5f, 0.5f);

    private static <T extends Entity> EntityType<T> createEntity(EntityType.IFactory<T> factory, EntityClassification entityClassification, String name, float width, float height) {
        return EntityRegistry.createEntity(factory, entityClassification, name, width, height, -1, null);
    }

    private static <T extends Entity> EntityType<T> createEntity(EntityType.IFactory<T> factory, EntityClassification entityClassification, String name, float width, float height, int trackingRange, BiFunction<FMLPlayMessages.SpawnEntity, World, T> customClientFactory) {
        ResourceLocation location = new ResourceLocation("druidcraft", name);
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3);
        if (customClientFactory != null) {
            builder.setCustomClientFactory(customClientFactory);
        }
        if (trackingRange != -1) {
            builder.setTrackingRange(trackingRange);
        }
        EntityType entity = builder.func_206830_a(location.toString());
        entity.setRegistryName(location);
        return entity;
    }

    public static void registerEntitySpawnEggs(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ItemRegistry.dreadfish_spawn_egg = EntityRegistry.registerEntitySpawnEgg(dreadfish_entity, 14869209, 10974719, "dreadfish_spawn_egg"), ItemRegistry.beetle_spawn_egg = EntityRegistry.registerEntitySpawnEgg(beetle_entity, 5760476, 2258313, "beetle_spawn_egg"), ItemRegistry.lunar_moth_spawn_egg = EntityRegistry.registerEntitySpawnEgg(lunar_moth_entity, 4915138, 52873, "lunar_moth_spawn_egg")});
    }

    public static void registerEntityWorldSpawns() {
        EntityRegistry.registerEntityWorldSpawn((Boolean)EntitySpawnConfig.dreadfish_spawn.get(), dreadfish_entity, EntityClassification.MONSTER, (Integer)EntitySpawnConfig.dreadfish_weight.get(), (Integer)EntitySpawnConfig.dreadfish_min_group.get(), (Integer)EntitySpawnConfig.dreadfish_max_group.get(), (List)EntitySpawnConfig.dreadfish_biome_types.get(), (List)EntitySpawnConfig.dreadfish_biome_exclusions.get());
        EntityRegistry.registerEntityWorldSpawn((Boolean)EntitySpawnConfig.beetle_spawn.get(), beetle_entity, EntityClassification.MONSTER, (Integer)EntitySpawnConfig.beetle_weight.get(), (Integer)EntitySpawnConfig.beetle_min_group.get(), (Integer)EntitySpawnConfig.beetle_max_group.get(), (List)EntitySpawnConfig.beetle_biome_types.get(), (List)EntitySpawnConfig.beetle_biome_exclusions.get());
        EntityRegistry.registerEntityWorldSpawn((Boolean)EntitySpawnConfig.lunar_moth_spawn.get(), lunar_moth_entity, EntityClassification.CREATURE, (Integer)EntitySpawnConfig.lunar_moth_weight.get(), (Integer)EntitySpawnConfig.lunar_moth_min_group.get(), (Integer)EntitySpawnConfig.lunar_moth_max_group.get(), (List)EntitySpawnConfig.lunar_moth_biome_types.get(), (List)EntitySpawnConfig.lunar_moth_biome_exclusions.get());
        EntitySpawnPlacementRegistry.func_209343_a(beetle_entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BeetleEntity::placement);
        EntitySpawnPlacementRegistry.func_209343_a(dreadfish_entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, DreadfishEntity::placement);
    }

    public static Item registerEntitySpawnEgg(EntityType<?> type, int color1, int color2, String name) {
        SpawnEggItem item = new SpawnEggItem(type, color1, color2, new Item.Properties().func_200916_a(DruidcraftRegistry.DRUIDCRAFT));
        item.setRegistryName(DruidcraftRegistry.location(name));
        return item;
    }

    public static void registerEntityWorldSpawn(boolean spawnEnabled, EntityType<?> entity, EntityClassification classification, int weight, int minGroupCountIn, int maxGroupCountIn, List<String> biomes, List<String> exclusions) {
        HashSet biomeSet = new HashSet();
        if (spawnEnabled) {
            for (String biomeName : biomes) {
                biomeSet.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.getType((String)biomeName, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])));
            }
            Set exclusionTypes = exclusions.stream().filter(o -> !o.isEmpty()).map(x$0 -> BiomeDictionary.Type.getType((String)x$0, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toCollection(HashSet::new));
            biomeSet.forEach(o -> {
                for (BiomeDictionary.Type type : exclusionTypes) {
                    if (!BiomeDictionary.hasType((Biome)o, (BiomeDictionary.Type)type)) continue;
                    return;
                }
                o.func_76747_a(classification).add(new Biome.SpawnListEntry(entity, weight, minGroupCountIn, maxGroupCountIn));
            });
        }
        biomeSet.clear();
    }
}

