/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.druidcraft.world.features;

import com.mojang.datafixers.Dynamic;
import com.vulp.druidcraft.blocks.WoodBlock;
import com.vulp.druidcraft.registry.BlockRegistry;
import com.vulp.druidcraft.world.features.ElderTreeFeatureConfig;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraftforge.common.IPlantable;

public class ElderTreeFeature
extends AbstractTreeFeature<ElderTreeFeatureConfig> {
    public ElderTreeFeature(Function<Dynamic<?>, ? extends ElderTreeFeatureConfig> config) {
        super(config);
    }

    protected boolean place(IWorldGenerationReader generationReader, Random rand, BlockPos position, Set<BlockPos> placedLogs, Set<BlockPos> placedLeaves, MutableBoundingBox boundsIn, ElderTreeFeatureConfig configIn) {
        int height = rand.nextInt(2) + configIn.field_227371_p_;
        boolean canGrow = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int cy = position.func_177956_o(); cy <= position.func_177956_o() + 1 + height; ++cy) {
                int k = 1;
                if (cy == position.func_177956_o()) {
                    k = 0;
                }
                if (cy >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int cx = position.func_177958_n() - k; cx <= position.func_177958_n() + k && canGrow; ++cx) {
                    for (int cz = position.func_177952_p() - k; cz <= position.func_177952_p() + k && canGrow; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            if (ElderTreeFeature.func_214587_a((IWorldGenerationBaseReader)generationReader, (BlockPos)blockpos$mutableblockpos.func_181079_c(cx, cy, cz))) continue;
                            canGrow = false;
                            continue;
                        }
                        canGrow = false;
                    }
                }
            }
            if (!canGrow) {
                return false;
            }
            if (ElderTreeFeature.isSoil((IWorldGenerationBaseReader)generationReader, (BlockPos)position.func_177977_b(), (IPlantable)configIn.getSapling()) && position.func_177956_o() < generationReader.getMaxHeight() - height - 1) {
                this.setDirtAt(generationReader, position.func_177977_b(), position);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int posY = 0;
                int logSide1 = rand.nextInt(3);
                int logSide2 = rand.nextInt(3);
                if (logSide2 == logSide1 && (logSide2 = rand.nextInt(3)) == logSide1) {
                    logSide2 = 4;
                }
                for (int base = 0; base < height; ++base) {
                    int currentY = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, currentY, posZ);
                    if (!ElderTreeFeature.func_214572_g((IWorldGenerationBaseReader)generationReader, (BlockPos)blockpos)) continue;
                    if (base == 0) {
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177978_c().func_177977_b())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177978_c().func_177977_b(), boundsIn, true);
                            } else if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177978_c())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177978_c(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177974_f().func_177977_b())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177974_f().func_177977_b(), boundsIn, true);
                            } else if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177974_f())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177974_f(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177968_d().func_177977_b())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177968_d().func_177977_b(), boundsIn, true);
                            } else if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177968_d())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177968_d(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177976_e().func_177977_b())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177976_e().func_177977_b(), boundsIn, true);
                            } else if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177976_e())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177976_e(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177978_c().func_177974_f().func_177977_b())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177978_c().func_177974_f().func_177977_b(), boundsIn, true);
                            } else if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177978_c().func_177974_f())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177978_c().func_177974_f(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177978_c().func_177976_e().func_177977_b())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177978_c().func_177976_e().func_177977_b(), boundsIn, true);
                            } else if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177978_c().func_177976_e())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177978_c().func_177976_e(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177968_d().func_177974_f().func_177977_b())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177968_d().func_177974_f().func_177977_b(), boundsIn, true);
                            } else if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177968_d().func_177974_f())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177968_d().func_177974_f(), boundsIn, true);
                            }
                        }
                        if (rand.nextBoolean()) {
                            if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177968_d().func_177976_e().func_177977_b())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177968_d().func_177976_e().func_177977_b(), boundsIn, true);
                            } else if (ElderTreeFeature.isReplaceable((IWorldGenerationBaseReader)generationReader, blockpos.func_177968_d().func_177976_e())) {
                                this.placeLogAt(placedLogs, generationReader, blockpos.func_177968_d().func_177976_e(), boundsIn, true);
                            }
                        }
                        this.placeLogAt(placedLogs, generationReader, blockpos, boundsIn, false);
                    }
                    if (base <= height - 1) {
                        this.placeLogAt(placedLogs, generationReader, blockpos, boundsIn, false);
                        if (base == height - 2 || base == height - 3) {
                            if (logSide1 == 0) {
                                this.placeRotatedLog(placedLogs, generationReader, blockpos.func_177964_d(1), boundsIn, Direction.Axis.Z);
                            }
                            if (logSide1 == 1) {
                                this.placeRotatedLog(placedLogs, generationReader, blockpos.func_177965_g(1), boundsIn, Direction.Axis.X);
                            }
                            if (logSide1 == 2) {
                                this.placeRotatedLog(placedLogs, generationReader, blockpos.func_177970_e(1), boundsIn, Direction.Axis.Z);
                            }
                            if (logSide1 == 3) {
                                this.placeRotatedLog(placedLogs, generationReader, blockpos.func_177985_f(1), boundsIn, Direction.Axis.X);
                            }
                        }
                        if (base == height - 2 || base == height - 3) {
                            if (logSide1 == 0) {
                                this.placeRotatedLog(placedLogs, generationReader, blockpos.func_177964_d(1), boundsIn, Direction.Axis.Z);
                            }
                            if (logSide1 == 1) {
                                this.placeRotatedLog(placedLogs, generationReader, blockpos.func_177965_g(1), boundsIn, Direction.Axis.X);
                            }
                            if (logSide1 == 2) {
                                this.placeRotatedLog(placedLogs, generationReader, blockpos.func_177970_e(1), boundsIn, Direction.Axis.Z);
                            }
                            if (logSide1 == 3) {
                                this.placeRotatedLog(placedLogs, generationReader, blockpos.func_177985_f(1), boundsIn, Direction.Axis.X);
                            }
                        }
                    }
                    posY = currentY;
                }
                BlockPos blockpos2 = new BlockPos(posX, posY, posZ).func_177977_b();
                for (int leafLayer1and3X = -3; leafLayer1and3X <= 3; ++leafLayer1and3X) {
                    for (int leafLayer1and3Z = -3; leafLayer1and3Z <= 3; ++leafLayer1and3Z) {
                        if ((leafLayer1and3X == 3 || leafLayer1and3X == -3) && (leafLayer1and3Z == 3 || leafLayer1and3Z == -3)) continue;
                        if (leafLayer1and3X == -3 && (leafLayer1and3Z == -2 || leafLayer1and3Z == 2) || leafLayer1and3X == 3 && (leafLayer1and3Z == -2 || leafLayer1and3Z == 2) || leafLayer1and3Z == -3 && (leafLayer1and3X == -2 || leafLayer1and3X == 2) || leafLayer1and3Z == 3 && (leafLayer1and3X == -2 || leafLayer1and3X == 2)) {
                            if (rand.nextBoolean() || rand.nextBoolean()) {
                                this.placeLeafAt(placedLeaves, generationReader, blockpos2.func_177982_a(leafLayer1and3X, 0, leafLayer1and3Z), boundsIn, configIn);
                            }
                            if (!rand.nextBoolean() && !rand.nextBoolean()) continue;
                            this.placeLeafAt(placedLeaves, generationReader, blockpos2.func_177982_a(leafLayer1and3X, -2, leafLayer1and3Z), boundsIn, configIn);
                            continue;
                        }
                        this.placeLeafAt(placedLeaves, generationReader, blockpos2.func_177982_a(leafLayer1and3X, 0, leafLayer1and3Z), boundsIn, configIn);
                        this.placeLeafAt(placedLeaves, generationReader, blockpos2.func_177982_a(leafLayer1and3X, -2, leafLayer1and3Z), boundsIn, configIn);
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int leafLayer4X = -2; leafLayer4X <= 2; ++leafLayer4X) {
                    for (int leafLayer4Z = -2; leafLayer4Z <= 2; ++leafLayer4Z) {
                        if (leafLayer4X != -2 && leafLayer4X != 2 || leafLayer4Z != -2 && leafLayer4Z != 2) {
                            this.placeLeafAt(placedLeaves, generationReader, blockpos2.func_177982_a(leafLayer4X, 0, leafLayer4Z), boundsIn, configIn);
                            continue;
                        }
                        if (!rand.nextBoolean()) continue;
                        this.placeLeafAt(placedLeaves, generationReader, blockpos2.func_177982_a(leafLayer4X, 0, leafLayer4Z), boundsIn, configIn);
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int leafLayer5X = -1; leafLayer5X <= 1; ++leafLayer5X) {
                    for (int leafLayer5Z = -1; leafLayer5Z <= 1; ++leafLayer5Z) {
                        if ((leafLayer5X == -1 || leafLayer5X == 1) && (leafLayer5Z == -1 || leafLayer5Z == 1)) continue;
                        this.placeLeafAt(placedLeaves, generationReader, blockpos2.func_177982_a(leafLayer5X, 0, leafLayer5Z), boundsIn, configIn);
                    }
                }
                blockpos2 = blockpos2.func_177979_c(3);
                for (int leafLayer2X = -3; leafLayer2X <= 3; ++leafLayer2X) {
                    for (int leafLayer2Z = -3; leafLayer2Z <= 3; ++leafLayer2Z) {
                        if ((leafLayer2X == -3 || leafLayer2X == 3) && (leafLayer2Z == -3 || leafLayer2Z == 3)) continue;
                        this.placeLeafAt(placedLeaves, generationReader, blockpos2.func_177982_a(leafLayer2X, 0, leafLayer2Z), boundsIn, configIn);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLogAt(Set<BlockPos> setPos, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox, boolean isBaseWood) {
        this.setElderLog(reader, pos, setPos, boundingBox, isBaseWood, null);
    }

    protected boolean setElderLog(IWorldGenerationReader p_227216_1_, BlockPos p_227216_3_, Set<BlockPos> p_227216_4_, MutableBoundingBox p_227216_5_, boolean isBaseWood, @Nullable Direction.Axis setAxis) {
        if (!(ElderTreeFeature.func_214572_g((IWorldGenerationBaseReader)p_227216_1_, (BlockPos)p_227216_3_) || ElderTreeFeature.func_214576_j((IWorldGenerationBaseReader)p_227216_1_, (BlockPos)p_227216_3_) || ElderTreeFeature.func_214571_e((IWorldGenerationBaseReader)p_227216_1_, (BlockPos)p_227216_3_))) {
            return false;
        }
        BlockState blockType = BlockRegistry.elder_log.func_176223_P();
        BlockState baseType = (BlockState)BlockRegistry.elder_wood.func_176223_P().func_206870_a((IProperty)WoodBlock.dropSelf, (Comparable)Boolean.valueOf(false));
        if (setAxis == null) {
            Random rand = new Random();
            if (isBaseWood) {
                blockType = rand.nextInt(3) == 0 ? (BlockState)baseType.func_206870_a((IProperty)WoodBlock.field_176298_M, (Comparable)Direction.Axis.X) : (rand.nextInt(3) == 0 ? (BlockState)baseType.func_206870_a((IProperty)WoodBlock.field_176298_M, (Comparable)Direction.Axis.Y) : (BlockState)baseType.func_206870_a((IProperty)WoodBlock.field_176298_M, (Comparable)Direction.Axis.Z));
            }
        } else {
            blockType = (BlockState)blockType.func_206870_a((IProperty)WoodBlock.field_176298_M, (Comparable)setAxis);
        }
        this.func_227217_a_((IWorldWriter)p_227216_1_, p_227216_3_, blockType, p_227216_5_);
        p_227216_4_.add(p_227216_3_.func_185334_h());
        return true;
    }

    protected static boolean isReplaceable(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof IBlockReader)) {
            return worldIn.func_217375_a(pos, BlockState::func_196958_f);
        }
        return worldIn.func_217375_a(pos, state -> state.func_185904_a().func_76222_j());
    }

    private void placeRotatedLog(Set<BlockPos> setPos, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox, Direction.Axis setAxis) {
        this.setElderLog(reader, pos, setPos, boundingBox, false, setAxis);
    }

    private void placeLeafAt(Set<BlockPos> set, IWorldGenerationReader reader, BlockPos pos, MutableBoundingBox boundingBox, ElderTreeFeatureConfig config) {
        Random random = new Random();
        this.setElderLeaf(reader, random, pos, set, boundingBox, config);
    }

    protected boolean setElderLeaf(IWorldGenerationReader p_227219_1_, Random p_227219_2_, BlockPos p_227219_3_, Set<BlockPos> p_227219_4_, MutableBoundingBox p_227219_5_, ElderTreeFeatureConfig p_227219_6_) {
        if (!(ElderTreeFeature.func_214572_g((IWorldGenerationBaseReader)p_227219_1_, (BlockPos)p_227219_3_) || ElderTreeFeature.func_214576_j((IWorldGenerationBaseReader)p_227219_1_, (BlockPos)p_227219_3_) || ElderTreeFeature.func_214571_e((IWorldGenerationBaseReader)p_227219_1_, (BlockPos)p_227219_3_))) {
            return false;
        }
        this.func_227217_a_((IWorldWriter)p_227219_1_, p_227219_3_, p_227219_6_.field_227369_n_.func_225574_a_(p_227219_2_, p_227219_3_), p_227219_5_);
        p_227219_4_.add(p_227219_3_.func_185334_h());
        return true;
    }
}

