/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.dynamicsf.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import me.andre111.dynamicsf.config.Config;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_638;
import org.lwjgl.openal.EXTEfx;

public class ReverbFilter {
    private static int id = -1;
    private static int slot = -1;
    private static boolean enabled = false;
    private static int tickCount = 0;
    private static float prevDecayFactor = 0.0f;
    private static float prevRoomFactor = 0.0f;
    private static float prevSkyFactor = 0.0f;
    private static float density = 0.2f;
    private static float diffusion = 0.6f;
    private static float gain = 0.15f;
    private static float gainHF = 0.8f;
    private static float decayTime = 0.1f;
    private static float decayHFRatio = 0.7f;
    private static float reflectionsGain = 0.0f;
    private static float reflectionsDelay = 0.0f;
    private static float lateReverbGain = 0.0f;
    private static float lateReverbDelay = 0.0f;
    private static float airAbsorptionGainHF = 0.99f;
    private static float roomRolloffFactor = 0.0f;
    private static int decayHFLimit = 1;

    public static void updateGlobal(class_310 client) {
        if (client.field_1687 != null && client.field_1724 != null && client.method_22108()) {
            ReverbFilter.update(client);
        } else {
            ReverbFilter.reset();
        }
    }

    public static boolean updateSoundInstance(class_1113 soundInstance) {
        if (id == -1) {
            id = EXTEfx.alGenEffects();
            slot = EXTEfx.alGenAuxiliaryEffectSlots();
        }
        if (!enabled) {
            return false;
        }
        if (reflectionsDelay <= 0.0f && lateReverbDelay <= 0.0f) {
            return false;
        }
        roomRolloffFactor = soundInstance.method_4777() == class_1113.class_1114.field_5476 ? 2.0f / (Math.max(soundInstance.method_4781(), 1.0f) + 2.0f) : 0.0f;
        density = Math.max(0.0f, Math.min(density, 1.0f));
        diffusion = Math.max(0.0f, Math.min(diffusion, 1.0f));
        gain = Math.max(0.0f, Math.min(gain, 1.0f));
        gainHF = Math.max(0.0f, Math.min(gainHF, 1.0f));
        decayTime = Math.max(0.1f, Math.min(decayTime, 20.0f));
        decayHFRatio = Math.max(0.1f, Math.min(decayHFRatio, 2.0f));
        reflectionsGain = Math.max(0.0f, Math.min(reflectionsGain, 3.16f));
        reflectionsDelay = Math.max(0.0f, Math.min(reflectionsDelay, 0.3f));
        lateReverbGain = Math.max(0.0f, Math.min(lateReverbGain, 10.0f));
        lateReverbDelay = Math.max(0.0f, Math.min(lateReverbDelay, 0.1f));
        airAbsorptionGainHF = Math.max(0.892f, Math.min(airAbsorptionGainHF, 1.0f));
        roomRolloffFactor = Math.max(0.0f, Math.min(roomRolloffFactor, 10.0f));
        decayHFLimit = Math.max(0, Math.min(decayHFLimit, 1));
        EXTEfx.alAuxiliaryEffectSlotf((int)slot, (int)2, (float)0.0f);
        EXTEfx.alEffecti((int)id, (int)32769, (int)1);
        EXTEfx.alEffectf((int)id, (int)1, (float)density);
        EXTEfx.alEffectf((int)id, (int)2, (float)diffusion);
        EXTEfx.alEffectf((int)id, (int)3, (float)gain);
        EXTEfx.alEffectf((int)id, (int)4, (float)gainHF);
        EXTEfx.alEffectf((int)id, (int)5, (float)decayTime);
        EXTEfx.alEffectf((int)id, (int)6, (float)decayHFRatio);
        EXTEfx.alEffectf((int)id, (int)7, (float)reflectionsGain);
        EXTEfx.alEffectf((int)id, (int)8, (float)reflectionsDelay);
        EXTEfx.alEffectf((int)id, (int)9, (float)lateReverbGain);
        EXTEfx.alEffectf((int)id, (int)10, (float)lateReverbDelay);
        EXTEfx.alEffectf((int)id, (int)11, (float)airAbsorptionGainHF);
        EXTEfx.alEffectf((int)id, (int)12, (float)roomRolloffFactor);
        EXTEfx.alEffecti((int)id, (int)13, (int)decayHFLimit);
        EXTEfx.alAuxiliaryEffectSloti((int)slot, (int)1, (int)id);
        EXTEfx.alAuxiliaryEffectSlotf((int)slot, (int)2, (float)1.0f);
        return true;
    }

    public static int getSlot() {
        return slot;
    }

    private static void reset() {
        enabled = false;
        density = Config.getData().reverbFilter.density;
        diffusion = Config.getData().reverbFilter.diffusion;
        gain = Config.getData().reverbFilter.gain;
        gainHF = Config.getData().reverbFilter.gainHF;
        decayTime = Config.getData().reverbFilter.minDecayTime;
        decayHFRatio = Config.getData().reverbFilter.decayHFRatio;
        reflectionsGain = 0.0f;
        reflectionsDelay = 0.0f;
        lateReverbGain = 0.0f;
        lateReverbDelay = 0.0f;
        airAbsorptionGainHF = Config.getData().reverbFilter.airAbsorptionGainHF;
        roomRolloffFactor = 0.0f;
    }

    private static void update(class_310 client) {
        enabled = Config.getData().reverbFilter.enabled;
        int maxBlocks = Config.getData().reverbFilter.maxBlocks;
        boolean checkSky = Config.getData().reverbFilter.checkSky;
        float reverbPercent = Config.getData().reverbFilter.reverbPercent;
        float minDecayTime = Config.getData().reverbFilter.minDecayTime;
        float reflectionGainBase = Config.getData().reverbFilter.reflectionsGainBase;
        float reflectionGainMultiplier = Config.getData().reverbFilter.reflectionsGainMultiplier;
        float reflectionDelayMultiplier = Config.getData().reverbFilter.reflectionsDelayMultiplier;
        float lateReverbGainBase = Config.getData().reverbFilter.lateReverbGainBase;
        float lateReverbGainMultiplier = Config.getData().reverbFilter.lateReverbGainMultiplier;
        float lateReverbDelayMultiplier = Config.getData().reverbFilter.lateReverbDelayMultiplier;
        List<class_3614> HIGH_REVERB_MATERIALS = Arrays.asList(class_3614.field_15914, class_3614.field_15942, class_3614.field_15958, class_3614.field_15928, class_3614.field_15953);
        List<class_3614> LOW_REVERB_MATERIALS = Arrays.asList(class_3614.field_15931, class_3614.field_15957, class_3614.field_15923, class_3614.field_15935, class_3614.field_15947, class_3614.field_15956, class_3614.field_15926, class_3614.field_15945, class_3614.field_15954, class_3614.field_15925, class_3614.field_15913, class_3614.field_15937, class_3614.field_15917, class_3614.field_15948, class_3614.field_15934);
        float baseReverb = 0.0f;
        if (client.field_1687.method_8597().method_12460() == class_2874.field_13076) {
            baseReverb = 1.0f;
        }
        if (enabled && tickCount++ == 20) {
            tickCount = 0;
            class_2338 playerPos = new class_2338(class_3532.method_15357((double)client.field_1724.method_19538().method_10216()), class_3532.method_15357((double)(client.field_1724.method_19538().method_10214() + (double)client.field_1724.method_18381(client.field_1724.method_18376()))), class_3532.method_15357((double)client.field_1724.method_19538().method_10215()));
            Random random = new Random();
            TreeSet<class_2338> visited = new TreeSet<class_2338>();
            ArrayList<class_2680> blocksFound = new ArrayList<class_2680>();
            LinkedList<class_2338> toVisit = new LinkedList<class_2338>();
            toVisit.add(playerPos);
            for (int i = 0; i < maxBlocks && !toVisit.isEmpty(); ++i) {
                class_2338 current = (class_2338)toVisit.remove(random.nextInt(toVisit.size()));
                visited.add(current);
                for (class_2350 direction : class_2350.values()) {
                    class_2338 pos = current.method_10093(direction);
                    class_2680 blockState = client.field_1687.method_8320(pos);
                    class_3614 material = blockState.method_11620();
                    if (!material.method_15801()) {
                        if (!visited.contains(pos) && !toVisit.contains(pos)) {
                            toVisit.add(pos);
                        }
                        if (blockState.method_11588() || material == class_3614.field_15920 || material == class_3614.field_15922) continue;
                        blocksFound.add(blockState);
                        continue;
                    }
                    blocksFound.add(blockState);
                }
            }
            double highReverb = 0.0;
            double midReverb = 0.0;
            double lowReverb = 0.0;
            for (class_2680 blockState : blocksFound) {
                if (HIGH_REVERB_MATERIALS.contains(blockState.method_11620())) {
                    highReverb += 1.0;
                    continue;
                }
                if (LOW_REVERB_MATERIALS.contains(blockState.method_11620())) {
                    lowReverb += 1.0;
                    continue;
                }
                midReverb += 1.0;
            }
            float decayFactor = baseReverb;
            if (highReverb + midReverb + lowReverb > 0.0) {
                decayFactor = (float)((double)decayFactor + (highReverb - lowReverb) / (highReverb + midReverb + lowReverb));
            }
            decayFactor = Math.max(0.0f, Math.min(decayFactor, 1.0f));
            int roomSize = visited.size();
            float roomFactor = (float)roomSize / (float)maxBlocks;
            float skyFactor = 0.0f;
            if (checkSky && roomSize == maxBlocks) {
                class_2350[] directions;
                if (ReverbFilter.hasSkyAbove(client.field_1687, playerPos)) {
                    skyFactor += 1.0f;
                }
                for (class_2350 direction : directions = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
                    if (ReverbFilter.hasSkyAbove(client.field_1687, playerPos.method_10079(direction, random.nextInt(5) + 5))) {
                        skyFactor += 1.0f;
                    }
                    if (!ReverbFilter.hasSkyAbove(client.field_1687, playerPos.method_10079(direction, random.nextInt(5) + 5).method_10086(5))) continue;
                    skyFactor += 1.0f;
                }
            }
            skyFactor = 1.0f - skyFactor / 9.0f;
            skyFactor *= skyFactor;
            decayFactor = (decayFactor + prevDecayFactor) / 2.0f;
            roomFactor = (roomFactor + prevRoomFactor) / 2.0f;
            skyFactor = (skyFactor + prevSkyFactor) / 2.0f;
            prevDecayFactor = decayFactor;
            prevRoomFactor = roomFactor;
            prevSkyFactor = skyFactor;
            decayTime = reverbPercent * 6.0f * decayFactor * roomFactor * skyFactor;
            if (decayTime < minDecayTime) {
                decayTime = minDecayTime;
            }
            reflectionsGain = reverbPercent * (reflectionGainBase + reflectionGainMultiplier * roomFactor);
            reflectionsDelay = reflectionDelayMultiplier * roomFactor;
            lateReverbGain = reverbPercent * (lateReverbGainBase + lateReverbGainMultiplier * roomFactor);
            lateReverbDelay = lateReverbDelayMultiplier * roomFactor;
        }
    }

    private static boolean hasSkyAbove(class_638 world, class_2338 pos) {
        class_2791 chunk = world.method_22350(pos);
        class_2902 heightMap = chunk.method_12032(class_2902.class_2903.field_13197);
        int x = pos.method_10263() - chunk.method_12004().method_8326();
        int z = pos.method_10260() - chunk.method_12004().method_8328();
        x = Math.max(0, Math.min(x, 15));
        z = Math.max(0, Math.min(z, 15));
        return heightMap != null && heightMap.method_12603(x, z) <= pos.method_10264();
    }
}

