/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.dynamicsf.filter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.andre111.dynamicsf.config.Config;
import me.andre111.dynamicsf.filter.LiquidFilter;
import net.minecraft.class_1113;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import org.lwjgl.openal.EXTEfx;

public class ObstructionFilter {
    private static int id = -1;
    private static boolean enabled = false;
    private static Map<class_1113, Float> obstructions = new HashMap<class_1113, Float>();
    private static List<class_3614> HIGH_OBSTRUCTION_MATERIALS = Arrays.asList(class_3614.field_15931, class_3614.field_15917);

    public static void updateGlobal(class_310 client) {
        LiquidFilter.updateGlobal(client);
        if (client.field_1687 != null && client.field_1724 != null && client.method_22108()) {
            ObstructionFilter.update(client);
        } else {
            ObstructionFilter.reset();
        }
    }

    public static boolean updateSoundInstance(class_1113 soundInstance) {
        if (id == -1) {
            id = EXTEfx.alGenFilters();
        }
        float lowPassGain = 1.0f;
        float lowPassGainHF = 1.0f;
        if (LiquidFilter.updateSoundInstance(soundInstance)) {
            lowPassGain = LiquidFilter.getLowPassGain();
            lowPassGainHF = LiquidFilter.getLowPassGainHF();
        }
        if (enabled && soundInstance.method_4777() == class_1113.class_1114.field_5476) {
            float obstructionAmount;
            if (!obstructions.containsKey(soundInstance)) {
                obstructions.put(soundInstance, Float.valueOf(0.0f));
            }
            if ((double)(obstructionAmount = obstructions.get(soundInstance).floatValue()) > 0.01) {
                lowPassGain *= 1.0f - obstructionAmount;
                lowPassGainHF *= 1.0f - class_3532.method_15355((float)obstructionAmount);
            }
        }
        lowPassGain = Math.max(0.0f, Math.min(lowPassGain, 1.0f));
        lowPassGainHF = Math.max(0.0f, Math.min(lowPassGainHF, 1.0f));
        if (lowPassGain >= 1.0f && lowPassGainHF >= 1.0f) {
            return false;
        }
        EXTEfx.alFilteri((int)id, (int)32769, (int)1);
        EXTEfx.alFilterf((int)id, (int)1, (float)lowPassGain);
        EXTEfx.alFilterf((int)id, (int)2, (float)lowPassGainHF);
        return true;
    }

    public static int getID() {
        return id;
    }

    private static void reset() {
        enabled = false;
        obstructions.clear();
    }

    private static void update(class_310 client) {
        enabled = Config.getData().obstructionFilter.enabled;
        obstructions.entrySet().removeIf(entry -> !client.method_1483().method_4877((class_1113)entry.getKey()));
        for (Map.Entry<class_1113, Float> e : obstructions.entrySet()) {
            float currentAmount = e.getValue().floatValue();
            float nextAmount = ObstructionFilter.getObstructionAmount(client, e.getKey());
            e.setValue(Float.valueOf((currentAmount * 3.0f + nextAmount) / 4.0f));
        }
    }

    private static float getObstructionAmount(class_310 client, class_1113 soundInstance) {
        class_243 soundPosD;
        float obstructionStep = Config.getData().obstructionFilter.obstructionStep;
        float obstructionMax = Config.getData().obstructionFilter.obstructionMax;
        class_243 playerPosD = client.field_1724.method_19538().method_1031(0.0, (double)client.field_1724.method_18381(client.field_1724.method_18376()), 0.0);
        class_243 currentPosD = soundPosD = new class_243(soundInstance.method_4784(), soundInstance.method_4779(), soundInstance.method_4778());
        if (Double.isNaN(playerPosD.field_1352) || Double.isNaN(playerPosD.field_1351) || Double.isNaN(playerPosD.field_1350)) {
            return 0.0f;
        }
        if (Double.isNaN(soundPosD.field_1352) || Double.isNaN(soundPosD.field_1351) || Double.isNaN(soundPosD.field_1350)) {
            return 0.0f;
        }
        class_2338 playerPos = new class_2338(playerPosD);
        class_2338.class_2339 currentPos = new class_2338.class_2339(soundPosD.field_1352, soundPosD.field_1351, soundPosD.field_1350);
        float obstruction = 0.0f;
        for (int i = 0; i < 100; ++i) {
            float newObstruction;
            class_243 prevPosD = currentPosD;
            if (playerPos.equals((Object)currentPos)) {
                return obstruction;
            }
            boolean changeX = currentPos.method_10263() != playerPos.method_10263();
            boolean changeY = currentPos.method_10264() != playerPos.method_10264();
            boolean changeZ = currentPos.method_10260() != playerPos.method_10260();
            int nextBlockX = currentPos.method_10263() + (changeX ? (currentPos.method_10263() < playerPos.method_10263() ? 1 : -1) : 0);
            int nextBlockY = currentPos.method_10264() + (changeY ? (currentPos.method_10264() < playerPos.method_10264() ? 1 : -1) : 0);
            int nextBlockZ = currentPos.method_10260() + (changeZ ? (currentPos.method_10260() < playerPos.method_10260() ? 1 : -1) : 0);
            double progressPercentX = changeX ? Math.abs(((double)nextBlockX - soundPosD.field_1352) / ((double)playerPos.method_10263() - soundPosD.field_1352)) : Double.POSITIVE_INFINITY;
            double progressPercentY = changeY ? Math.abs(((double)nextBlockY - soundPosD.field_1351) / ((double)playerPos.method_10264() - soundPosD.field_1351)) : Double.POSITIVE_INFINITY;
            double progressPercentZ = changeZ ? Math.abs(((double)nextBlockZ - soundPosD.field_1350) / ((double)playerPos.method_10260() - soundPosD.field_1350)) : Double.POSITIVE_INFINITY;
            double progressPercent = Math.min(Math.min(progressPercentX, progressPercentY), progressPercentZ);
            currentPosD = new class_243(soundPosD.field_1352 + (playerPosD.field_1352 - soundPosD.field_1352) * progressPercent, soundPosD.field_1351 + (playerPosD.field_1351 - soundPosD.field_1351) * progressPercent, soundPosD.field_1350 + (playerPosD.field_1350 - soundPosD.field_1350) * progressPercent);
            currentPos.method_10102(currentPosD.field_1352, currentPosD.field_1351, currentPosD.field_1350);
            class_2680 blockState = client.field_1687.method_8320((class_2338)currentPos);
            if (!blockState.method_26234((class_1922)client.field_1687, (class_2338)currentPos) || !((obstruction = (float)((double)obstruction + (double)(newObstruction = HIGH_OBSTRUCTION_MATERIALS.contains(blockState.method_26207()) ? obstructionStep * 2.0f : obstructionStep) * currentPosD.method_1022(prevPosD))) > obstructionMax)) continue;
            return obstructionMax;
        }
        return obstruction;
    }
}

