/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModClientEventHandler {
    private static final HashMap<BuildModes.BuildModeEnum, ResourceLocation> buildModeIcons = new HashMap();
    private static final HashMap<ModeOptions.ActionEnum, ResourceLocation> modeOptionIcons = new HashMap();

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        ResourceLocation spriteLocation;
        for (BuildModes.BuildModeEnum buildModeEnum : BuildModes.BuildModeEnum.values()) {
            spriteLocation = new ResourceLocation("effortlessbuilding", "icons/" + buildModeEnum.name().toLowerCase());
            event.addSprite(spriteLocation);
            buildModeIcons.put(buildModeEnum, spriteLocation);
        }
        for (Enum enum_ : ModeOptions.ActionEnum.values()) {
            spriteLocation = new ResourceLocation("effortlessbuilding", "icons/" + enum_.name().toLowerCase());
            event.addSprite(spriteLocation);
            modeOptionIcons.put((ModeOptions.ActionEnum)enum_, spriteLocation);
        }
    }

    public static TextureAtlasSprite getBuildModeIcon(BuildModes.BuildModeEnum mode) {
        return Minecraft.func_71410_x().func_147117_R().func_195424_a(buildModeIcons.get((Object)mode));
    }

    public static TextureAtlasSprite getModeOptionIcon(ModeOptions.ActionEnum action) {
        return Minecraft.func_71410_x().func_147117_R().func_195424_a(modeOptionIcons.get((Object)action));
    }
}

