/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.BlockSet;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.buildmodifier.UndoRedo;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.helper.InventoryHelper;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;
import nl.requios.effortlessbuilding.item.ItemRandomizerBag;
import nl.requios.effortlessbuilding.render.BlockPreviewRenderer;

public class BuildModifiers {
    public static void onBlockPlaced(PlayerEntity player, List<BlockPos> startCoordinates, Direction sideHit, Vec3d hitVec, boolean placeStartPos) {
        World world = player.field_70170_p;
        ItemRandomizerBag.renewRandomness();
        hitVec = new Vec3d(Math.abs(hitVec.field_72450_a - (double)((int)hitVec.field_72450_a)), Math.abs(hitVec.field_72448_b - (double)((int)hitVec.field_72448_b)), Math.abs(hitVec.field_72449_c - (double)((int)hitVec.field_72449_c)));
        List<BlockPos> coordinates = BuildModifiers.findCoordinates(player, startCoordinates);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        List<BlockState> blockStates = BuildModifiers.findBlockStates(player, startCoordinates, hitVec, sideHit, itemStacks);
        if (blockStates.size() == 0 || coordinates.size() != blockStates.size()) {
            return;
        }
        ArrayList<BlockState> previousBlockStates = new ArrayList<BlockState>(coordinates.size());
        List<Object> newBlockStates = new ArrayList(coordinates.size());
        for (BlockPos coordinate : coordinates) {
            previousBlockStates.add(world.func_180495_p(coordinate));
        }
        if (world.field_72995_K) {
            BlockPreviewRenderer.onBlocksPlaced();
            newBlockStates = blockStates;
        } else {
            int i;
            int n = i = placeStartPos ? 0 : 1;
            while (i < coordinates.size()) {
                BlockPos blockPos = coordinates.get(i);
                BlockState blockState = blockStates.get(i);
                ItemStack itemStack = (ItemStack)itemStacks.get(i);
                if (!(!world.func_195588_v(blockPos) || itemStack.func_190926_b() && (itemStack = InventoryHelper.findItemStackInInventory(player, blockState.func_177230_c())).func_190926_b())) {
                    SurvivalHelper.placeBlock(world, player, blockPos, blockState, itemStack, Direction.UP, hitVec, false, false, false);
                }
                ++i;
            }
            for (BlockPos coordinate : coordinates) {
                newBlockStates.add(world.func_180495_p(coordinate));
            }
        }
        if (!placeStartPos) {
            previousBlockStates.set(0, Blocks.field_150350_a.func_176223_P());
        }
        if (Collections.frequency(newBlockStates, Blocks.field_150350_a.func_176223_P()) != newBlockStates.size()) {
            BlockPos firstPos = startCoordinates.get(0);
            BlockPos secondPos = startCoordinates.get(startCoordinates.size() - 1);
            UndoRedo.addUndo(player, new BlockSet(coordinates, previousBlockStates, newBlockStates, hitVec, firstPos, secondPos));
        }
    }

    public static void onBlockBroken(PlayerEntity player, List<BlockPos> startCoordinates, boolean breakStartPos) {
        World world = player.field_70170_p;
        List<BlockPos> coordinates = BuildModifiers.findCoordinates(player, startCoordinates);
        if (coordinates.isEmpty()) {
            return;
        }
        ArrayList<BlockState> previousBlockStates = new ArrayList<BlockState>(coordinates.size());
        ArrayList<BlockState> newBlockStates = new ArrayList<BlockState>(coordinates.size());
        for (BlockPos coordinate : coordinates) {
            previousBlockStates.add(world.func_180495_p(coordinate));
        }
        if (world.field_72995_K) {
            BlockPreviewRenderer.onBlocksBroken();
            for (int i = 0; i < coordinates.size(); ++i) {
                newBlockStates.add(Blocks.field_150350_a.func_176223_P());
            }
        } else {
            int i;
            boolean onlyInstaBreaking = !player.func_184812_l_() && world.func_180495_p(startCoordinates.get(0)).func_185887_b((IBlockReader)world, startCoordinates.get(0)) == 0.0f;
            int n = i = breakStartPos ? 0 : 1;
            while (i < coordinates.size()) {
                BlockPos coordinate = coordinates.get(i);
                if (!(!world.func_195588_v(coordinate) || world.func_175623_d(coordinate) || onlyInstaBreaking && world.func_180495_p(coordinate).func_185887_b((IBlockReader)world, coordinate) != 0.0f)) {
                    SurvivalHelper.breakBlock(world, player, coordinate, false);
                }
                ++i;
            }
            for (BlockPos coordinate : coordinates) {
                newBlockStates.add(world.func_180495_p(coordinate));
            }
        }
        if (!breakStartPos) {
            newBlockStates.set(0, Blocks.field_150350_a.func_176223_P());
        }
        BlockPos firstPos = startCoordinates.get(0);
        BlockPos secondPos = startCoordinates.get(startCoordinates.size() - 1);
        Vec3d hitVec = new Vec3d(0.5, 0.5, 0.5);
        UndoRedo.addUndo(player, new BlockSet(coordinates, previousBlockStates, newBlockStates, hitVec, firstPos, secondPos));
    }

    public static List<BlockPos> findCoordinates(PlayerEntity player, List<BlockPos> posList) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        coordinates.addAll(posList);
        for (BlockPos blockPos : posList) {
            List<BlockPos> arrayCoordinates = Array.findCoordinates(player, blockPos);
            coordinates.addAll(arrayCoordinates);
            coordinates.addAll(Mirror.findCoordinates(player, blockPos));
            coordinates.addAll(RadialMirror.findCoordinates(player, blockPos));
            for (BlockPos coordinate : arrayCoordinates) {
                coordinates.addAll(Mirror.findCoordinates(player, coordinate));
                coordinates.addAll(RadialMirror.findCoordinates(player, coordinate));
            }
        }
        return coordinates;
    }

    public static List<BlockPos> findCoordinates(PlayerEntity player, BlockPos blockPos) {
        return BuildModifiers.findCoordinates(player, new ArrayList<BlockPos>(Arrays.asList(blockPos)));
    }

    public static List<BlockState> findBlockStates(PlayerEntity player, List<BlockPos> posList, Vec3d hitVec, Direction facing, List<ItemStack> itemStacks) {
        BlockState blockState;
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        itemStacks.clear();
        ItemStack itemStack = player.func_184586_b(Hand.MAIN_HAND);
        if (itemStack.func_190926_b() || !CompatHelper.isItemBlockProxy(itemStack)) {
            itemStack = player.func_184586_b(Hand.OFF_HAND);
        }
        if (itemStack.func_190926_b() || !CompatHelper.isItemBlockProxy(itemStack)) {
            return blockStates;
        }
        ItemStack itemBlock = ItemStack.field_190927_a;
        itemBlock = itemStack.func_77973_b() instanceof BlockItem ? itemStack : CompatHelper.getItemBlockFromStack(itemStack);
        ItemRandomizerBag.resetRandomness();
        for (BlockPos blockPos : posList) {
            if (!(itemStack.func_77973_b() instanceof BlockItem)) {
                itemBlock = CompatHelper.getItemBlockFromStack(itemStack);
            }
            blockState = BuildModifiers.getBlockStateFromItem(itemBlock, player, blockPos, facing, hitVec, Hand.MAIN_HAND);
            blockStates.add(blockState);
            itemStacks.add(itemBlock);
        }
        for (BlockPos blockPos : posList) {
            blockState = BuildModifiers.getBlockStateFromItem(itemBlock, player, blockPos, facing, hitVec, Hand.MAIN_HAND);
            List<BlockState> arrayBlockStates = Array.findBlockStates(player, blockPos, blockState, itemStack, itemStacks);
            blockStates.addAll(arrayBlockStates);
            blockStates.addAll(Mirror.findBlockStates(player, blockPos, blockState, itemStack, itemStacks));
            blockStates.addAll(RadialMirror.findBlockStates(player, blockPos, blockState, itemStack, itemStacks));
            List<BlockPos> arrayCoordinates = Array.findCoordinates(player, blockPos);
            for (int i = 0; i < arrayCoordinates.size(); ++i) {
                BlockPos coordinate = arrayCoordinates.get(i);
                BlockState blockState1 = arrayBlockStates.get(i);
                blockStates.addAll(Mirror.findBlockStates(player, coordinate, blockState1, itemStack, itemStacks));
                blockStates.addAll(RadialMirror.findBlockStates(player, coordinate, blockState1, itemStack, itemStacks));
            }
        }
        return blockStates;
    }

    public static boolean isEnabled(ModifierSettingsManager.ModifierSettings modifierSettings, BlockPos startPos) {
        return Mirror.isEnabled(modifierSettings.getMirrorSettings(), startPos) || Array.isEnabled(modifierSettings.getArraySettings()) || RadialMirror.isEnabled(modifierSettings.getRadialMirrorSettings(), startPos) || modifierSettings.doQuickReplace();
    }

    public static BlockState getBlockStateFromItem(ItemStack itemStack, PlayerEntity player, BlockPos blockPos, Direction facing, Vec3d hitVec, Hand hand) {
        return Block.func_149634_a((Item)itemStack.func_77973_b()).func_196258_a(new BlockItemUseContext(new ItemUseContext(player, hand, new BlockRayTraceResult(hitVec, facing, blockPos, false))));
    }

    public static boolean compareCoordinates(List<BlockPos> coordinates1, List<BlockPos> coordinates2) {
        if (coordinates1 == null && coordinates2 == null) {
            return true;
        }
        if (coordinates1 == null || coordinates2 == null) {
            return false;
        }
        if (coordinates1.size() == coordinates2.size()) {
            if (coordinates1.size() == 1) {
                return coordinates1.get(0).equals((Object)coordinates2.get(0));
            }
            return true;
        }
        return false;
    }
}

