/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.item.ItemRandomizerBag;

public class Mirror {
    public static List<BlockPos> findCoordinates(PlayerEntity player, BlockPos startPos) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        MirrorSettings m = ModifierSettingsManager.getModifierSettings(player).getMirrorSettings();
        if (!Mirror.isEnabled(m, startPos)) {
            return coordinates;
        }
        if (m.mirrorX) {
            Mirror.coordinateMirrorX(m, startPos, coordinates);
        }
        if (m.mirrorY) {
            Mirror.coordinateMirrorY(m, startPos, coordinates);
        }
        if (m.mirrorZ) {
            Mirror.coordinateMirrorZ(m, startPos, coordinates);
        }
        return coordinates;
    }

    private static void coordinateMirrorX(MirrorSettings m, BlockPos oldBlockPos, List<BlockPos> coordinates) {
        double x = m.position.field_72450_a + (m.position.field_72450_a - (double)oldBlockPos.func_177958_n() - 0.5);
        BlockPos newBlockPos = new BlockPos(x, (double)oldBlockPos.func_177956_o(), (double)oldBlockPos.func_177952_p());
        coordinates.add(newBlockPos);
        if (m.mirrorY) {
            Mirror.coordinateMirrorY(m, newBlockPos, coordinates);
        }
        if (m.mirrorZ) {
            Mirror.coordinateMirrorZ(m, newBlockPos, coordinates);
        }
    }

    private static void coordinateMirrorY(MirrorSettings m, BlockPos oldBlockPos, List<BlockPos> coordinates) {
        double y = m.position.field_72448_b + (m.position.field_72448_b - (double)oldBlockPos.func_177956_o() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)oldBlockPos.func_177958_n(), y, (double)oldBlockPos.func_177952_p());
        coordinates.add(newBlockPos);
        if (m.mirrorZ) {
            Mirror.coordinateMirrorZ(m, newBlockPos, coordinates);
        }
    }

    private static void coordinateMirrorZ(MirrorSettings m, BlockPos oldBlockPos, List<BlockPos> coordinates) {
        double z = m.position.field_72449_c + (m.position.field_72449_c - (double)oldBlockPos.func_177952_p() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)oldBlockPos.func_177958_n(), (double)oldBlockPos.func_177956_o(), z);
        coordinates.add(newBlockPos);
    }

    public static List<BlockState> findBlockStates(PlayerEntity player, BlockPos startPos, BlockState blockState, ItemStack itemStack, List<ItemStack> itemStacks) {
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        MirrorSettings m = ModifierSettingsManager.getModifierSettings(player).getMirrorSettings();
        if (!Mirror.isEnabled(m, startPos)) {
            return blockStates;
        }
        IItemHandler bagInventory = null;
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemRandomizerBag) {
            bagInventory = ItemRandomizerBag.getBagInventory(itemStack);
        }
        if (m.mirrorX) {
            Mirror.blockStateMirrorX(player, m, startPos, blockState, bagInventory, itemStack, Hand.MAIN_HAND, blockStates, itemStacks);
        }
        if (m.mirrorY) {
            Mirror.blockStateMirrorY(player, m, startPos, blockState, bagInventory, itemStack, Hand.MAIN_HAND, blockStates, itemStacks);
        }
        if (m.mirrorZ) {
            Mirror.blockStateMirrorZ(player, m, startPos, blockState, bagInventory, itemStack, Hand.MAIN_HAND, blockStates, itemStacks);
        }
        return blockStates;
    }

    private static void blockStateMirrorX(PlayerEntity player, MirrorSettings m, BlockPos oldBlockPos, BlockState oldBlockState, IItemHandler bagInventory, ItemStack itemStack, Hand hand, List<BlockState> blockStates, List<ItemStack> itemStacks) {
        double x = m.position.field_72450_a + (m.position.field_72450_a - (double)oldBlockPos.func_177958_n() - 0.5);
        BlockPos newBlockPos = new BlockPos(x, (double)oldBlockPos.func_177956_o(), (double)oldBlockPos.func_177952_p());
        if (bagInventory != null) {
            itemStack = ItemRandomizerBag.pickRandomStack(bagInventory);
            oldBlockState = BuildModifiers.getBlockStateFromItem(itemStack, player, oldBlockPos, Direction.UP, new Vec3d(0.0, 0.0, 0.0), hand);
        }
        BlockState newBlockState = oldBlockState == null ? null : oldBlockState.func_185902_a(net.minecraft.util.Mirror.FRONT_BACK);
        blockStates.add(newBlockState);
        itemStacks.add(itemStack);
        if (m.mirrorY) {
            Mirror.blockStateMirrorY(player, m, newBlockPos, newBlockState, bagInventory, itemStack, hand, blockStates, itemStacks);
        }
        if (m.mirrorZ) {
            Mirror.blockStateMirrorZ(player, m, newBlockPos, newBlockState, bagInventory, itemStack, hand, blockStates, itemStacks);
        }
    }

    private static void blockStateMirrorY(PlayerEntity player, MirrorSettings m, BlockPos oldBlockPos, BlockState oldBlockState, IItemHandler bagInventory, ItemStack itemStack, Hand hand, List<BlockState> blockStates, List<ItemStack> itemStacks) {
        double y = m.position.field_72448_b + (m.position.field_72448_b - (double)oldBlockPos.func_177956_o() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)oldBlockPos.func_177958_n(), y, (double)oldBlockPos.func_177952_p());
        if (bagInventory != null) {
            itemStack = ItemRandomizerBag.pickRandomStack(bagInventory);
            oldBlockState = BuildModifiers.getBlockStateFromItem(itemStack, player, oldBlockPos, Direction.UP, new Vec3d(0.0, 0.0, 0.0), hand);
        }
        BlockState newBlockState = oldBlockState == null ? null : Mirror.getVerticalMirror(oldBlockState);
        blockStates.add(newBlockState);
        itemStacks.add(itemStack);
        if (m.mirrorZ) {
            Mirror.blockStateMirrorZ(player, m, newBlockPos, newBlockState, bagInventory, itemStack, hand, blockStates, itemStacks);
        }
    }

    private static void blockStateMirrorZ(PlayerEntity player, MirrorSettings m, BlockPos oldBlockPos, BlockState oldBlockState, IItemHandler bagInventory, ItemStack itemStack, Hand hand, List<BlockState> blockStates, List<ItemStack> itemStacks) {
        double z = m.position.field_72449_c + (m.position.field_72449_c - (double)oldBlockPos.func_177952_p() - 0.5);
        BlockPos newBlockPos = new BlockPos((double)oldBlockPos.func_177958_n(), (double)oldBlockPos.func_177956_o(), z);
        if (bagInventory != null) {
            itemStack = ItemRandomizerBag.pickRandomStack(bagInventory);
            oldBlockState = BuildModifiers.getBlockStateFromItem(itemStack, player, oldBlockPos, Direction.UP, new Vec3d(0.0, 0.0, 0.0), hand);
        }
        BlockState newBlockState = oldBlockState == null ? null : oldBlockState.func_185902_a(net.minecraft.util.Mirror.LEFT_RIGHT);
        blockStates.add(newBlockState);
        itemStacks.add(itemStack);
    }

    public static boolean isEnabled(MirrorSettings m, BlockPos startPos) {
        if (m == null || !m.enabled || !m.mirrorX && !m.mirrorY && !m.mirrorZ) {
            return false;
        }
        return !((double)startPos.func_177958_n() + 0.5 < m.position.field_72450_a - (double)m.radius || (double)startPos.func_177958_n() + 0.5 > m.position.field_72450_a + (double)m.radius || (double)startPos.func_177956_o() + 0.5 < m.position.field_72448_b - (double)m.radius || (double)startPos.func_177956_o() + 0.5 > m.position.field_72448_b + (double)m.radius || (double)startPos.func_177952_p() + 0.5 < m.position.field_72449_c - (double)m.radius) && !((double)startPos.func_177952_p() + 0.5 > m.position.field_72449_c + (double)m.radius);
    }

    private static BlockState getVerticalMirror(BlockState blockState) {
        if (blockState.func_177230_c() instanceof StairsBlock) {
            if (blockState.func_177229_b((IProperty)StairsBlock.field_176308_b) == Half.BOTTOM) {
                return (BlockState)blockState.func_206870_a((IProperty)StairsBlock.field_176308_b, (Comparable)Half.TOP);
            }
            return (BlockState)blockState.func_206870_a((IProperty)StairsBlock.field_176308_b, (Comparable)Half.BOTTOM);
        }
        if (blockState.func_177230_c() instanceof SlabBlock) {
            if (blockState.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.DOUBLE) {
                return blockState;
            }
            if (blockState.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM) {
                return (BlockState)blockState.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
            }
            return (BlockState)blockState.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM);
        }
        if (blockState.func_177230_c() instanceof DirectionalBlock) {
            if (blockState.func_177229_b((IProperty)DirectionalBlock.field_176387_N) == Direction.DOWN) {
                return (BlockState)blockState.func_206870_a((IProperty)DirectionalBlock.field_176387_N, (Comparable)Direction.UP);
            }
            if (blockState.func_177229_b((IProperty)DirectionalBlock.field_176387_N) == Direction.UP) {
                return (BlockState)blockState.func_206870_a((IProperty)DirectionalBlock.field_176387_N, (Comparable)Direction.DOWN);
            }
        }
        if (blockState.func_177230_c() instanceof DispenserBlock) {
            if (blockState.func_177229_b((IProperty)DispenserBlock.field_176441_a) == Direction.DOWN) {
                return (BlockState)blockState.func_206870_a((IProperty)DispenserBlock.field_176441_a, (Comparable)Direction.UP);
            }
            if (blockState.func_177229_b((IProperty)DispenserBlock.field_176441_a) == Direction.UP) {
                return (BlockState)blockState.func_206870_a((IProperty)DispenserBlock.field_176441_a, (Comparable)Direction.DOWN);
            }
        }
        return blockState;
    }

    public static class MirrorSettings {
        public boolean enabled = false;
        public Vec3d position = new Vec3d(0.5, 64.5, 0.5);
        public boolean mirrorX = true;
        public boolean mirrorY = false;
        public boolean mirrorZ = false;
        public int radius = 10;
        public boolean drawLines = true;
        public boolean drawPlanes = true;

        public MirrorSettings() {
        }

        public MirrorSettings(boolean mirrorEnabled, Vec3d position, boolean mirrorX, boolean mirrorY, boolean mirrorZ, int radius, boolean drawLines, boolean drawPlanes) {
            this.enabled = mirrorEnabled;
            this.position = position;
            this.mirrorX = mirrorX;
            this.mirrorY = mirrorY;
            this.mirrorZ = mirrorZ;
            this.radius = radius;
            this.drawLines = drawLines;
            this.drawPlanes = drawPlanes;
        }

        public int getReach() {
            return this.radius * 2;
        }
    }
}

