/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.compatibility;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.item.ItemRandomizerBag;

public class CompatHelper {
    public static void setup() {
    }

    public static boolean isItemBlockProxy(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem) {
            return true;
        }
        return item instanceof ItemRandomizerBag;
    }

    public static ItemStack getItemBlockFromStack(ItemStack proxy) {
        Item proxyItem = proxy.func_77973_b();
        if (proxyItem instanceof BlockItem) {
            return proxy;
        }
        if (proxyItem instanceof ItemRandomizerBag) {
            ItemStack itemStack = proxy;
            while (!(itemStack.func_77973_b() instanceof BlockItem) && !itemStack.func_190926_b()) {
                if (!(itemStack.func_77973_b() instanceof ItemRandomizerBag)) continue;
                itemStack = ItemRandomizerBag.pickRandomStack(ItemRandomizerBag.getBagInventory(itemStack));
            }
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getItemBlockByState(ItemStack stack, BlockState state) {
        if (state == null) {
            return ItemStack.field_190927_a;
        }
        Item blockItem = Item.func_150898_a((Block)state.func_177230_c());
        if (stack.func_77973_b() instanceof BlockItem) {
            return stack;
        }
        if (stack.func_77973_b() instanceof ItemRandomizerBag) {
            IItemHandler bagInventory = ItemRandomizerBag.getBagInventory(stack);
            return ItemRandomizerBag.findStack(bagInventory, blockItem);
        }
        return ItemStack.field_190927_a;
    }

    public static void shrinkStack(ItemStack origStack, ItemStack curStack, PlayerEntity player) {
        curStack.func_190918_g(1);
    }

    private static int itemHandlerSlotForItem(ItemStack stack, Item blockItem) {
        LazyOptional itemHandlerLazyOptional = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        IItemHandler handler = (IItemHandler)itemHandlerLazyOptional.orElse(null);
        if (handler == null) {
            EffortlessBuilding.logger.warn("Itemblock proxy has no item handler capability!");
            return -1;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack ref = handler.getStackInSlot(i);
            if (!(ref.func_77973_b() instanceof BlockItem) || ref.func_77973_b() != blockItem) continue;
            return i;
        }
        return -1;
    }
}

