/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmodifier;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.gui.buildmodifier.ArraySettingsGui;
import nl.requios.effortlessbuilding.gui.buildmodifier.MirrorSettingsGui;
import nl.requios.effortlessbuilding.gui.buildmodifier.RadialMirrorSettingsGui;
import nl.requios.effortlessbuilding.gui.elements.GuiScrollPane;
import nl.requios.effortlessbuilding.network.ModifierSettingsMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.proxy.ClientProxy;

@OnlyIn(value=Dist.CLIENT)
public class ModifierSettingsGui
extends Screen {
    private GuiScrollPane scrollPane;
    private Button buttonClose;
    private MirrorSettingsGui mirrorSettingsGui;
    private ArraySettingsGui arraySettingsGui;
    private RadialMirrorSettingsGui radialMirrorSettingsGui;

    public ModifierSettingsGui() {
        super((ITextComponent)new TranslationTextComponent("effortlessbuilding.screen.modifier_settings", new Object[0]));
    }

    protected void init() {
        this.scrollPane = new GuiScrollPane(this, this.font, 8, this.height - 30);
        this.mirrorSettingsGui = new MirrorSettingsGui(this.scrollPane);
        this.scrollPane.AddListEntry(this.mirrorSettingsGui);
        this.arraySettingsGui = new ArraySettingsGui(this.scrollPane);
        this.scrollPane.AddListEntry(this.arraySettingsGui);
        this.radialMirrorSettingsGui = new RadialMirrorSettingsGui(this.scrollPane);
        this.scrollPane.AddListEntry(this.radialMirrorSettingsGui);
        this.scrollPane.init(this.buttons);
        int y = this.height - 26;
        this.buttonClose = new Button(this.width / 2 - 100, y, 200, 20, "Close", button -> Minecraft.func_71410_x().field_71439_g.func_71053_j());
        this.buttons.add(this.buttonClose);
    }

    public void tick() {
        this.scrollPane.updateScreen();
        this.handleMouseInput();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.scrollPane.render(mouseX, mouseY, partialTicks);
        this.buttonClose.render(mouseX, mouseY, partialTicks);
        this.scrollPane.drawTooltip(this, mouseX, mouseY);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        super.charTyped(typedChar, keyCode);
        this.scrollPane.charTyped(typedChar, keyCode);
        if (keyCode == ClientProxy.keyBindings[0].getKey().func_197937_c()) {
            this.minecraft.field_71439_g.func_71053_j();
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.buttons.forEach(button -> button.mouseClicked(mouseX, mouseY, mouseButton));
        return this.scrollPane.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        if (state != 0 || !this.scrollPane.mouseReleased(mouseX, mouseY, state)) {
            return super.mouseReleased(mouseX, mouseY, state);
        }
        return false;
    }

    public void handleMouseInput() {
        this.scrollPane.handleMouseInput();
    }

    public void removed() {
        this.scrollPane.onGuiClosed();
        Mirror.MirrorSettings m = this.mirrorSettingsGui.getMirrorSettings();
        Array.ArraySettings a = this.arraySettingsGui.getArraySettings();
        RadialMirror.RadialMirrorSettings r = this.radialMirrorSettingsGui.getRadialMirrorSettings();
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((PlayerEntity)this.minecraft.field_71439_g);
        if (modifierSettings == null) {
            modifierSettings = new ModifierSettingsManager.ModifierSettings();
        }
        modifierSettings.setMirrorSettings(m);
        modifierSettings.setArraySettings(a);
        modifierSettings.setRadialMirrorSettings(r);
        String error = ModifierSettingsManager.sanitize(modifierSettings, (PlayerEntity)this.minecraft.field_71439_g);
        if (!error.isEmpty()) {
            EffortlessBuilding.log((PlayerEntity)this.minecraft.field_71439_g, error);
        }
        ModifierSettingsManager.setModifierSettings((PlayerEntity)this.minecraft.field_71439_g, modifierSettings);
        PacketHandler.INSTANCE.sendToServer((Object)new ModifierSettingsMessage(modifierSettings));
        Minecraft.func_71410_x().field_71417_B.func_198034_i();
    }
}

