/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmodifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.gui.elements.GuiCheckBoxFixed;
import nl.requios.effortlessbuilding.gui.elements.GuiCollapsibleScrollEntry;
import nl.requios.effortlessbuilding.gui.elements.GuiIconButton;
import nl.requios.effortlessbuilding.gui.elements.GuiNumberField;
import nl.requios.effortlessbuilding.gui.elements.GuiScrollPane;
import nl.requios.effortlessbuilding.helper.ReachHelper;

@OnlyIn(value=Dist.CLIENT)
public class RadialMirrorSettingsGui
extends GuiCollapsibleScrollEntry {
    protected static final ResourceLocation BUILDING_ICONS = new ResourceLocation("effortlessbuilding", "textures/gui/building_icons.png");
    protected List<Button> radialMirrorButtonList = new ArrayList<Button>();
    protected List<GuiIconButton> radialMirrorIconButtonList = new ArrayList<GuiIconButton>();
    protected List<GuiNumberField> radialMirrorNumberFieldList = new ArrayList<GuiNumberField>();
    private GuiNumberField textRadialMirrorPosX;
    private GuiNumberField textRadialMirrorPosY;
    private GuiNumberField textRadialMirrorPosZ;
    private GuiNumberField textRadialMirrorSlices;
    private GuiNumberField textRadialMirrorRadius;
    private GuiCheckBoxFixed buttonRadialMirrorEnabled;
    private GuiCheckBoxFixed buttonRadialMirrorAlternate;
    private GuiIconButton buttonCurrentPosition;
    private GuiIconButton buttonToggleOdd;
    private GuiIconButton buttonDrawPlanes;
    private GuiIconButton buttonDrawLines;
    private boolean drawPlanes;
    private boolean drawLines;
    private boolean toggleOdd;

    public RadialMirrorSettingsGui(GuiScrollPane scrollPane) {
        super(scrollPane);
    }

    @Override
    public void init(List<Widget> buttonList) {
        super.init(buttonList);
        int y = this.top - 2;
        this.buttonRadialMirrorEnabled = new GuiCheckBoxFixed(this.left - 15 + 8, y, "", false){

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                RadialMirrorSettingsGui.this.setCollapsed(!RadialMirrorSettingsGui.this.buttonRadialMirrorEnabled.isChecked());
            }
        };
        buttonList.add((Widget)this.buttonRadialMirrorEnabled);
        y = this.top + 18;
        this.textRadialMirrorPosX = new GuiNumberField(this.font, buttonList, this.left + 58, y, 62, 18);
        this.textRadialMirrorPosX.setNumber(0.0);
        this.textRadialMirrorPosX.setTooltip(Arrays.asList("The position of the radial mirror.", TextFormatting.GRAY + "For odd numbered builds add 0.5."));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorPosX);
        this.textRadialMirrorPosY = new GuiNumberField(this.font, buttonList, this.left + 138, y, 62, 18);
        this.textRadialMirrorPosY.setNumber(64.0);
        this.textRadialMirrorPosY.setTooltip(Arrays.asList("The position of the radial mirror.", TextFormatting.GRAY + "For odd numbered builds add 0.5."));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorPosY);
        this.textRadialMirrorPosZ = new GuiNumberField(this.font, buttonList, this.left + 218, y, 62, 18);
        this.textRadialMirrorPosZ.setNumber(0.0);
        this.textRadialMirrorPosZ.setTooltip(Arrays.asList("The position of the radial mirror.", TextFormatting.GRAY + "For odd numbered builds add 0.5."));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorPosZ);
        y = this.top + 47;
        this.textRadialMirrorSlices = new GuiNumberField(this.font, buttonList, this.left + 55, y, 50, 18);
        this.textRadialMirrorSlices.setNumber(4.0);
        this.textRadialMirrorSlices.setTooltip(Arrays.asList("The number of repeating slices.", TextFormatting.GRAY + "Minimally 2."));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorSlices);
        this.textRadialMirrorRadius = new GuiNumberField(this.font, buttonList, this.left + 218, y, 62, 18);
        this.textRadialMirrorRadius.setNumber(50.0);
        this.textRadialMirrorRadius.setTooltip(Arrays.asList("How far the radial mirror reaches from its center position.", TextFormatting.GRAY + "Max: " + TextFormatting.GOLD + ReachHelper.getMaxReach((PlayerEntity)this.mc.field_71439_g) / 2, TextFormatting.GRAY + "Upgradeable in survival with reach upgrades."));
        this.radialMirrorNumberFieldList.add(this.textRadialMirrorRadius);
        y = this.top + 72;
        this.buttonCurrentPosition = new GuiIconButton(this.left + 5, y, 0, 0, BUILDING_ICONS, button -> {
            Vec3d pos = new Vec3d(Math.floor(this.mc.field_71439_g.field_70165_t) + 0.5, Math.floor(this.mc.field_71439_g.field_70163_u) + 0.5, Math.floor(this.mc.field_71439_g.field_70161_v) + 0.5);
            this.textRadialMirrorPosX.setNumber(pos.field_72450_a);
            this.textRadialMirrorPosY.setNumber(pos.field_72448_b);
            this.textRadialMirrorPosZ.setNumber(pos.field_72449_c);
        });
        this.buttonCurrentPosition.setTooltip("Set radial mirror position to current player position");
        this.radialMirrorIconButtonList.add(this.buttonCurrentPosition);
        this.buttonToggleOdd = new GuiIconButton(this.left + 35, y, 0, 20, BUILDING_ICONS, button -> {
            this.toggleOdd = !this.toggleOdd;
            this.buttonToggleOdd.setUseAlternateIcon(this.toggleOdd);
            if (this.toggleOdd) {
                this.buttonToggleOdd.setTooltip(Arrays.asList("Set mirror position to corner of block", "for even numbered builds"));
                this.textRadialMirrorPosX.setNumber(this.textRadialMirrorPosX.getNumber() + 0.5);
                this.textRadialMirrorPosY.setNumber(this.textRadialMirrorPosY.getNumber() + 0.5);
                this.textRadialMirrorPosZ.setNumber(this.textRadialMirrorPosZ.getNumber() + 0.5);
            } else {
                this.buttonToggleOdd.setTooltip(Arrays.asList("Set mirror position to middle of block", "for odd numbered builds"));
                this.textRadialMirrorPosX.setNumber(Math.floor(this.textRadialMirrorPosX.getNumber()));
                this.textRadialMirrorPosY.setNumber(Math.floor(this.textRadialMirrorPosY.getNumber()));
                this.textRadialMirrorPosZ.setNumber(Math.floor(this.textRadialMirrorPosZ.getNumber()));
            }
        });
        this.buttonToggleOdd.setTooltip(Arrays.asList("Set radial mirror position to middle of block", "for odd numbered builds"));
        this.radialMirrorIconButtonList.add(this.buttonToggleOdd);
        this.buttonDrawLines = new GuiIconButton(this.left + 65, y, 0, 40, BUILDING_ICONS, button -> {
            this.drawLines = !this.drawLines;
            this.buttonDrawLines.setUseAlternateIcon(this.drawLines);
            this.buttonDrawLines.setTooltip(this.drawLines ? "Hide lines" : "Show lines");
        });
        this.buttonDrawLines.setTooltip("Show lines");
        this.radialMirrorIconButtonList.add(this.buttonDrawLines);
        this.buttonDrawPlanes = new GuiIconButton(this.left + 95, y, 0, 60, BUILDING_ICONS, button -> {
            this.drawPlanes = !this.drawPlanes;
            this.buttonDrawPlanes.setUseAlternateIcon(this.drawPlanes);
            this.buttonDrawPlanes.setTooltip(this.drawPlanes ? "Hide area" : "Show area");
        });
        this.buttonDrawPlanes.setTooltip("Show area");
        this.radialMirrorIconButtonList.add(this.buttonDrawPlanes);
        y = this.top + 76;
        this.buttonRadialMirrorAlternate = new GuiCheckBoxFixed(this.left + 140, y, " Alternate", false);
        this.radialMirrorButtonList.add(this.buttonRadialMirrorAlternate);
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((PlayerEntity)this.mc.field_71439_g);
        if (modifierSettings != null) {
            RadialMirror.RadialMirrorSettings r = modifierSettings.getRadialMirrorSettings();
            this.buttonRadialMirrorEnabled.setIsChecked(r.enabled);
            this.textRadialMirrorPosX.setNumber(r.position.field_72450_a);
            this.textRadialMirrorPosY.setNumber(r.position.field_72448_b);
            this.textRadialMirrorPosZ.setNumber(r.position.field_72449_c);
            this.textRadialMirrorSlices.setNumber(r.slices);
            this.buttonRadialMirrorAlternate.setIsChecked(r.alternate);
            this.textRadialMirrorRadius.setNumber(r.radius);
            this.drawLines = r.drawLines;
            this.drawPlanes = r.drawPlanes;
            this.buttonDrawLines.setUseAlternateIcon(this.drawLines);
            this.buttonDrawPlanes.setUseAlternateIcon(this.drawPlanes);
            this.buttonDrawLines.setTooltip(this.drawLines ? "Hide lines" : "Show lines");
            this.buttonDrawPlanes.setTooltip(this.drawPlanes ? "Hide area" : "Show area");
            if (this.textRadialMirrorPosX.getNumber() == Math.floor(this.textRadialMirrorPosX.getNumber())) {
                this.toggleOdd = false;
                this.buttonToggleOdd.setTooltip(Arrays.asList("Set radial mirror position to middle of block", "for odd numbered builds"));
            } else {
                this.toggleOdd = true;
                this.buttonToggleOdd.setTooltip(Arrays.asList("Set radial mirror position to corner of block", "for even numbered builds"));
            }
            this.buttonToggleOdd.setUseAlternateIcon(this.toggleOdd);
        }
        buttonList.addAll(this.radialMirrorButtonList);
        buttonList.addAll(this.radialMirrorIconButtonList);
        this.setCollapsed(!this.buttonRadialMirrorEnabled.isChecked());
    }

    @Override
    public void updateScreen() {
        this.radialMirrorNumberFieldList.forEach(GuiNumberField::update);
    }

    @Override
    public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        int yy = y;
        int offset = 8;
        this.buttonRadialMirrorEnabled.render(mouseX, mouseY, partialTicks);
        if (this.buttonRadialMirrorEnabled.isChecked()) {
            this.buttonRadialMirrorEnabled.y = yy;
            this.font.func_211126_b("Radial mirror enabled", (float)(this.left + offset), (float)(yy + 2), 0xFFFFFF);
            yy = y + 18;
            this.font.func_211126_b("Position", (float)(this.left + offset), (float)(yy + 5), 0xFFFFFF);
            this.font.func_211126_b("X", (float)(this.left + 40 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textRadialMirrorPosX.y = yy;
            this.font.func_211126_b("Y", (float)(this.left + 120 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textRadialMirrorPosY.y = yy;
            this.font.func_211126_b("Z", (float)(this.left + 200 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textRadialMirrorPosZ.y = yy;
            yy = y + 50;
            this.font.func_211126_b("Slices", (float)(this.left + offset), (float)(yy + 2), 0xFFFFFF);
            this.textRadialMirrorSlices.y = yy - 3;
            this.font.func_211126_b("Radius", (float)(this.left + 176 + offset), (float)(yy + 2), 0xFFFFFF);
            this.textRadialMirrorRadius.y = yy - 3;
            this.buttonCurrentPosition.y = yy = y + 72;
            this.buttonToggleOdd.y = yy;
            this.buttonDrawLines.y = yy;
            this.buttonDrawPlanes.y = yy;
            this.buttonRadialMirrorAlternate.y = yy = y + 76;
            this.radialMirrorButtonList.forEach(button -> button.render(mouseX, mouseY, partialTicks));
            this.radialMirrorIconButtonList.forEach(button -> button.render(mouseX, mouseY, partialTicks));
            this.radialMirrorNumberFieldList.forEach(numberField -> numberField.drawNumberField(mouseX, mouseY, partialTicks));
        } else {
            this.buttonRadialMirrorEnabled.y = yy;
            this.font.func_211126_b("Radial mirror disabled", (float)(this.left + offset), (float)(yy + 2), 0x999999);
        }
    }

    @Override
    public void drawTooltip(Screen guiScreen, int mouseX, int mouseY) {
        if (this.buttonRadialMirrorEnabled.isChecked()) {
            this.radialMirrorIconButtonList.forEach(iconButton -> iconButton.drawTooltip(this.scrollPane.parent, mouseX, mouseY));
            this.radialMirrorNumberFieldList.forEach(numberField -> numberField.drawTooltip(this.scrollPane.parent, mouseX, mouseY));
        }
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        super.charTyped(typedChar, keyCode);
        for (GuiNumberField numberField : this.radialMirrorNumberFieldList) {
            numberField.charTyped(typedChar, keyCode);
        }
        return true;
    }

    @Override
    public boolean mousePressed(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        boolean insideRadialMirrorEnabledLabel;
        this.radialMirrorNumberFieldList.forEach(numberField -> numberField.mouseClicked(mouseX, mouseY, mouseEvent));
        boolean bl = insideRadialMirrorEnabledLabel = mouseX >= this.left && mouseX < this.right && relativeY >= -2 && relativeY < 12;
        if (insideRadialMirrorEnabledLabel) {
            this.buttonRadialMirrorEnabled.playDownSound(this.mc.func_147118_V());
            this.buttonRadialMirrorEnabled.onClick(mouseX, mouseY);
        }
        return true;
    }

    public RadialMirror.RadialMirrorSettings getRadialMirrorSettings() {
        boolean radialMirrorEnabled = this.buttonRadialMirrorEnabled.isChecked();
        Vec3d radialMirrorPos = new Vec3d(0.0, 64.0, 0.0);
        try {
            radialMirrorPos = new Vec3d(this.textRadialMirrorPosX.getNumber(), this.textRadialMirrorPosY.getNumber(), this.textRadialMirrorPosZ.getNumber());
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((PlayerEntity)this.mc.field_71439_g, "Radial mirror position not a valid number.");
        }
        int radialMirrorSlices = 4;
        try {
            radialMirrorSlices = (int)this.textRadialMirrorSlices.getNumber();
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((PlayerEntity)this.mc.field_71439_g, "Radial mirror slices not a valid number.");
        }
        boolean radialMirrorAlternate = this.buttonRadialMirrorAlternate.isChecked();
        int radialMirrorRadius = 50;
        try {
            radialMirrorRadius = (int)this.textRadialMirrorRadius.getNumber();
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((PlayerEntity)this.mc.field_71439_g, "Mirror radius not a valid number.");
        }
        return new RadialMirror.RadialMirrorSettings(radialMirrorEnabled, radialMirrorPos, radialMirrorSlices, radialMirrorAlternate, radialMirrorRadius, this.drawLines, this.drawPlanes);
    }

    @Override
    protected String getName() {
        return "Radial mirror";
    }

    @Override
    protected int getExpandedHeight() {
        return 100;
    }
}

