/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiIconButton
extends Button {
    private final ResourceLocation resourceLocation;
    private final int iconX;
    private final int iconY;
    private final int iconWidth;
    private final int iconHeight;
    private final int iconAltX;
    private final int iconAltY;
    List<String> tooltip = new ArrayList<String>();
    private boolean useAltIcon = false;

    public GuiIconButton(int x, int y, int iconX, int iconY, ResourceLocation resourceLocation, Button.IPressable onPress) {
        this(x, y, 20, 20, iconX, iconY, 20, 20, 20, 0, resourceLocation, onPress);
    }

    public GuiIconButton(int x, int y, int width, int height, int iconX, int iconY, int iconWidth, int iconHeight, int iconAltX, int iconAltY, ResourceLocation resourceLocation, Button.IPressable onPress) {
        super(x, y, width, height, "", onPress);
        this.iconX = iconX;
        this.iconY = iconY;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.iconAltX = iconAltX;
        this.iconAltY = iconAltY;
        this.resourceLocation = resourceLocation;
    }

    public void setTooltip(String tooltip) {
        this.setTooltip(Arrays.asList(tooltip));
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    public void setUseAlternateIcon(boolean useAlternateIcon) {
        this.useAltIcon = useAlternateIcon;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.visible) {
            this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.resourceLocation);
            int currentIconX = this.iconX;
            int currentIconY = this.iconY;
            if (this.useAltIcon) {
                currentIconX += this.iconAltX;
                currentIconY += this.iconAltY;
            }
            this.blit(this.x, this.y, currentIconX, currentIconY, this.iconWidth, this.iconHeight);
        }
    }

    public void drawTooltip(Screen screen, int mouseX, int mouseY) {
        boolean flag;
        boolean bl = flag = mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        if (flag) {
            ArrayList<String> textLines = new ArrayList<String>();
            textLines.addAll(this.tooltip);
            screen.renderTooltip(textLines, mouseX - 10, mouseY + 25);
        }
    }
}

