/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.elements;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiNumberField
extends AbstractGui {
    public int x;
    public int y;
    public int width;
    public int height;
    public int buttonWidth = 10;
    protected TextFieldWidget textField;
    protected Button minusButton;
    protected Button plusButton;
    List<String> tooltip = new ArrayList<String>();

    public GuiNumberField(FontRenderer font, List<Widget> buttonList, int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textField = new TextFieldWidget(font, x + this.buttonWidth + 1, y + 1, width - 2 * this.buttonWidth - 2, height - 2, "");
        this.minusButton = new Button(x, y - 1, this.buttonWidth, height + 2, "-", button -> {
            float valueChanged = 1.0f;
            if (Screen.hasControlDown()) {
                valueChanged = 5.0f;
            }
            if (Screen.hasShiftDown()) {
                valueChanged = 10.0f;
            }
            this.setNumber(this.getNumber() - (double)valueChanged);
        });
        this.plusButton = new Button(x + width - this.buttonWidth, y - 1, this.buttonWidth, height + 2, "+", button -> {
            float valueChanged = 1.0f;
            if (Screen.hasControlDown()) {
                valueChanged = 5.0f;
            }
            if (Screen.hasShiftDown()) {
                valueChanged = 10.0f;
            }
            this.setNumber(this.getNumber() + (double)valueChanged);
        });
        buttonList.add((Widget)this.minusButton);
        buttonList.add((Widget)this.plusButton);
    }

    public void setNumber(double number) {
        this.textField.func_146180_a(DecimalFormat.getInstance().format(number));
    }

    public double getNumber() {
        if (this.textField.func_146179_b().isEmpty()) {
            return 0.0;
        }
        try {
            return DecimalFormat.getInstance().parse(this.textField.func_146179_b()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public void setTooltip(String tooltip) {
        this.setTooltip(Arrays.asList(tooltip));
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean flag;
        boolean result = this.textField.mouseClicked(mouseX, mouseY, mouseButton);
        boolean bl = flag = mouseX >= (double)(this.x + this.buttonWidth) && mouseX < (double)(this.x + this.width - this.buttonWidth) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        if (flag && mouseButton == 1) {
            this.textField.func_146180_a("");
            this.textField.func_146195_b(true);
            result = true;
        }
        return result;
    }

    public void drawNumberField(int mouseX, int mouseY, float partialTicks) {
        this.textField.y = this.y + 1;
        this.minusButton.y = this.y - 1;
        this.plusButton.y = this.y - 1;
        this.textField.render(mouseX, mouseY, partialTicks);
        this.minusButton.render(mouseX, mouseY, partialTicks);
        this.plusButton.render(mouseX, mouseY, partialTicks);
    }

    public void drawTooltip(Screen screen, int mouseX, int mouseY) {
        boolean insideTextField = mouseX >= this.x + this.buttonWidth && mouseX < this.x + this.width - this.buttonWidth && mouseY >= this.y && mouseY < this.y + this.height;
        boolean insideMinusButton = mouseX >= this.x && mouseX < this.x + this.buttonWidth && mouseY >= this.y && mouseY < this.y + this.height;
        boolean insidePlusButton = mouseX >= this.x + this.width - this.buttonWidth && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        ArrayList<String> textLines = new ArrayList<String>();
        if (insideTextField && !this.tooltip.isEmpty()) {
            textLines.addAll(this.tooltip);
        }
        if (insideMinusButton) {
            textLines.add("Hold " + TextFormatting.AQUA + "shift " + TextFormatting.RESET + "for " + TextFormatting.RED + "10");
            textLines.add("Hold " + TextFormatting.AQUA + "ctrl " + TextFormatting.RESET + "for " + TextFormatting.RED + "5");
        }
        if (insidePlusButton) {
            textLines.add("Hold " + TextFormatting.AQUA + "shift " + TextFormatting.RESET + "for " + TextFormatting.DARK_GREEN + "10");
            textLines.add("Hold " + TextFormatting.AQUA + "ctrl " + TextFormatting.RESET + "for " + TextFormatting.DARK_GREEN + "5");
        }
        screen.renderTooltip(textLines, mouseX - 10, mouseY + 25);
    }

    public void update() {
        this.textField.func_146178_a();
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.textField.isFocused()) {
            return false;
        }
        return this.textField.charTyped(typedChar, keyCode);
    }
}

