/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.proxy;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.gui.RandomizerBagScreen;
import nl.requios.effortlessbuilding.gui.buildmode.RadialMenu;
import nl.requios.effortlessbuilding.gui.buildmodifier.ModifierSettingsGui;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.network.BlockBrokenMessage;
import nl.requios.effortlessbuilding.network.BlockPlacedMessage;
import nl.requios.effortlessbuilding.network.ModeActionMessage;
import nl.requios.effortlessbuilding.network.ModifierSettingsMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.proxy.IProxy;
import nl.requios.effortlessbuilding.render.ShaderHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientProxy
implements IProxy {
    public static KeyBinding[] keyBindings;
    public static RayTraceResult previousLookAt;
    public static RayTraceResult currentLookAt;
    private static int placeCooldown;
    private static int breakCooldown;
    private static boolean shadersInitialized;
    public static int ticksInGame;

    @Override
    public void setup(FMLCommonSetupEvent event) {
    }

    @Override
    public void clientSetup(FMLClientSetupEvent event) {
        keyBindings = new KeyBinding[7];
        ClientProxy.keyBindings[0] = new KeyBinding("key.effortlessbuilding.hud.desc", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputMappings.func_197954_a((int)334, (int)0), "key.effortlessbuilding.category");
        ClientProxy.keyBindings[1] = new KeyBinding("key.effortlessbuilding.replace.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.func_197954_a((int)333, (int)0), "key.effortlessbuilding.category");
        ClientProxy.keyBindings[2] = new KeyBinding("key.effortlessbuilding.creative.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.func_197954_a((int)293, (int)0), "key.effortlessbuilding.category");
        ClientProxy.keyBindings[3] = new KeyBinding("key.effortlessbuilding.mode.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.func_197954_a((int)342, (int)0), "key.effortlessbuilding.category"){

            public boolean func_197983_b(KeyBinding other) {
                if (other.getKey().func_197937_c() == this.getKey().func_197937_c() && other.func_151464_g().equals("mod.chiselsandbits.other.mode")) {
                    return false;
                }
                return super.func_197983_b(other);
            }
        };
        ClientProxy.keyBindings[4] = new KeyBinding("key.effortlessbuilding.undo.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputMappings.func_197954_a((int)90, (int)0), "key.effortlessbuilding.category");
        ClientProxy.keyBindings[5] = new KeyBinding("key.effortlessbuilding.redo.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, InputMappings.func_197954_a((int)89, (int)0), "key.effortlessbuilding.category");
        ClientProxy.keyBindings[6] = new KeyBinding("key.effortlessbuilding.altplacement.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.func_197954_a((int)341, (int)0), "key.effortlessbuilding.category");
        for (int i = 0; i < keyBindings.length; ++i) {
            ClientRegistry.registerKeyBinding((KeyBinding)keyBindings[i]);
        }
        DeferredWorkQueue.runLater(() -> ScreenManager.func_216911_a(EffortlessBuilding.RANDOMIZER_BAG_CONTAINER, RandomizerBagScreen::new));
    }

    @Override
    public PlayerEntity getPlayerEntityFromContext(Supplier<NetworkEvent.Context> ctx) {
        return ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT ? Minecraft.func_71410_x().field_71439_g : ctx.get().getSender();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientProxy.onMouseInput();
            RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
            if (objectMouseOver == null) {
                return;
            }
            if (currentLookAt == null) {
                currentLookAt = objectMouseOver;
                previousLookAt = objectMouseOver;
                return;
            }
            if (objectMouseOver.func_216346_c() == RayTraceResult.Type.BLOCK) {
                if (currentLookAt.func_216346_c() != RayTraceResult.Type.BLOCK) {
                    currentLookAt = objectMouseOver;
                    previousLookAt = objectMouseOver;
                } else if (((BlockRayTraceResult)currentLookAt).func_216350_a() != ((BlockRayTraceResult)objectMouseOver).func_216350_a()) {
                    previousLookAt = currentLookAt;
                    currentLookAt = objectMouseOver;
                }
            }
        } else if (event.phase == TickEvent.Phase.END) {
            Screen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !gui.isPauseScreen()) {
                ++ticksInGame;
            }
            if (!shadersInitialized) {
                ShaderHandler.init();
                shadersInitialized = true;
            }
        }
    }

    private static void onMouseInput() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        BuildModes.BuildModeEnum buildMode = ModeSettingsManager.getModeSettings((PlayerEntity)player).getBuildMode();
        if (Minecraft.func_71410_x().field_71462_r != null || buildMode == BuildModes.BuildModeEnum.NORMAL || RadialMenu.instance.isVisible()) {
            return;
        }
        if (mc.field_71474_y.field_74313_G.func_151470_d()) {
            if (placeCooldown <= 0) {
                placeCooldown = 4;
                ItemStack currentItemStack = player.func_184586_b(Hand.MAIN_HAND);
                if (currentItemStack.func_77973_b() instanceof BlockItem || CompatHelper.isItemBlockProxy(currentItemStack) && !player.func_70093_af()) {
                    ItemStack itemStack = CompatHelper.getItemBlockFromStack(currentItemStack);
                    RayTraceResult lookingAt = ClientProxy.getLookingAt((PlayerEntity)player);
                    if (lookingAt != null && lookingAt.func_216346_c() == RayTraceResult.Type.BLOCK) {
                        BlockRayTraceResult blockLookingAt = (BlockRayTraceResult)lookingAt;
                        BuildModes.onBlockPlacedMessage((PlayerEntity)player, new BlockPlacedMessage(blockLookingAt, true));
                        PacketHandler.INSTANCE.sendToServer((Object)new BlockPlacedMessage(blockLookingAt, true));
                        if (blockLookingAt.func_216347_e().func_178788_d(player.func_174824_e(1.0f)).func_189985_c() > 25.0 && itemStack.func_77973_b() instanceof BlockItem) {
                            BlockState state = ((BlockItem)itemStack.func_77973_b()).func_179223_d().func_176223_P();
                            BlockPos blockPos = blockLookingAt.func_216350_a();
                            SoundType soundType = state.func_177230_c().getSoundType(state, (IWorldReader)player.field_70170_p, blockPos, (Entity)player);
                            player.field_70170_p.func_184133_a((PlayerEntity)player, player.func_180425_c(), soundType.func_185841_e(), SoundCategory.BLOCKS, 0.4f, soundType.func_185847_b() * 1.0f);
                            player.func_184609_a(Hand.MAIN_HAND);
                        }
                    } else {
                        BuildModes.onBlockPlacedMessage((PlayerEntity)player, new BlockPlacedMessage());
                        PacketHandler.INSTANCE.sendToServer((Object)new BlockPlacedMessage());
                    }
                }
            } else if (buildMode == BuildModes.BuildModeEnum.NORMAL_PLUS) {
                --placeCooldown;
                if (ModeOptions.getBuildSpeed() == ModeOptions.ActionEnum.FAST_SPEED) {
                    placeCooldown = 0;
                }
            }
        } else {
            placeCooldown = 0;
        }
        if (mc.field_71474_y.field_74312_F.func_151470_d()) {
            if (breakCooldown <= 0) {
                breakCooldown = 4;
                if (!ReachHelper.canBreakFar((PlayerEntity)player)) {
                    return;
                }
                RayTraceResult lookingAt = ClientProxy.getLookingAt((PlayerEntity)player);
                if (lookingAt != null && lookingAt.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockRayTraceResult blockLookingAt = (BlockRayTraceResult)lookingAt;
                    BuildModes.onBlockBrokenMessage((PlayerEntity)player, new BlockBrokenMessage(blockLookingAt));
                    PacketHandler.INSTANCE.sendToServer((Object)new BlockBrokenMessage(blockLookingAt));
                    if (blockLookingAt.func_216347_e().func_178788_d(player.func_174824_e(1.0f)).func_189985_c() > 25.0) {
                        BlockPos blockPos = blockLookingAt.func_216350_a();
                        BlockState state = player.field_70170_p.func_180495_p(blockPos);
                        SoundType soundtype = state.func_177230_c().getSoundType(state, (IWorldReader)player.field_70170_p, blockPos, (Entity)player);
                        player.field_70170_p.func_184133_a((PlayerEntity)player, player.func_180425_c(), soundtype.func_185845_c(), SoundCategory.BLOCKS, 0.4f, soundtype.func_185847_b() * 1.0f);
                        player.func_184609_a(Hand.MAIN_HAND);
                    }
                } else {
                    BuildModes.onBlockBrokenMessage((PlayerEntity)player, new BlockBrokenMessage());
                    PacketHandler.INSTANCE.sendToServer((Object)new BlockBrokenMessage());
                }
            } else if (buildMode == BuildModes.BuildModeEnum.NORMAL_PLUS) {
                --breakCooldown;
                if (ModeOptions.getBuildSpeed() == ModeOptions.ActionEnum.FAST_SPEED) {
                    breakCooldown = 0;
                }
            }
        } else {
            breakCooldown = 0;
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void onKeyPress(InputEvent.KeyInputEvent event) {
        ModeOptions.ActionEnum action;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (keyBindings[0].func_151468_f()) {
            ClientProxy.openModifierSettings();
        }
        if (keyBindings[1].func_151468_f()) {
            ModifierSettingsManager.ModifierSettings modifierSettings;
            modifierSettings.setQuickReplace(!(modifierSettings = ModifierSettingsManager.getModifierSettings((PlayerEntity)player)).doQuickReplace());
            EffortlessBuilding.log((PlayerEntity)player, "Set " + TextFormatting.GOLD + "Quick Replace " + TextFormatting.RESET + (modifierSettings.doQuickReplace() ? "on" : "off"));
            PacketHandler.INSTANCE.sendToServer((Object)new ModifierSettingsMessage(modifierSettings));
        }
        if (keyBindings[2].func_151468_f()) {
            if (player.func_184812_l_()) {
                player.func_71165_d("/gamemode survival");
            } else {
                player.func_71165_d("/gamemode creative");
            }
        }
        if (keyBindings[4].func_151468_f()) {
            action = ModeOptions.ActionEnum.UNDO;
            ModeOptions.performAction((PlayerEntity)player, action);
            PacketHandler.INSTANCE.sendToServer((Object)new ModeActionMessage(action));
        }
        if (keyBindings[5].func_151468_f()) {
            action = ModeOptions.ActionEnum.REDO;
            ModeOptions.performAction((PlayerEntity)player, action);
            PacketHandler.INSTANCE.sendToServer((Object)new ModeActionMessage(action));
        }
        if (keyBindings[6].func_151468_f()) {
            BuildModes.BuildModeEnum currentBuildMode = ModeSettingsManager.getModeSettings((PlayerEntity)player).getBuildMode();
            if (currentBuildMode.options.length > 0) {
                ModeOptions.OptionEnum option = currentBuildMode.options[0];
                if (option.actions.length >= 2) {
                    if (ModeOptions.getOptionSetting(option) == option.actions[0]) {
                        ModeOptions.performAction((PlayerEntity)player, option.actions[1]);
                        PacketHandler.INSTANCE.sendToServer((Object)new ModeActionMessage(option.actions[1]));
                    } else {
                        ModeOptions.performAction((PlayerEntity)player, option.actions[0]);
                        PacketHandler.INSTANCE.sendToServer((Object)new ModeActionMessage(option.actions[0]));
                    }
                }
            }
        }
        if (keyBindings.length >= 8 && keyBindings[7].func_151468_f()) {
            ShaderHandler.init();
            EffortlessBuilding.log((PlayerEntity)player, "Reloaded shaders");
        }
    }

    public static void openModifierSettings() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        RadialMenu.instance.setVisibility(0.0f);
        if (ReachHelper.getMaxReach((PlayerEntity)player) == 0) {
            EffortlessBuilding.log((PlayerEntity)player, "Build modifiers are disabled until your reach has increased. Increase your reach with craftable reach upgrades.");
        } else if (mc.field_71462_r == null) {
            mc.func_147108_a((Screen)new ModifierSettingsGui());
        } else {
            player.func_71053_j();
        }
    }

    @SubscribeEvent
    public static void onGuiOpen(GuiOpenEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            BuildModes.initializeMode((PlayerEntity)player);
        }
    }

    @Nullable
    public static RayTraceResult getLookingAt(PlayerEntity player) {
        World world = player.field_70170_p;
        float raytraceRange = ReachHelper.getPlacementReach(player);
        Vec3d look = player.func_70040_Z();
        Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d end = new Vec3d(player.field_70165_t + look.field_72450_a * (double)raytraceRange, player.field_70163_u + (double)player.func_70047_e() + look.field_72448_b * (double)raytraceRange, player.field_70161_v + look.field_72449_c * (double)raytraceRange);
        return world.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
    }

    @Override
    public void logTranslate(PlayerEntity player, String prefix, String translationKey, String suffix, boolean actionBar) {
        EffortlessBuilding.log((PlayerEntity)Minecraft.func_71410_x().field_71439_g, prefix + I18n.func_135052_a((String)translationKey, (Object[])new Object[0]) + suffix, actionBar);
    }

    static {
        placeCooldown = 0;
        breakCooldown = 0;
        shadersInitialized = false;
        ticksInGame = 0;
    }
}

