/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import java.awt.Color;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.render.RenderHandler;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class ModifierRenderer {
    protected static final Color colorX = new Color(255, 72, 52);
    protected static final Color colorY = new Color(67, 204, 51);
    protected static final Color colorZ = new Color(52, 247, 255);
    protected static final Color colorRadial = new Color(52, 247, 255);
    protected static final int lineAlpha = 200;
    protected static final int planeAlpha = 75;
    protected static final Vec3d epsilon = new Vec3d(0.001, 0.001, 0.001);

    public static void render(ModifierSettingsManager.ModifierSettings modifierSettings) {
        RadialMirror.RadialMirrorSettings r;
        RenderHandler.beginLines();
        Mirror.MirrorSettings m = modifierSettings.getMirrorSettings();
        if (m != null && m.enabled && (m.mirrorX || m.mirrorY || m.mirrorZ)) {
            Vec3d posB;
            Vec3d posA;
            Vec3d pos = m.position.func_178787_e(epsilon);
            int radius = m.radius;
            if (m.mirrorX) {
                posA = new Vec3d(pos.field_72450_a, pos.field_72448_b - (double)radius, pos.field_72449_c - (double)radius);
                posB = new Vec3d(pos.field_72450_a, pos.field_72448_b + (double)radius, pos.field_72449_c + (double)radius);
                ModifierRenderer.drawMirrorPlane(posA, posB, colorX, m.drawLines, m.drawPlanes, true);
            }
            if (m.mirrorY) {
                posA = new Vec3d(pos.field_72450_a - (double)radius, pos.field_72448_b, pos.field_72449_c - (double)radius);
                posB = new Vec3d(pos.field_72450_a + (double)radius, pos.field_72448_b, pos.field_72449_c + (double)radius);
                ModifierRenderer.drawMirrorPlaneY(posA, posB, colorY, m.drawLines, m.drawPlanes);
            }
            if (m.mirrorZ) {
                posA = new Vec3d(pos.field_72450_a - (double)radius, pos.field_72448_b - (double)radius, pos.field_72449_c);
                posB = new Vec3d(pos.field_72450_a + (double)radius, pos.field_72448_b + (double)radius, pos.field_72449_c);
                ModifierRenderer.drawMirrorPlane(posA, posB, colorZ, m.drawLines, m.drawPlanes, true);
            }
            if (m.drawLines && (m.mirrorX && m.mirrorY || m.mirrorX && m.mirrorZ || m.mirrorY && m.mirrorZ)) {
                ModifierRenderer.drawMirrorLines(m);
            }
        }
        if ((r = modifierSettings.getRadialMirrorSettings()) != null && r.enabled) {
            Vec3d pos = r.position.func_178787_e(epsilon);
            int radius = r.radius;
            float angle = (float)Math.PI * 2 / (float)r.slices;
            Vec3d relStartVec = new Vec3d((double)radius, 0.0, 0.0);
            if (r.slices % 4 == 2) {
                relStartVec = relStartVec.func_178785_b(angle / 2.0f);
            }
            for (int i = 0; i < r.slices; ++i) {
                Vec3d relNewVec = relStartVec.func_178785_b(angle * (float)i);
                Vec3d newVec = pos.func_178787_e(relNewVec);
                Vec3d posA = new Vec3d(pos.field_72450_a, pos.field_72448_b - (double)radius, pos.field_72449_c);
                Vec3d posB = new Vec3d(newVec.field_72450_a, pos.field_72448_b + (double)radius, newVec.field_72449_c);
                ModifierRenderer.drawMirrorPlane(posA, posB, colorRadial, r.drawLines, r.drawPlanes, false);
            }
        }
        RenderHandler.endLines();
    }

    protected static void drawMirrorPlane(Vec3d posA, Vec3d posB, Color c, boolean drawLines, boolean drawPlanes, boolean drawVerticalLines) {
        GL11.glColor4d((double)c.getRed(), (double)c.getGreen(), (double)c.getBlue(), (double)75.0);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        if (drawPlanes) {
            bufferBuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posA.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            bufferBuilder.func_181662_b(posA.field_72450_a, posB.field_72448_b, posA.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b, posB.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            bufferBuilder.func_181662_b(posB.field_72450_a, posB.field_72448_b, posB.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            tessellator.func_78381_a();
        }
        if (drawLines) {
            Vec3d middle = posA.func_178787_e(posB).func_186678_a(0.5);
            bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            bufferBuilder.func_181662_b(posA.field_72450_a, middle.field_72448_b, posA.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            bufferBuilder.func_181662_b(posB.field_72450_a, middle.field_72448_b, posB.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            if (drawVerticalLines) {
                bufferBuilder.func_181662_b(middle.field_72450_a, posA.field_72448_b, middle.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
                bufferBuilder.func_181662_b(middle.field_72450_a, posB.field_72448_b, middle.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            }
            tessellator.func_78381_a();
        }
    }

    protected static void drawMirrorPlaneY(Vec3d posA, Vec3d posB, Color c, boolean drawLines, boolean drawPlanes) {
        GL11.glColor4d((double)c.getRed(), (double)c.getGreen(), (double)c.getBlue(), (double)c.getAlpha());
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        if (drawPlanes) {
            bufferBuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posA.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posB.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b, posA.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b, posB.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 75).func_181675_d();
            tessellator.func_78381_a();
        }
        if (drawLines) {
            Vec3d middle = posA.func_178787_e(posB).func_186678_a(0.5);
            bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            bufferBuilder.func_181662_b(middle.field_72450_a, middle.field_72448_b, posA.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            bufferBuilder.func_181662_b(middle.field_72450_a, middle.field_72448_b, posB.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            bufferBuilder.func_181662_b(posA.field_72450_a, middle.field_72448_b, middle.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            bufferBuilder.func_181662_b(posB.field_72450_a, middle.field_72448_b, middle.field_72449_c).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), 200).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    protected static void drawMirrorLines(Mirror.MirrorSettings m) {
        Vec3d pos = m.position.func_178787_e(epsilon);
        GL11.glColor4d((double)100.0, (double)100.0, (double)100.0, (double)255.0);
        GL11.glLineWidth((float)2.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b(pos.field_72450_a - (double)m.radius, pos.field_72448_b, pos.field_72449_c).func_181669_b(colorX.getRed(), colorX.getGreen(), colorX.getBlue(), 200).func_181675_d();
        bufferBuilder.func_181662_b(pos.field_72450_a + (double)m.radius, pos.field_72448_b, pos.field_72449_c).func_181669_b(colorX.getRed(), colorX.getGreen(), colorX.getBlue(), 200).func_181675_d();
        bufferBuilder.func_181662_b(pos.field_72450_a, pos.field_72448_b - (double)m.radius, pos.field_72449_c).func_181669_b(colorY.getRed(), colorY.getGreen(), colorY.getBlue(), 200).func_181675_d();
        bufferBuilder.func_181662_b(pos.field_72450_a, pos.field_72448_b + (double)m.radius, pos.field_72449_c).func_181669_b(colorY.getRed(), colorY.getGreen(), colorY.getBlue(), 200).func_181675_d();
        bufferBuilder.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c - (double)m.radius).func_181669_b(colorZ.getRed(), colorZ.getGreen(), colorZ.getBlue(), 200).func_181675_d();
        bufferBuilder.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c + (double)m.radius).func_181669_b(colorZ.getRed(), colorZ.getGreen(), colorZ.getBlue(), 200).func_181675_d();
        tessellator.func_78381_a();
    }
}

