/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.gui.buildmode.RadialMenu;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.network.ModeActionMessage;
import nl.requios.effortlessbuilding.network.ModeSettingsMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.proxy.ClientProxy;
import nl.requios.effortlessbuilding.render.BlockPreviewRenderer;
import nl.requios.effortlessbuilding.render.ModifierRenderer;
import nl.requios.effortlessbuilding.render.ShaderHandler;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderHandler {
    @SubscribeEvent
    public static void onRender(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings((PlayerEntity)player);
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((PlayerEntity)player);
        RenderHandler.begin(event.getPartialTicks());
        ModifierRenderer.render(modifierSettings);
        BlockPreviewRenderer.render((PlayerEntity)player, modifierSettings, modeSettings);
        RenderHandler.end();
    }

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (type == RenderGameOverlayEvent.ElementType.ALL) {
            boolean wasVisible = RadialMenu.instance.isVisible();
            if (ClientProxy.keyBindings[3].func_151470_d()) {
                if (ReachHelper.getMaxReach((PlayerEntity)player) > 0) {
                    RadialMenu.instance.actionUsed = false;
                    RadialMenu.instance.raiseVisibility();
                } else if (ClientProxy.keyBindings[3].func_151468_f()) {
                    EffortlessBuilding.log((PlayerEntity)player, "Build modes are disabled until your reach has increased. Increase your reach with craftable reach upgrades.");
                }
            } else {
                if (!RadialMenu.instance.actionUsed) {
                    ModeOptions.ActionEnum action;
                    ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings((PlayerEntity)player);
                    if (RadialMenu.instance.switchTo != null) {
                        RenderHandler.playRadialMenuSound();
                        modeSettings.setBuildMode(RadialMenu.instance.switchTo);
                        ModeSettingsManager.setModeSettings((PlayerEntity)player, modeSettings);
                        PacketHandler.INSTANCE.sendToServer((Object)new ModeSettingsMessage(modeSettings));
                        EffortlessBuilding.log((PlayerEntity)player, I18n.func_135052_a((String)modeSettings.getBuildMode().name, (Object[])new Object[0]), true);
                    }
                    if ((action = RadialMenu.instance.doAction) != null) {
                        ModeOptions.performAction((PlayerEntity)player, action);
                        PacketHandler.INSTANCE.sendToServer((Object)new ModeActionMessage(action));
                    }
                    RenderHandler.playRadialMenuSound();
                }
                RadialMenu.instance.actionUsed = true;
                RadialMenu.instance.decreaseVisibility();
            }
            if (RadialMenu.instance.isVisible()) {
                int scaledWidth = mc.field_195558_d.func_198107_o();
                int scaledHeight = mc.field_195558_d.func_198087_p();
                RadialMenu.instance.configure(scaledWidth, scaledHeight);
                if (!wasVisible) {
                    mc.field_71417_B.func_198032_j();
                }
                if (mc.field_71417_B.func_198035_h()) {
                    KeyBinding.func_74506_a();
                }
                int mouseX = (int)mc.field_71417_B.func_198024_e() * scaledWidth / mc.field_195558_d.func_198109_k();
                int mouseY = scaledHeight - (int)mc.field_71417_B.func_198026_f() * scaledHeight / mc.field_195558_d.func_198091_l() - 1;
                ForgeHooksClient.drawScreen((Screen)RadialMenu.instance, (int)mouseX, (int)mouseY, (float)event.getPartialTicks());
            } else if (wasVisible && RadialMenu.instance.doAction != ModeOptions.ActionEnum.OPEN_MODIFIER_SETTINGS) {
                mc.field_71417_B.func_198034_i();
            }
        }
    }

    public static void playRadialMenuSound() {
        float volume = 0.1f;
        SimpleSound sound = new SimpleSound(SoundEvents.field_187909_gi, SoundCategory.MASTER, 0.1f, 1.0f, Minecraft.func_71410_x().field_71439_g.func_180425_c());
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
    }

    private static void begin(float partialTicks) {
        GL11.glPushMatrix();
        GlStateManager.translated((double)(-TileEntityRendererDispatcher.field_147554_b), (double)(-TileEntityRendererDispatcher.field_147555_c), (double)(-TileEntityRendererDispatcher.field_147552_d));
        GL11.glDepthMask((boolean)false);
    }

    protected static void beginLines() {
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glLineWidth((float)2.0f);
    }

    protected static void endLines() {
        GL11.glPopAttrib();
    }

    protected static void beginBlockPreviews() {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ShaderHandler.shaderMaskTextureLocation);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
    }

    protected static void endBlockPreviews() {
        ShaderHandler.releaseShader();
        GlStateManager.disableBlend();
        GL11.glPopAttrib();
    }

    private static void end() {
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    protected static void renderBlockPreview(BlockRendererDispatcher dispatcher, BlockPos blockPos, BlockState blockState) {
        if (blockState == null) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)blockPos.func_177958_n(), (float)blockPos.func_177956_o(), (float)blockPos.func_177952_p());
        GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)-0.01f, (float)-0.01f, (float)0.01f);
        GlStateManager.scalef((float)1.02f, (float)1.02f, (float)1.02f);
        try {
            dispatcher.func_175016_a(blockState, 0.85f);
        }
        catch (NullPointerException e) {
            EffortlessBuilding.logger.warn("RenderHandler::renderBlockPreview cannot render " + blockState.func_177230_c().toString());
            GlStateManager.popMatrix();
            GL11.glDisable((int)2896);
            RenderHandler.renderBlockOutline(blockPos, new Vec3d(1.0, 1.0, 1.0));
            GL11.glEnable((int)2896);
            GlStateManager.pushMatrix();
        }
        GlStateManager.popMatrix();
    }

    protected static void renderBlockOutline(BlockPos pos, Vec3d color) {
        RenderHandler.renderBlockOutline(pos, pos, color);
    }

    protected static void renderBlockOutline(BlockPos pos1, BlockPos pos2, Vec3d color) {
        GL11.glLineWidth((float)2.0f);
        AxisAlignedBB aabb = new AxisAlignedBB(pos1, pos2.func_177982_a(1, 1, 1)).func_186662_g((double)0.002f);
        WorldRenderer.func_189697_a((AxisAlignedBB)aabb, (float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)0.4f);
    }

    protected static void renderBlockOutline(BlockPos pos, VoxelShape collisionShape, Vec3d color) {
        GL11.glLineWidth((float)2.0f);
        WorldRenderer.func_195463_b((VoxelShape)collisionShape, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)0.4f);
    }
}

