/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm.lib;

import javax.annotation.Nonnull;
import net.teamfruit.emojicord.compat.CompatFMLDeobfuscatingRemapper;
import org.apache.commons.lang3.Validate;

public class RefName {
    @Nonnull
    private final String mcpName;
    @Nonnull
    private final String srgName;

    protected RefName(@Nonnull String mcpName, @Nonnull String srgName) {
        this.mcpName = mcpName;
        this.srgName = srgName;
    }

    @Nonnull
    public String name() {
        return CompatFMLDeobfuscatingRemapper.useMcpNames() ? (String)Validate.notEmpty((CharSequence)this.mcpName) : (String)Validate.notEmpty((CharSequence)this.srgName);
    }

    @Nonnull
    public String mcpName() {
        return this.mcpName;
    }

    @Nonnull
    public String srgName() {
        return this.srgName;
    }

    @Nonnull
    public String toString() {
        return String.format("[%s,%s]", this.mcpName, this.srgName);
    }

    @Nonnull
    public static RefName deobName(@Nonnull String mcpName, @Nonnull String srgName) {
        return new RefName(mcpName, srgName);
    }

    @Nonnull
    public static RefName name(@Nonnull String name) {
        return new RefName(name, name);
    }
}

