/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class Compat {
    @Nonnull
    public static Minecraft getMinecraft() {
        return FMLClientHandler.instance().getClient();
    }

    public static class CompatMinecraftVersion {
        public static String getMinecraftVersion() {
            return "1.10.2";
        }

        public static String getForgeVersion() {
            return ForgeVersion.getVersion();
        }
    }

    public static class CompatVersionChecker {
        public static void startVersionCheck(String modId, String modVersion, String updateURL) {
        }

        public static ForgeVersion.CheckResult getResult(String modId) {
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(modId);
            return ForgeVersion.getResult((ModContainer)container);
        }
    }

    public static class CompatBufferBuilder {
    }

    public static class CompatTexture {
        public static void uploadTexture(Supplier<Integer> genTextureId, InputStream image) throws IOException {
            boolean blur = true;
            boolean clamp = false;
            BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)image);
            CompatTexture.uploadTexture(genTextureId, bufferedimage);
        }

        public static void uploadTexture(Supplier<Integer> genTextureId, BufferedImage bufferedimage) throws IOException {
            boolean blur = true;
            boolean clamp = false;
            if (bufferedimage != null) {
                TextureUtil.func_110989_a((int)genTextureId.get(), (BufferedImage)bufferedimage, (boolean)true, (boolean)false);
            }
        }
    }

    public static class CompatI18n {
        public static String format(String format, Object ... args) {
            return net.minecraft.client.resources.I18n.func_135052_a((String)format, (Object[])args);
        }

        public static boolean hasKey(String key) {
            return net.minecraft.client.resources.I18n.func_188566_a((String)key);
        }

        public static String translateToLocal(String text) {
            return I18n.func_74838_a((String)text);
        }
    }
}

