/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

public class CompatConfigSpec {
    private final List<ConfigValue<?>> values;
    private Configuration config;
    private static final Joiner LINE_JOINER = Joiner.on((String)"\n");
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");
    private static final Joiner DOT_JOINER = Joiner.on((String)".");

    private CompatConfigSpec(List<ConfigValue<?>> values) {
        this.values = values;
    }

    public boolean isAvailable() {
        return this.config != null;
    }

    public Configuration configure(Configuration config) {
        this.values.forEach(v -> v.apply(config));
        this.config = config;
        return this.config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public File getConfigFile() {
        return this.config.getConfigFile();
    }

    public void registerConfigDefine(Side side) {
    }

    public CompatConfigHandler registerConfigHandler(Side side, File location) {
        if (FMLCommonHandler.instance().getEffectiveSide() == side) {
            Configuration config = new Configuration(location, null, true);
            this.configure(config);
            config.save();
            return () -> ((Configuration)config).save();
        }
        return () -> {};
    }

    public void save() {
        this.config.save();
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    public static class DoubleValue
    extends ConfigValue<Double> {
        DoubleValue(Builder parent, List<String> path, Supplier<Double> defaultSupplier, BuilderContext builderContext) {
            super(parent, path, defaultSupplier, builderContext);
        }

        @Override
        protected Property applyDefine(Configuration builder) {
            Property ret = builder.get(DOT_JOINER.join(this.path.subList(0, this.path.size() - 1)), (String)this.path.get(this.path.size() - 1), ((Double)this.defaultSupplier.get()).doubleValue());
            this.builderContext.apply(ret);
            return ret;
        }

        @Override
        protected Double getPropertyValue() {
            return this.value.getDouble();
        }

        @Override
        protected void setPropertyValue(Double value) {
            this.value.set(value.doubleValue());
        }
    }

    public static class IntValue
    extends ConfigValue<Integer> {
        IntValue(Builder parent, List<String> path, Supplier<Integer> defaultSupplier, BuilderContext builderContext) {
            super(parent, path, defaultSupplier, builderContext);
        }

        @Override
        protected Property applyDefine(Configuration builder) {
            Property ret = builder.get(DOT_JOINER.join(this.path.subList(0, this.path.size() - 1)), (String)this.path.get(this.path.size() - 1), ((Integer)this.defaultSupplier.get()).intValue());
            this.builderContext.apply(ret);
            return ret;
        }

        @Override
        protected Integer getPropertyValue() {
            return this.value.getInt();
        }

        @Override
        protected void setPropertyValue(Integer value) {
            this.value.set(value.intValue());
        }
    }

    public static class BooleanValue
    extends ConfigValue<Boolean> {
        BooleanValue(Builder parent, List<String> path, Supplier<Boolean> defaultSupplier, BuilderContext builderContext) {
            super(parent, path, defaultSupplier, builderContext);
        }

        @Override
        protected Property applyDefine(Configuration builder) {
            Property ret = builder.get(DOT_JOINER.join(this.path.subList(0, this.path.size() - 1)), (String)this.path.get(this.path.size() - 1), ((Boolean)this.defaultSupplier.get()).booleanValue());
            this.builderContext.apply(ret);
            return ret;
        }

        @Override
        protected Boolean getPropertyValue() {
            return this.value.getBoolean();
        }

        @Override
        protected void setPropertyValue(Boolean value) {
            this.value.set(value.booleanValue());
        }
    }

    public static class StringValue
    extends ConfigValue<String> {
        StringValue(Builder parent, List<String> path, Supplier<String> defaultSupplier, BuilderContext builderContext) {
            super(parent, path, defaultSupplier, builderContext);
        }

        @Override
        protected Property applyDefine(Configuration builder) {
            Property ret = builder.get(DOT_JOINER.join(this.path.subList(0, this.path.size() - 1)), (String)this.path.get(this.path.size() - 1), (String)this.defaultSupplier.get());
            this.builderContext.apply(ret);
            return ret;
        }

        @Override
        protected String getPropertyValue() {
            return this.value.getString();
        }

        @Override
        protected void setPropertyValue(String value) {
            this.value.set(value);
        }
    }

    public static class CategoryValue
    extends ConfigValue<Void> {
        CategoryValue(Builder parent, List<String> path, Supplier<Void> defaultSupplier, BuilderContext builderContext) {
            super(parent, path, defaultSupplier, builderContext);
        }

        @Override
        protected Property applyDefine(Configuration builder) {
            ConfigCategory ret = builder.getCategory(DOT_JOINER.join((Iterable)this.path));
            this.builderContext.apply(ret);
            return null;
        }

        @Override
        protected Void getPropertyValue() {
            return null;
        }

        @Override
        protected void setPropertyValue(Void value) {
        }
    }

    public static abstract class ConfigValue<T> {
        protected final Builder parent;
        protected final List<String> path;
        protected final Supplier<T> defaultSupplier;
        protected final BuilderContext builderContext;
        protected Property value;

        ConfigValue(Builder parent, List<String> path, Supplier<T> defaultSupplier, BuilderContext builderContext) {
            this.parent = parent;
            this.path = path;
            this.defaultSupplier = defaultSupplier;
            this.parent.values.add(this);
            this.builderContext = builderContext;
        }

        public List<String> getPath() {
            return Lists.newArrayList(this.path);
        }

        protected abstract T getPropertyValue();

        protected abstract void setPropertyValue(T var1);

        public T get() {
            Preconditions.checkNotNull((Object)this.value, (Object)"Cannot get config value without assigned Config object present");
            return this.getPropertyValue();
        }

        public void set(T value) {
            Preconditions.checkNotNull((Object)this.value, (Object)"Cannot set config value without assigned Config object present");
            this.setPropertyValue(value);
        }

        public Builder next() {
            return this.parent;
        }

        protected abstract Property applyDefine(Configuration var1);

        public void apply(Configuration builder) {
            this.value = this.applyDefine(builder);
        }
    }

    private static class BuilderContext {
        private String[] comment;
        private String langKey;
        private boolean worldRestart = false;

        private BuilderContext() {
        }

        public void setComment(String ... value) {
            this.comment = value;
        }

        public String[] getComment() {
            return this.comment;
        }

        public void setTranslationKey(String value) {
            this.langKey = value;
        }

        public void worldRestart() {
            this.worldRestart = true;
        }

        public void ensureEmpty() {
            this.validate(this.comment, "Non-null comment when null expected");
            this.validate(this.langKey, "Non-null translation key when null expected");
            this.validate(this.worldRestart, "Dangeling world restart value set to true");
        }

        private void validate(Object value, String message) {
            if (value != null) {
                throw new IllegalStateException(message);
            }
        }

        private void validate(boolean value, String message) {
            if (value) {
                throw new IllegalStateException(message);
            }
        }

        public void apply(Property builder) {
            if (this.comment != null) {
                builder.setComment(LINE_JOINER.join((Object[])this.comment));
            }
            if (this.langKey != null) {
                builder.setLanguageKey(this.langKey);
            }
            if (this.worldRestart) {
                builder.setRequiresWorldRestart(true);
            }
        }

        public void apply(ConfigCategory builder) {
            if (this.comment != null) {
                builder.setComment(LINE_JOINER.join((Object[])this.comment));
            }
            if (this.langKey != null) {
                builder.setLanguageKey(this.langKey);
            }
            if (this.worldRestart) {
                builder.setRequiresWorldRestart(true);
            }
        }
    }

    public static class Builder {
        private BuilderContext context = new BuilderContext();
        private List<String> currentPath = new ArrayList<String>();
        private List<ConfigValue<?>> values = new ArrayList();

        private List<String> concat(List<String> lhs, List<String> rhs) {
            ArrayList list = Lists.newArrayList();
            list.addAll(lhs);
            list.addAll(rhs);
            return list;
        }

        public StringValue define(String path, String defaultValue) {
            return this.defineString(CompatConfigSpec.split(path), () -> defaultValue);
        }

        public StringValue defineString(List<String> path, Supplier<String> defaultSupplier) {
            List<String> newpath = this.concat(this.currentPath, path);
            StringValue ret = new StringValue(this, newpath, defaultSupplier, this.context);
            this.values.add(ret);
            this.context = new BuilderContext();
            return ret;
        }

        public BooleanValue define(String path, boolean defaultValue) {
            return this.defineBoolean(CompatConfigSpec.split(path), () -> defaultValue);
        }

        private BooleanValue defineBoolean(List<String> path, Supplier<Boolean> defaultSupplier) {
            List<String> newpath = this.concat(this.currentPath, path);
            BooleanValue ret = new BooleanValue(this, newpath, defaultSupplier, this.context);
            this.values.add(ret);
            this.context = new BuilderContext();
            return ret;
        }

        public IntValue define(String path, int defaultValue) {
            return this.defineInt(CompatConfigSpec.split(path), () -> defaultValue);
        }

        private IntValue defineInt(List<String> path, Supplier<Integer> defaultSupplier) {
            List<String> newpath = this.concat(this.currentPath, path);
            IntValue ret = new IntValue(this, newpath, defaultSupplier, this.context);
            this.values.add(ret);
            this.context = new BuilderContext();
            return ret;
        }

        public DoubleValue define(String path, double defaultValue) {
            return this.defineDouble(CompatConfigSpec.split(path), () -> defaultValue);
        }

        private DoubleValue defineDouble(List<String> path, Supplier<Double> defaultSupplier) {
            List<String> newpath = this.concat(this.currentPath, path);
            DoubleValue ret = new DoubleValue(this, newpath, defaultSupplier, this.context);
            this.values.add(ret);
            this.context = new BuilderContext();
            return ret;
        }

        private CategoryValue defineCategory(List<String> path, Supplier<Void> defaultSupplier) {
            List<String> newpath = this.concat(this.currentPath, path);
            CategoryValue ret = new CategoryValue(this, newpath, defaultSupplier, this.context);
            this.values.add(ret);
            this.context = new BuilderContext();
            return ret;
        }

        public Builder comment(String comment) {
            this.context.setComment(comment);
            return this;
        }

        public Builder comment(String ... comment) {
            this.context.setComment(comment);
            return this;
        }

        public Builder translation(String translationKey) {
            this.context.setTranslationKey(translationKey);
            return this;
        }

        public Builder worldRestart() {
            this.context.worldRestart();
            return this;
        }

        public Builder push(String path) {
            return this.push(CompatConfigSpec.split(path));
        }

        public Builder push(List<String> path) {
            this.defineCategory(path, () -> null);
            this.currentPath.addAll(path);
            return this;
        }

        public Builder pop() {
            return this.pop(1);
        }

        public Builder pop(int count) {
            if (count > this.currentPath.size()) {
                throw new IllegalArgumentException("Attempted to pop " + count + " elements when we only had: " + this.currentPath);
            }
            for (int x = 0; x < count; ++x) {
                this.currentPath.remove(this.currentPath.size() - 1);
            }
            return this;
        }

        public <T> Pair<T, CompatConfigSpec> configure(Function<Builder, T> consumer) {
            T o = consumer.apply(this);
            return Pair.of(o, (Object)this.build());
        }

        public CompatConfigSpec build() {
            this.context.ensureEmpty();
            return new CompatConfigSpec(Lists.newArrayList(this.values));
        }

        public static interface BuilderConsumer {
            public void accept(Builder var1);
        }
    }

    public static interface CompatConfigHandler {
        public void onConfigChanged();
    }
}

