/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm.lib;

import javax.annotation.Nonnull;

public class ClassName {
    @Nonnull
    private final String clsName;

    @Nonnull
    public static ClassName of(@Nonnull String clsName) {
        return new ClassName(clsName);
    }

    private ClassName(@Nonnull String clsName) {
        this.clsName = clsName;
    }

    @Nonnull
    public String getBytecodeName() {
        return ClassName.SourcecodeToBytecodeName(this.clsName);
    }

    @Nonnull
    public String getName() {
        return ClassName.BytecodeToSourcecodeName(this.clsName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.clsName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassName)) {
            return false;
        }
        ClassName other = (ClassName)obj;
        return this.clsName.equals(other.clsName);
    }

    @Nonnull
    private static String SourcecodeToBytecodeName(@Nonnull String clsName) {
        return clsName.replace('.', '/');
    }

    @Nonnull
    private static String BytecodeToSourcecodeName(@Nonnull String clsName) {
        return clsName.replace('/', '.');
    }
}

