/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import com.mojang.blaze3d.platform.TextureUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.versions.forge.ForgeVersion;
import net.minecraftforge.versions.mcp.MCPVersion;

public class Compat {
    @Nonnull
    public static Minecraft getMinecraft() {
        return Minecraft.func_71410_x();
    }

    public static class CompatMinecraftVersion {
        public static String getMinecraftVersion() {
            return MCPVersion.getMCVersion();
        }

        public static String getForgeVersion() {
            return ForgeVersion.getVersion();
        }
    }

    public static class CompatVersionChecker {
        public static void startVersionCheck(String modId, String modVersion, String updateURL) {
        }

        public static VersionChecker.CheckResult getResult(String modId) {
            IModInfo container = ModList.get().getModContainerById(modId).map(e -> e.getModInfo()).orElse(null);
            return VersionChecker.getResult((IModInfo)container);
        }
    }

    public static class CompatBufferBuilder {
    }

    public static class CompatTexture {
        public static void uploadTexture(Supplier<Integer> genTextureId, InputStream image) throws IOException {
            boolean blur = true;
            boolean clamp = false;
            try (NativeImage nativeimage = NativeImage.func_195713_a((InputStream)image);){
                TextureUtil.prepareImage((int)genTextureId.get(), (int)0, (int)nativeimage.func_195702_a(), (int)nativeimage.func_195714_b());
                nativeimage.func_195712_a(0, 0, 0, 0, 0, nativeimage.func_195702_a(), nativeimage.func_195714_b(), true, false, false);
            }
        }

        public static void uploadTexture(Supplier<Integer> genTextureId, BufferedImage bufferedimage) throws IOException {
            boolean blur = true;
            boolean clamp = false;
            int width = bufferedimage.getWidth();
            int height = bufferedimage.getHeight();
            try (NativeImage nativeimage = new NativeImage(NativeImage.PixelFormat.RGBA, width, height, false);){
                int[] pixels = new int[width * height];
                bufferedimage.getRGB(0, 0, width, height, pixels, 0, width);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int argb = pixels[y * width + x];
                        int alpha = 0xFF & argb >> 24;
                        int red = 0xFF & argb >> 16;
                        int green = 0xFF & argb >> 8;
                        int blue = 0xFF & argb >> 0;
                        int abgr = alpha << 24 | blue << 16 | green << 8 | red << 0;
                        nativeimage.func_195700_a(x, y, abgr);
                    }
                }
                TextureUtil.prepareImage((int)genTextureId.get(), (int)0, (int)nativeimage.func_195702_a(), (int)nativeimage.func_195714_b());
                nativeimage.func_195712_a(0, 0, 0, 0, 0, nativeimage.func_195702_a(), nativeimage.func_195714_b(), true, false, false);
            }
        }
    }

    public static class CompatI18n {
        public static String format(String format, Object ... args) {
            return I18n.func_135052_a((String)format, (Object[])args);
        }

        public static boolean hasKey(String key) {
            return I18n.func_188566_a((String)key);
        }

        public static String translateToLocal(String text) {
            return CompatI18n.hasKey(text) ? CompatI18n.format(text, new Object[0]) : text;
        }
    }
}

