/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GLAllocation;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLCapabilities;

public class OpenGL {
    private static FloatBuffer buf = GLAllocation.func_74529_h((int)16);
    @Nullable
    private static GLCapabilities capabilities;

    public static void glEnable(int attrib) {
        switch (attrib) {
            case 3008: {
                GlStateManager.enableAlphaTest();
                break;
            }
            case 3042: {
                GlStateManager.enableBlend();
                break;
            }
            case 2884: {
                GlStateManager.enableCull();
                break;
            }
            case 2929: {
                GlStateManager.enableDepthTest();
                break;
            }
            case 2912: {
                GlStateManager.enableFog();
                break;
            }
            case 2896: {
                GlStateManager.enableLighting();
                break;
            }
            case 2977: {
                GlStateManager.enableNormalize();
                break;
            }
            case 32823: {
                GlStateManager.enablePolygonOffset();
                break;
            }
            case 32826: {
                GlStateManager.enableRescaleNormal();
                break;
            }
            case 3553: {
                GlStateManager.enableTexture();
                break;
            }
            default: {
                GL11.glEnable((int)attrib);
            }
        }
    }

    public static void glDisable(int attrib) {
        switch (attrib) {
            case 3008: {
                GlStateManager.disableAlphaTest();
                break;
            }
            case 3042: {
                GlStateManager.disableBlend();
                break;
            }
            case 2884: {
                GlStateManager.disableCull();
                break;
            }
            case 2929: {
                GlStateManager.disableDepthTest();
                break;
            }
            case 2912: {
                GlStateManager.disableFog();
                break;
            }
            case 2896: {
                GlStateManager.disableLighting();
                break;
            }
            case 2977: {
                GlStateManager.disableNormalize();
                break;
            }
            case 32823: {
                GlStateManager.disablePolygonOffset();
                break;
            }
            case 32826: {
                GlStateManager.disableRescaleNormal();
                break;
            }
            case 3553: {
                GlStateManager.disableTexture();
                break;
            }
            default: {
                GL11.glDisable((int)attrib);
            }
        }
    }

    public static boolean glIsEnabled(int attrib) {
        return GL11.glIsEnabled((int)attrib);
    }

    public static boolean glEnabled(int attrib) {
        if (!OpenGL.glIsEnabled(attrib)) {
            OpenGL.glEnable(attrib);
            return true;
        }
        return false;
    }

    public static boolean glDisabled(int attrib) {
        if (OpenGL.glIsEnabled(attrib)) {
            OpenGL.glEnable(attrib);
            return true;
        }
        return false;
    }

    public static void glHint(int target, int mode) {
        GL11.glHint((int)target, (int)mode);
    }

    public static void glAlphaFunc(int func, float ref) {
        GlStateManager.alphaFunc((int)func, (float)ref);
    }

    public static void glBlendFunc(int sfactor, int dfactor) {
        GlStateManager.blendFunc((int)sfactor, (int)dfactor);
    }

    public static void glBlendFuncSeparate(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        GlStateManager.blendFuncSeparate((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
    }

    public static void glCallList(int list) {
        GlStateManager.callList((int)list);
    }

    public static void glClear(int mask) {
        GlStateManager.clear((int)mask, (boolean)true);
    }

    public static void glClearColor(float red, float green, float blue, float alpha) {
        GlStateManager.clearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glClearDepth(double depth) {
        GlStateManager.clearDepth((double)depth);
    }

    public static void glColor3f(float red, float green, float blue) {
        OpenGL.glColor4f(red, green, blue, 1.0f);
    }

    public static void glColor4f(float red, float green, float blue, float alpha) {
        GlStateManager.color4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glColor4i(int red, int green, int blue, int alpha) {
        OpenGL.glColor4f((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public static void glColor4ub(byte red, byte green, byte blue, byte alpha) {
        OpenGL.glColor4i(red & 0xFF, green & 0xFF, blue & 0xFF, alpha & 0xFF);
    }

    public static void glColorRGB(int rgb) {
        int value = 0xFF000000 | rgb;
        OpenGL.glColor4i(value >> 16 & 0xFF, value >> 8 & 0xFF, value >> 0 & 0xFF, value >> 24 & 0xFF);
    }

    public static void glColorRGBA(int rgba) {
        OpenGL.glColor4i(rgba >> 16 & 0xFF, rgba >> 8 & 0xFF, rgba >> 0 & 0xFF, rgba >> 24 & 0xFF);
    }

    public static void glColor(Color color) {
        OpenGL.glColor4i(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private static int toColorCode(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    private static int toColorCode(float r, float g, float b, float a) {
        return OpenGL.toColorCode((int)(r * 255.0f + 0.5f), (int)(g * 255.0f + 0.5f), (int)(b * 255.0f + 0.5f), (int)(a * 255.0f + 0.5f));
    }

    public static int glGetColorRGBA() {
        buf.clear();
        OpenGL.glGetFloat(2816, buf);
        float r = buf.get(0);
        float g = buf.get(1);
        float b = buf.get(2);
        float a = buf.get(3);
        return OpenGL.toColorCode(r, g, b, a);
    }

    public static Color glGetColor() {
        buf.clear();
        OpenGL.glGetFloat(2816, buf);
        float r = Math.min(1.0f, buf.get(0));
        float g = Math.min(1.0f, buf.get(1));
        float b = Math.min(1.0f, buf.get(2));
        float a = Math.min(1.0f, buf.get(3));
        return new Color(r, g, b, a);
    }

    public static void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GlStateManager.colorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    public static void glColorMaterial(int face, int mode) {
        GlStateManager.colorMaterial((int)face, (int)mode);
    }

    public static void glCullFace(int mode) {
        if (mode == GlStateManager.CullFace.BACK.field_187328_d) {
            GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        } else if (mode == GlStateManager.CullFace.FRONT.field_187328_d) {
            GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
        } else if (mode == GlStateManager.CullFace.FRONT_AND_BACK.field_187328_d) {
            GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.FRONT_AND_BACK);
        }
    }

    public static void glDepthFunc(int func) {
        GlStateManager.depthFunc((int)func);
    }

    public static void glDepthMask(boolean flag) {
        GlStateManager.depthMask((boolean)flag);
    }

    public static void glGetFloat(int pname, FloatBuffer params) {
        GL11.glGetFloatv((int)pname, (FloatBuffer)params);
    }

    public static void glLoadIdentity() {
        GlStateManager.loadIdentity();
    }

    public static void glLogicOp(int opcode) {
        GlStateManager.logicOp((int)opcode);
    }

    public static void glMatrixMode(int mode) {
        GlStateManager.matrixMode((int)mode);
    }

    public static void glMultMatrix(FloatBuffer m) {
        GlStateManager.multMatrix((FloatBuffer)m);
    }

    public static void glOrtho(double left, double right, double bottom, double top, double zNear, double zFar) {
        GlStateManager.ortho((double)left, (double)right, (double)bottom, (double)top, (double)zNear, (double)zFar);
    }

    public static void glPolygonOffset(float factor, float units) {
        GlStateManager.polygonOffset((float)factor, (float)units);
    }

    public static void glPopAttrib() {
        GlStateManager.popAttributes();
    }

    public static void glPopMatrix() {
        GlStateManager.popMatrix();
    }

    public static void glPushAttrib() {
        GlStateManager.pushLightingAttributes();
    }

    public static void glPushMatrix() {
        GlStateManager.pushMatrix();
    }

    public static void glRotatef(float angle, float x, float y, float z) {
        GlStateManager.rotatef((float)angle, (float)x, (float)y, (float)z);
    }

    public static void glScaled(double x, double y, double z) {
        GlStateManager.scaled((double)x, (double)y, (double)z);
    }

    public static void glScalef(float x, float y, float z) {
        GlStateManager.scalef((float)x, (float)y, (float)z);
    }

    public static void glSetActiveTextureUnit(int texture) {
        GlStateManager.activeTexture((int)texture);
    }

    public static void glShadeModel(int mode) {
        GlStateManager.shadeModel((int)mode);
    }

    public static void glTranslated(double x, double y, double z) {
        GlStateManager.translated((double)x, (double)y, (double)z);
    }

    public static void glTranslatef(float x, float y, float z) {
        GlStateManager.translatef((float)x, (float)y, (float)z);
    }

    public static void glViewport(int x, int y, int width, int height) {
        GlStateManager.viewport((int)x, (int)y, (int)width, (int)height);
    }

    public static void glBegin(int mode) {
        GL11.glBegin((int)mode);
    }

    public static void glEnd() {
        GL11.glEnd();
    }

    public static int glGenTextures() {
        return GlStateManager.genTexture();
    }

    public static int glGetTexLevelParameteri(int target, int level, int pname) {
        return GL11.glGetTexLevelParameteri((int)target, (int)level, (int)pname);
    }

    public static int glGetTexParameteri(int target, int pname) {
        return GL11.glGetTexParameteri((int)target, (int)pname);
    }

    public static void glNormal3f(float nx, float ny, float nz) {
        GL11.glNormal3f((float)nx, (float)ny, (float)nz);
    }

    public static void glPushAttrib(int mask) {
        GL11.glPushAttrib((int)mask);
    }

    public static void glTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        GL11.glTexImage2D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)border, (int)format, (int)type, (IntBuffer)pixels);
    }

    public static void glTexParameteri(int target, int pname, int param) {
        GL11.glTexParameteri((int)target, (int)pname, (int)param);
    }

    public static void glTexCoord2f(float sCoord, float tCoord) {
        GlStateManager.texCoord2f((float)sCoord, (float)tCoord);
    }

    public static void glVertex2f(float x, float y) {
        GL11.glVertex2f((float)x, (float)y);
    }

    public static void glVertex3f(float x, float y, float z) {
        GL11.glVertex3f((float)x, (float)y, (float)z);
    }

    public static void glLineWidth(float width) {
        GL11.glLineWidth((float)width);
    }

    public static void glStencilFunc(int func, int ref, int mask) {
        GL11.glStencilFunc((int)func, (int)ref, (int)mask);
    }

    public static void glStencilMask(int mask) {
        GL11.glStencilMask((int)mask);
    }

    public static void glStencilOp(int fail, int zfail, int zpass) {
        GL11.glStencilOp((int)fail, (int)zfail, (int)zpass);
    }

    public static boolean openGl30() {
        GLCapabilities cap;
        if (capabilities == null) {
            capabilities = GL.getCapabilities();
        }
        return (cap = capabilities) != null && cap.OpenGL30;
    }

    public static void glGenerateMipmap(int target) {
        GL30.glGenerateMipmap((int)target);
    }

    public static void glBindTexture(int target, int texture) {
        if (target == 3553) {
            GlStateManager.bindTexture((int)texture);
        } else {
            GL11.glBindTexture((int)target, (int)texture);
        }
    }

    public static void glDeleteTextures(int texture) {
        GlStateManager.deleteTexture((int)texture);
    }
}

