/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.emoji;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.client.gui.fonts.IGlyph;
import net.minecraft.client.gui.fonts.TexturedGlyph;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.teamfruit.emojicord.EmojicordConfig;
import net.teamfruit.emojicord.EmojicordScope;
import net.teamfruit.emojicord.emoji.EmojiContext;
import net.teamfruit.emojicord.emoji.EmojiId;
import net.teamfruit.emojicord.emoji.EmojiObject;
import net.teamfruit.emojicord.emoji.EmojiText;

public class EmojiFontRenderer {
    public static boolean shadow;
    public static int index;
    private static EmojiContext CurrentContext;

    public static String updateEmojiContext(String text) {
        if (EmojicordConfig.spec.isAvailable() && EmojicordConfig.RENDER.renderEnabled.get().booleanValue()) {
            EnumSet<EmojiContext.EmojiContextAttribute> attributes = EnumSet.noneOf(EmojiContext.EmojiContextAttribute.class);
            StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
            if (EmojicordScope.instance.checkIsInput(stacks)) {
                attributes.add(EmojiContext.EmojiContextAttribute.CHAT_INPUT);
            }
            if (EmojicordScope.instance.checkIsMessage(stacks)) {
                attributes.add(EmojiContext.EmojiContextAttribute.CHAT_MESSAGE);
            }
            CurrentContext = EmojiContext.EmojiContextCache.instance.getContext(text, attributes);
            return EmojiFontRenderer.CurrentContext.text;
        }
        CurrentContext = null;
        return text;
    }

    @Nullable
    public static EmojiGlyph getEmojiGlyph(char c, int index) {
        EmojiId emojiId;
        EmojiText.EmojiTextElement emojiElement;
        if (CurrentContext != null && (emojiElement = EmojiFontRenderer.CurrentContext.emojis.get(index)) != null && (emojiId = emojiElement.id) != null) {
            return new EmojiGlyph(emojiId);
        }
        return null;
    }

    public static class EmojiTexturedGlyph
    extends TexturedGlyph {
        public EmojiTexturedGlyph(ResourceLocation texture, float width, float height) {
            super(texture, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, width, 3.0f, height + 3.0f);
        }

        public EmojiTexturedGlyph(EmojiId emojiId) {
            this(EmojiObject.EmojiObjectCache.instance.getEmojiObject(emojiId).loadAndGetResourceLocation(), 10.0f, 10.0f);
        }

        public void func_211234_a(TextureManager textureManager, boolean hasShadow, float x, float y, BufferBuilder vbuilder, float red, float green, float blue, float alpha) {
            if (!shadow) {
                super.func_211234_a(textureManager, hasShadow, x, y, vbuilder, 1.0f, 1.0f, 1.0f, alpha);
            }
        }
    }

    public static class EmojiGlyph
    extends CompatGlyph {
        public static final float GlyphWidth = 10.0f;
        public static final float GlyphHeight = 10.0f;
        private final EmojiId emojiId;

        public EmojiGlyph(EmojiId emojiId) {
            super(10.0f, 10.0f);
            this.emojiId = emojiId;
        }

        public EmojiTexturedGlyph getTexturedGlyph() {
            return new EmojiTexturedGlyph(this.emojiId);
        }
    }

    public static abstract class CompatGlyph
    implements IGlyph {
        public final float width;
        public final float height;

        public CompatGlyph(float width, float height) {
            this.width = width;
            this.height = height;
        }

        public float getAdvance() {
            return this.width;
        }

        public float func_223275_b_() {
            return 0.0f;
        }

        public float func_223276_c_() {
            return 0.0f;
        }
    }
}

