/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.gui;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraftforge.fml.VersionChecker;
import net.teamfruit.emojicord.EmojicordConfig;
import net.teamfruit.emojicord.OSUtils;
import net.teamfruit.emojicord.compat.Compat;
import net.teamfruit.emojicord.compat.CompatGui;
import net.teamfruit.emojicord.emoji.DiscordEmojiIdDictionary;
import net.teamfruit.emojicord.emoji.EmojiFrequently;
import net.teamfruit.emojicord.emoji.EmojiId;
import net.teamfruit.emojicord.emoji.PickerGroup;
import net.teamfruit.emojicord.emoji.PickerItem;
import net.teamfruit.emojicord.emoji.StandardEmojiIdPicker;
import net.teamfruit.emojicord.gui.EmojiSettings;
import net.teamfruit.emojicord.gui.IChatOverlay;
import net.teamfruit.emojicord.gui.Rectangle2d;
import net.teamfruit.emojicord.util.MathHelper;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class EmojiSelectionChat
implements IChatOverlay {
    public final ChatScreen chatScreen;
    public final TextFieldWidget inputField;
    public final FontRenderer font;
    public int mouseX;
    public int mouseY;
    private EmojiSelectionList selectionList;
    private final Rectangle2d emojiButton;
    private final List<String> faces;
    private boolean onButton;
    private String face = ":smile:";
    private boolean enabled;

    public EmojiSelectionChat(ChatScreen chatScreen) {
        this.chatScreen = chatScreen;
        this.font = Compat.getMinecraft().field_71466_p;
        this.inputField = chatScreen.field_146415_a;
        this.emojiButton = new Rectangle2d(this.chatScreen.width - 13, this.chatScreen.height - 13, 10, 10);
        this.enabled = !StandardEmojiIdPicker.instance.categories.isEmpty();
        this.faces = Lists.newArrayList();
        List<PickerGroup> standardCategories = StandardEmojiIdPicker.instance.categories;
        List people = standardCategories.stream().filter(e -> "PEOPLE".equalsIgnoreCase(e.name)).limit(1L).flatMap(e -> e.items.stream()).collect(Collectors.toList());
        for (PickerItem item : people) {
            this.faces.add(item.name);
            if (!StringUtils.equals((CharSequence)":sleeping:", (CharSequence)item.name)) continue;
            break;
        }
    }

    @Override
    public boolean onDraw() {
        if (this.selectionList != null) {
            this.selectionList.onDraw();
        } else {
            boolean onButtonLast = this.onButton;
            this.onButton = this.emojiButton.contains(this.mouseX, this.mouseY);
            if (this.onButton && !onButtonLast && !this.faces.isEmpty()) {
                this.face = this.faces.get(RandomUtils.nextInt((int)0, (int)this.faces.size()));
            }
        }
        if (this.enabled) {
            this.font.func_211126_b(this.face, (float)this.emojiButton.getX(), (float)this.emojiButton.getY(), 0xFFFFFF);
        } else {
            this.font.func_211126_b("\u2717", (float)this.emojiButton.getX(), (float)this.emojiButton.getY(), 0xFF0000);
            if (this.emojiButton.contains(this.mouseX, this.mouseY)) {
                this.chatScreen.renderTooltip(Arrays.asList(Compat.CompatI18n.format("emojicord.chat.error.disabled", new Object[0]).split("\\\\n|\n")), this.mouseX, this.mouseY);
            }
        }
        return false;
    }

    @Override
    public boolean onMouseClicked(int button) {
        if (this.selectionList == null && this.emojiButton.contains(this.mouseX, this.mouseY)) {
            if (this.enabled) {
                this.show();
            }
            return true;
        }
        return this.selectionList != null && this.selectionList.onMouseClicked(button);
    }

    @Override
    public boolean onMouseReleased(int button) {
        return this.selectionList != null && this.selectionList.onMouseReleased(button);
    }

    @Override
    public boolean onMouseScroll(double scrollDelta) {
        return this.selectionList != null && this.selectionList.onMouseScroll(scrollDelta);
    }

    @Override
    public boolean onMouseInput(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        return false;
    }

    @Override
    public boolean onCharTyped(char typed, int keycode) {
        return this.selectionList != null && this.selectionList.onCharTyped(typed, keycode);
    }

    @Override
    public boolean onKeyPressed(int keycode) {
        return this.selectionList != null && this.selectionList.onKeyPressed(keycode);
    }

    @Override
    public void onTick() {
        if (this.selectionList != null) {
            this.selectionList.onTick();
        }
    }

    public void show() {
        int width = 152;
        int height = 152;
        List<PickerGroup> standardCategories = StandardEmojiIdPicker.instance.categories;
        ArrayList frequently = Lists.newArrayList((Object[])new PickerGroup[]{EmojiFrequently.instance.getGroup()});
        List<PickerGroup> discordCategories = DiscordEmojiIdDictionary.instance.pickerGroups;
        List categories = Stream.of(frequently.stream(), discordCategories.stream(), standardCategories.stream()).flatMap(stream -> stream).collect(Collectors.toList());
        List buttonCategories = (List)((Supplier)() -> Arrays.asList(Pair.of((Object)"<:frequently:630652521911943191>", frequently.stream().findFirst().map(e -> e.setTranslation("emojicord.gui.picker.standard.frequently")).orElse(null)), Pair.of((Object)"<:custom:630652548331864085>", discordCategories.stream().findFirst().orElse(null)), Pair.of((Object)"<:people:630652609807515658>", standardCategories.stream().filter(e -> "PEOPLE".equalsIgnoreCase(e.name)).findFirst().map(e -> e.setTranslation("emojicord.gui.picker.standard.people")).orElse(null)), Pair.of((Object)"<:nature:630652621497171979>", standardCategories.stream().filter(e -> "NATURE".equalsIgnoreCase(e.name)).findFirst().map(e -> e.setTranslation("emojicord.gui.picker.standard.nature")).orElse(null)), Pair.of((Object)"<:food:630652671510183956>", standardCategories.stream().filter(e -> "FOOD".equalsIgnoreCase(e.name)).findFirst().map(e -> e.setTranslation("emojicord.gui.picker.standard.food")).orElse(null)), Pair.of((Object)"<:activities:630652683480465408>", standardCategories.stream().filter(e -> "ACTIVITIES".equalsIgnoreCase(e.name)).findFirst().map(e -> e.setTranslation("emojicord.gui.picker.standard.activities")).orElse(null)), Pair.of((Object)"<:travel:630652707631267860>", standardCategories.stream().filter(e -> "TRAVEL".equalsIgnoreCase(e.name)).findFirst().map(e -> e.setTranslation("emojicord.gui.picker.standard.travel")).orElse(null)), Pair.of((Object)"<:objects:630652735083249664>", standardCategories.stream().filter(e -> "OBJECTS".equalsIgnoreCase(e.name)).findFirst().map(e -> e.setTranslation("emojicord.gui.picker.standard.objects")).orElse(null)), Pair.of((Object)"<:symbols:630652764955082752>", standardCategories.stream().filter(e -> "SYMBOLS".equalsIgnoreCase(e.name)).findFirst().map(e -> e.setTranslation("emojicord.gui.picker.standard.symbols")).orElse(null)), Pair.of((Object)"<:flags:630652781866385490>", standardCategories.stream().filter(e -> "FLAGS".equalsIgnoreCase(e.name)).findFirst().map(e -> e.setTranslation("emojicord.gui.picker.standard.flags")).orElse(null)))).get();
        this.selectionList = new EmojiSelectionList(this.chatScreen.width, this.chatScreen.height - 12, 152, 152, categories, buttonCategories);
    }

    public void hide() {
        this.selectionList = null;
    }

    private class EmojiSelectionList
    implements IChatOverlay {
        private final Rectangle2d rectangle;
        private final Rectangle2d rectTop;
        private final Rectangle2d rectInput;
        private final Rectangle2d rectInputField;
        private final Rectangle2d rectInputButton;
        private final Rectangle2d rectBottom;
        private final Rectangle2d rectMain;
        private final Rectangle2d rectColorButton;
        private final Rectangle2d rectColor;
        private final Rectangle2d rectSettingButton;
        private final Rectangle2d rectUpdate;
        private final VersionChecker.CheckResult update;
        private final List<PickerGroup> baseCategories;
        private final List<Pair<String, PickerGroup>> buttonCategories;
        private List<PickerGroup> categories;
        private TextFieldWidget searchField;
        private float scrollY;
        private int scrollY0;
        private int selectedGroupIndex = -1;
        private int selectedIndex = -1;
        private PickerItem selecting;
        private PickerGroup selectingGroupButton = null;
        private boolean colorShown;
        private int selectingColor = -1;
        private int selectedColor = -1;
        private boolean mouseDown;

        private EmojiSelectionList(int posX, int posY, int width, int height, List<PickerGroup> categories, List<Pair<String, PickerGroup>> buttonCategories) {
            this.rectangle = new Rectangle2d(posX - 3 - width, posY - 4 - height, width + 1, height + 1);
            this.selectedColor = EmojicordConfig.PICKER.skinTone.get();
            int marginTop = 6;
            int paddingTop = 2;
            int bannerTopHeight = 28;
            int bannerBottomHeight = 16;
            int colorButtonWidth = 12;
            int settingButtonWidth = 12;
            int searchButtonWidth = 12;
            this.rectTop = new Rectangle2d(this.rectangle.getX(), this.rectangle.getY(), this.rectangle.getWidth(), 28);
            this.rectInput = this.rectTop.inner(6, 6, 30, 6);
            this.rectInputField = this.rectInput.inner(4, 4, 12, 0);
            this.rectInputButton = new Rectangle2d(this.rectInput.getX() + this.rectInput.getWidth() - 12, this.rectInput.getY(), 12, this.rectInput.getHeight());
            this.rectBottom = new Rectangle2d(this.rectangle.getX(), this.rectangle.getY() + this.rectangle.getHeight() - 16, this.rectangle.getWidth(), 16);
            this.rectMain = new Rectangle2d(this.rectangle.getX(), this.rectTop.getY() + this.rectTop.getHeight(), this.rectangle.getWidth(), this.rectBottom.getY() - (this.rectTop.getY() + this.rectTop.getHeight()));
            this.rectSettingButton = new Rectangle2d(this.rectTop.getX() + this.rectTop.getWidth() - 12 - 4, this.rectInput.getY(), 12, this.rectInput.getHeight()).inner(0, 2, 0, 2);
            this.rectColorButton = new Rectangle2d(this.rectSettingButton.getX() - 12, this.rectInput.getY(), 12, this.rectInput.getHeight()).inner(0, 2, 0, 2);
            this.rectColor = new Rectangle2d(this.rectColorButton.getX(), this.rectColorButton.getY(), this.rectColorButton.getWidth(), 84);
            this.rectUpdate = new Rectangle2d(this.rectangle.getX(), this.rectangle.getY() - 15, this.rectangle.getWidth(), 15);
            this.baseCategories = categories;
            this.buttonCategories = buttonCategories;
            this.categories = categories;
            this.select(0, 0);
            this.searchField = new TextFieldWidget(EmojiSelectionChat.this.font, this.rectInputField.getX(), this.rectInputField.getY(), this.rectInputField.getWidth(), this.rectInputField.getHeight(), "Search Field");
            this.searchField.func_146203_f(256);
            this.searchField.func_146185_a(false);
            this.searchField.func_146195_b(true);
            this.onTextChanged();
            this.update = EmojicordConfig.UPDATE.showUpdate.get() != false ? Compat.CompatVersionChecker.getResult("emojicord") : null;
        }

        @Override
        public boolean onDraw() {
            int height;
            IChatOverlay.fill(this.rectangle, -1);
            int row = 10;
            int emojiSize = 10;
            int emojiMargin = 2;
            int paddingLeft = 8;
            int spanX = 14;
            int spanY = 14;
            int titleSpanY = 4;
            int titleSpanY2 = 12;
            int scrollbarWidth = 6;
            this.scrollY = MathHelper.lerp(this.scrollY, this.scrollY0, 0.5f);
            int posX = this.rectMain.getX() + 8;
            int posY = this.rectMain.getY() + (int)this.scrollY;
            this.selecting = null;
            int groupIndex = 0;
            for (PickerGroup group : this.categories) {
                if (this.rectMain.contains(this.rectMain.getX(), posY += 4) || this.rectMain.contains(this.rectMain.getX() + this.rectMain.getWidth(), posY + 12)) {
                    EmojiSelectionChat.this.font.func_211126_b(group.getTranslation(), (float)posX, (float)posY, -5526613);
                }
                posY += 12;
                int index = 0;
                for (PickerItem item : group.items) {
                    int ix = index % 10;
                    int px = posX + ix * 14;
                    int iy = index / 10;
                    int py = posY + iy * 14;
                    Rectangle2d rect = new Rectangle2d(px - 2, py - 2, 14, 14);
                    if (this.rectMain.overlap(rect)) {
                        if (this.selectedGroupIndex == groupIndex && this.selectedIndex == index) {
                            IChatOverlay.fill(rect, -1315861);
                        }
                        String tone = "";
                        if (this.selectedColor > 0 && EmojiId.StandardEmojiId.fromAlias(StringUtils.strip((String)item.name, (String)":") + ":skin-tone-" + this.selectedColor) != null) {
                            tone = ":skin-tone-" + this.selectedColor + ":";
                        }
                        EmojiSelectionChat.this.font.func_211126_b(item.name + tone, (float)(rect.getX() + 2), (float)(rect.getY() + 2), -1);
                        if (rect.contains(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY)) {
                            this.selecting = item;
                            if (this.selectedGroupIndex != groupIndex || this.selectedIndex != index) {
                                this.selectedGroupIndex = groupIndex;
                                this.selectedIndex = index;
                                if (!StringUtils.isNotEmpty((CharSequence)this.searchField.func_146179_b())) {
                                    CompatGui.CompatTextFieldWidget.setSuggestion(this.searchField, StringUtils.replace((String)item.text, (String)":", (String)"\u00a7r:"));
                                }
                            }
                        }
                    }
                    ++index;
                }
                int n = group.items.size() % 10 > 0 ? 1 : 0;
                ++groupIndex;
                if ((posY += (group.items.size() / 10 + n) * 14) <= this.rectMain.getY() + this.rectMain.getHeight()) continue;
                break;
            }
            this.scrollY0 = (height = this.categories.stream().mapToInt(e -> 16 + ((e.items.size() - 1) / 10 + 1) * 14).sum()) <= this.rectMain.getHeight() ? 0 : -MathHelper.clamp(-this.scrollY0, 0, height - this.rectMain.getHeight());
            Rectangle2d rectScroll0 = new Rectangle2d(this.rectMain.getX() + this.rectMain.getWidth() - 6, this.rectMain.getY(), 6, this.rectMain.getHeight());
            Rectangle2d rectScroll = rectScroll0.inner(1, 2, 1, 2);
            int scrollbarHeight = Math.min(rectScroll.getHeight(), rectScroll.getHeight() * rectScroll.getHeight() / height);
            IChatOverlay.fill(rectScroll, -1315861);
            if (height > this.rectMain.getHeight()) {
                IChatOverlay.fill(new Rectangle2d(rectScroll.getX(), rectScroll.getY() + (int)MathHelper.lerp(0.0f, rectScroll.getHeight() - scrollbarHeight, -this.scrollY / (float)(height - this.rectMain.getHeight())), rectScroll.getWidth(), scrollbarHeight), -5526613);
                if (rectScroll0.contains(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY) && this.mouseDown) {
                    this.scrollY0 = (int)(-MathHelper.lerp(0.0f, height - this.rectMain.getHeight(), ((float)EmojiSelectionChat.this.mouseY - (float)rectScroll.getY()) / (float)rectScroll.getHeight()));
                }
            }
            IChatOverlay.fill(this.rectTop, -1);
            IChatOverlay.fill(this.rectInput, -5526613);
            IChatOverlay.fill(this.rectBottom, -1);
            IChatOverlay.fill(this.rectTop.getX(), this.rectTop.getY() + this.rectTop.getHeight(), this.rectTop.getX() + this.rectTop.getWidth(), this.rectTop.getY() + this.rectTop.getHeight() + 1, -1315861);
            IChatOverlay.fill(this.rectBottom.getX(), this.rectBottom.getY() - 1, this.rectBottom.getX() + this.rectBottom.getWidth(), this.rectBottom.getY(), -1315861);
            boolean colorOffset = true;
            EmojiSelectionChat.this.font.func_211126_b(":ok_hand:" + (this.selectedColor > 0 ? ":skin-tone-" + this.selectedColor + ":" : ""), (float)(this.rectColorButton.getX() + 1), (float)(this.rectColorButton.getY() + 1), -1);
            if (this.colorShown) {
                IChatOverlay.fill(this.rectColor, -1052689);
                posY = this.rectColor.getY();
                this.selectingColor = -1;
                int[] colorIndex = Stream.of(IntStream.of(this.selectedColor), IntStream.rangeClosed(0, 5).filter(e -> e != this.selectedColor)).flatMapToInt(stream -> stream).toArray();
                for (int pindex = 0; pindex < 6; ++pindex) {
                    int py = posY + pindex * 14;
                    int index = colorIndex[pindex];
                    Rectangle2d rect = new Rectangle2d(this.rectColor.getX(), py, this.rectColor.getWidth(), 14);
                    EmojiSelectionChat.this.font.func_211126_b(":ok_hand:" + (index > 0 ? ":skin-tone-" + index + ":" : ""), (float)(rect.getX() + 1), (float)(rect.getY() + 1), -1);
                    if (!rect.contains(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY)) continue;
                    this.selectingColor = index;
                }
            }
            EmojiSelectionChat.this.font.func_211126_b(":gear:", (float)(this.rectSettingButton.getX() + 1), (float)(this.rectSettingButton.getY() + 1), -1);
            PickerGroup currentGroup = null;
            int height2 = 0;
            for (PickerGroup group : this.categories) {
                if ((height2 += 16 + ((group.items.size() - 1) / 10 + 1) * 14) + this.scrollY0 <= 0) continue;
                currentGroup = group;
                break;
            }
            int posX2 = this.rectBottom.getX() + 8;
            int posY2 = this.rectBottom.getY() + 2;
            int index = 0;
            this.selectingGroupButton = null;
            for (Pair<String, PickerGroup> group : this.buttonCategories) {
                int px = posX2 + index * 14;
                Rectangle2d rect = new Rectangle2d(px, posY2, 10, 10).outer(2, 2, 2, 2);
                if (this.selectingGroupButton != null && this.selectingGroupButton == group.getRight()) {
                    IChatOverlay.fill(rect, -1315861);
                }
                if (currentGroup == group.getRight()) {
                    IChatOverlay.fill(new Rectangle2d(rect.getX(), rect.getY() + rect.getHeight(), rect.getWidth(), 2), -9270822);
                }
                EmojiSelectionChat.this.font.func_211126_b((String)group.getLeft(), (float)(rect.getX() + 2), (float)(rect.getY() + 2), -1);
                if (rect.contains(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY)) {
                    this.selectingGroupButton = (PickerGroup)group.getRight();
                }
                ++index;
            }
            float partialTicks = 0.066f;
            this.searchField.render(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY, 0.066f);
            EmojiSelectionChat.this.font.func_211126_b(this.searchField.func_146179_b().isEmpty() ? "<:search:631021534705877012>" : "<:close:631021519295741973>", (float)(this.rectInputButton.getX() + 1), (float)(this.rectInputButton.getY() + 3), -1);
            if (this.update != null && this.update.status == VersionChecker.Status.OUTDATED) {
                IChatOverlay.fill(this.rectUpdate, -13223617);
                String text1 = Compat.CompatI18n.format("emojicord.gui.picker.update", this.update.target);
                EmojiSelectionChat.this.font.func_211126_b(text1, (float)(this.rectUpdate.getX() + 2), (float)(this.rectUpdate.getY() + 3), -1);
            }
            return false;
        }

        @Override
        public boolean onMouseClicked(int button) {
            if (button == 0) {
                this.mouseDown = true;
            }
            if (this.update != null && this.update.status == VersionChecker.Status.OUTDATED && this.rectUpdate.contains(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY)) {
                if (this.update.url != null) {
                    OSUtils.getOSType().openURI(this.update.url);
                }
                return true;
            }
            if (!this.rectangle.contains(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY)) {
                EmojiSelectionChat.this.hide();
                return true;
            }
            if (this.rectSettingButton.contains(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY)) {
                if (EmojiSettings.showSettings != null) {
                    EmojiSelectionChat.this.hide();
                    EmojiSettings.showSettings.run();
                }
                return true;
            }
            if (!this.colorShown) {
                if (this.rectColorButton.contains(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY)) {
                    this.colorShown = true;
                    return true;
                }
            } else {
                if (this.rectColor.contains(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY)) {
                    if (this.selectingColor >= 0) {
                        this.selectedColor = this.selectingColor;
                    }
                    EmojicordConfig.PICKER.skinTone.set(this.selectedColor);
                    EmojicordConfig.spec.save();
                }
                this.colorShown = false;
                return true;
            }
            if (this.rectInputButton.contains(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY)) {
                if (!this.searchField.func_146179_b().isEmpty()) {
                    this.searchField.func_146180_a("");
                }
                this.searchField.func_146195_b(true);
                this.onTextChanged();
                return true;
            }
            boolean b = this.searchField.mouseClicked((double)EmojiSelectionChat.this.mouseX, (double)EmojiSelectionChat.this.mouseY, button);
            if (b) {
                return true;
            }
            if (this.rectMain.contains(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY) && this.selecting != null) {
                String tone = "";
                if (this.selecting.id instanceof EmojiId.StandardEmojiId && this.selectedColor > 0 && EmojiId.StandardEmojiId.fromAlias(StringUtils.strip((String)this.selecting.name, (String)":") + ":skin-tone-" + this.selectedColor) != null) {
                    tone = ":skin-tone-" + this.selectedColor + ":";
                }
                EmojiSelectionChat.this.inputField.func_146191_b(this.selecting.name + tone + " ");
                EmojiSelectionChat.this.hide();
                return true;
            }
            if (this.rectBottom.contains(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY) && this.selectingGroupButton != null) {
                int row = 10;
                int spanY = 14;
                int titleSpanY = 4;
                int titleSpanY2 = 12;
                int height = 0;
                for (PickerGroup group : this.categories) {
                    if (group == this.selectingGroupButton) {
                        this.scrollY0 = -height;
                        break;
                    }
                    height += 16 + ((group.items.size() - 1) / 10 + 1) * 14;
                }
                return true;
            }
            return true;
        }

        @Override
        public boolean onMouseReleased(int button) {
            if (button == 0) {
                this.mouseDown = false;
            }
            return true;
        }

        @Override
        public boolean onMouseScroll(double scrollDelta) {
            if (this.rectMain.contains(EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY)) {
                this.scrollY0 = (int)((double)this.scrollY0 + scrollDelta * 10.0);
                return true;
            }
            return false;
        }

        private void onTextChanged() {
            this.selectedGroupIndex = -1;
            this.selectedIndex = -1;
            if (StringUtils.isNotEmpty((CharSequence)this.searchField.func_146179_b())) {
                CompatGui.CompatTextFieldWidget.setSuggestion(this.searchField, "");
                String searchText = StringUtils.strip((String)this.searchField.func_146179_b(), (String)":");
                List<PickerItem> candidates = this.baseCategories.stream().flatMap(e -> e.items.stream()).filter(e -> e.alias.stream().anyMatch(s -> s.contains(searchText))).collect(Collectors.toList());
                this.categories = Lists.newArrayList((Object[])new PickerGroup[]{new PickerGroup("Search", candidates)});
            } else {
                CompatGui.CompatTextFieldWidget.setSuggestion(this.searchField, Compat.CompatI18n.format("emojicord.gui.picker.search", new Object[0]));
                this.categories = this.baseCategories;
            }
        }

        @Override
        public boolean onCharTyped(char typed, int keycode) {
            if (this.searchField.charTyped(typed, keycode)) {
                this.onTextChanged();
                return true;
            }
            return false;
        }

        @Override
        public boolean onKeyPressed(int keycode) {
            if (this.searchField.keyPressed(keycode, EmojiSelectionChat.this.mouseX, EmojiSelectionChat.this.mouseY)) {
                this.onTextChanged();
                return true;
            }
            return false;
        }

        @Override
        public void onTick() {
            this.searchField.func_146178_a();
        }

        public void select(int groupIndex, int index) {
            if (this.categories.isEmpty()) {
                return;
            }
            this.selectedGroupIndex = MathHelper.clamp(groupIndex, 0, this.categories.size() - 1);
            List<PickerItem> list = this.categories.get((int)this.selectedGroupIndex).items;
            if (list.isEmpty()) {
                return;
            }
            this.selectedIndex = MathHelper.clamp(index, 0, list.size() - 1);
        }
    }
}

