/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;

public abstract class CompatTransformer
implements ITransformer<ClassNode> {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean deferred = false;

    public abstract ClassNode read(@Nonnull byte[] var1);

    public abstract byte[] write(@Nonnull ClassNode var1);

    public abstract ClassNode transform(ClassNode var1, CompatTransformerVotingContext var2);

    public abstract DeferredTransform[] deferredTransforms();

    public abstract Set<String> targetNames();

    public TransformerVoteResult castVote(ITransformerVotingContext context) {
        if (this.deferred) {
            return TransformerVoteResult.YES;
        }
        this.deferred = true;
        return Arrays.stream(this.deferredTransforms()).anyMatch(DeferredTransform::shouldDefer) ? TransformerVoteResult.DEFER : TransformerVoteResult.YES;
    }

    public Set<ITransformer.Target> targets() {
        return this.targetNames().stream().map(ITransformer.Target::targetClass).collect(Collectors.toSet());
    }

    public ClassNode transform(ClassNode input, ITransformerVotingContext context) {
        return this.transform(input, new CompatTransformerVotingContext());
    }

    public static class DeferredTransform {
        private final String thisname;
        private final String targetname;
        private Supplier<Boolean> shouldDeferSupplier;

        public DeferredTransform(String thisname, String targetname) {
            this.thisname = thisname;
            this.targetname = targetname;
            this.shouldDeferSupplier = Suppliers.memoize(() -> {
                try {
                    Class.forName(this.targetname, false, this.getClass().getClassLoader());
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return false;
                }
            });
        }

        public boolean hasTarget() {
            return (Boolean)this.shouldDeferSupplier.get();
        }

        public boolean shouldDefer() {
            return (Boolean)this.shouldDeferSupplier.get();
        }
    }

    public static class CompatTransformerVotingContext {
    }
}

