/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.emoji;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.teamfruit.emojicord.emoji.EmojiId;
import net.teamfruit.emojicord.emoji.Models;
import net.teamfruit.emojicord.emoji.PickerGroup;
import net.teamfruit.emojicord.emoji.PickerItem;
import net.teamfruit.emojicord.emoji.StandardEmojiIdDictionary;
import net.teamfruit.emojicord.util.DataUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DiscordEmojiIdDictionary {
    public static final DiscordEmojiIdDictionary instance = new DiscordEmojiIdDictionary();
    public final ListMultimap<String, EmojiId> dictionary = Multimaps.newListMultimap((Map)Maps.newHashMap(), () -> Lists.newArrayList());
    public final List<Models.EmojiDiscordList> groups = Lists.newArrayList();
    public final List<PickerGroup> pickerGroups = Lists.newArrayList();
    private File dictDir;

    public EmojiId get(String name) {
        String str = StringUtils.substringBefore((String)name, (String)"~");
        Optional<EmojiId> result = this.dictionary.get((Object)str).stream().filter(e -> e.node.getUniqueName(str).equals(name)).findFirst();
        return result.orElse(null);
    }

    public Map<String, EmojiId> get() {
        HashMap dict = Maps.newHashMap();
        for (Map.Entry entry : Multimaps.asMap(this.dictionary).entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            if (!values.isEmpty()) {
                dict.put(key, values.get(0));
            }
            values.stream().filter(e -> e.node.countPrev() > 0).forEach(e -> dict.put(e.node.getUniqueName(key), e));
        }
        return dict;
    }

    public void register(String name, EmojiId id) {
        List list = this.dictionary.get((Object)name);
        if (!list.isEmpty()) {
            EmojiId last = (EmojiId)list.get(list.size() - 1);
            id.node.linkPrev(last.node);
        } else {
            EmojiId stdId = (EmojiId)StandardEmojiIdDictionary.instance.nameDictionary.get((Object)name);
            if (stdId != null) {
                id.node.linkPrev(stdId.node);
            }
        }
        list.add(id);
    }

    public void clear() {
        this.dictionary.clear();
        this.groups.clear();
        this.pickerGroups.clear();
    }

    public void init(File dictDir) {
        this.dictDir = dictDir;
    }

    public File getDictionaryDirectory() {
        return this.dictDir;
    }

    public void loadAll() {
        if (this.dictDir != null) {
            this.clear();
            new EmojiDictionaryLoader(this).loadAll(this.dictDir);
        }
    }

    public static class EmojiDictionaryLoader {
        private final DiscordEmojiIdDictionary dictionary;

        public EmojiDictionaryLoader(DiscordEmojiIdDictionary dictionary) {
            this.dictionary = dictionary;
        }

        public void loadAll(File dictDir) {
            File groupsDir = dictDir;
            groupsDir.mkdirs();
            ArrayList lists = Lists.newArrayList();
            for (File dictFile : FileUtils.listFiles((File)groupsDir, (String[])new String[]{"json"}, (boolean)true)) {
                Models.EmojiDiscordList emojiList = DataUtils.loadFile(dictFile, Models.EmojiDiscordList.class, "Discord Emoji Dictionary");
                if (emojiList == null) continue;
                lists.add(emojiList);
            }
            ArrayList pickerGroups = Lists.newArrayList();
            for (Models.EmojiDiscordList emojiList : lists) {
                if (emojiList == null || emojiList.groups == null) continue;
                for (Models.EmojiDiscordGroup emojiGroup : emojiList.groups) {
                    if (emojiGroup == null || emojiGroup.emojis == null) continue;
                    ArrayList pickerItems = Lists.newArrayList();
                    for (Models.EmojiDiscord emoji : emojiGroup.emojis) {
                        EmojiId id;
                        if (emoji == null || (id = EmojiId.DiscordEmojiId.fromDecimalId(emoji.id)) == null) continue;
                        this.dictionary.register(emoji.name, id);
                        String uid = id.node.getUniqueName(emoji.name);
                        pickerItems.add(new PickerItem(":" + uid + ":", ":" + uid + ":", Lists.newArrayList((Object[])new String[]{uid}), id));
                    }
                    if (pickerItems.isEmpty()) continue;
                    pickerGroups.add(new PickerGroup(emojiGroup.name, pickerItems));
                }
            }
            this.dictionary.groups.addAll(lists);
            this.dictionary.pickerGroups.addAll(pickerGroups);
        }
    }
}

