/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.teamfruit.emojicord.CallbackServerInstance;
import net.teamfruit.emojicord.Log;
import net.teamfruit.emojicord.OSUtils;
import net.teamfruit.emojicord.emoji.DiscordEmojiIdDictionary;
import net.teamfruit.emojicord.emoji.Endpoint;
import net.teamfruit.emojicord.emoji.Models;
import net.teamfruit.emojicord.util.DataUtils;
import org.apache.commons.lang3.StringUtils;

public class EmojicordWeb {
    @Nonnull
    public static final EmojicordWeb instance = new EmojicordWeb();
    private int port = 0;
    private CallbackServerInstance server;
    private final String key = UUID.randomUUID().toString();
    private final AtomicBoolean callbacked = new AtomicBoolean();

    public boolean open() {
        if (this.server == null && this.port != 0) {
            try {
                this.server = new CallbackServerInstance(this::callback, this::checkKey, this.port);
                this.port = this.server.getPort();
            }
            catch (IOException e) {
                Log.log.error("Could not open the callback server with port" + this.port, (Throwable)e);
            }
        }
        if (this.server == null) {
            try {
                this.server = new CallbackServerInstance(this::callback, this::checkKey);
                this.port = this.server.getPort();
            }
            catch (IOException e) {
                Log.log.error("Could not open the callback server with port" + this.port, (Throwable)e);
            }
        }
        if (this.server != null) {
            this.pollCallbacked();
            Models.EmojiGateway.EmojiGatewayApi api = Endpoint.EMOJI_API.api;
            if (api != null) {
                OSUtils.getOSType().openURI(String.format("%s?key=%s&port=%s", api.importings, this.key, this.port));
            }
            return true;
        }
        Log.log.warn("Failed to Initialize Web");
        return false;
    }

    public void close() {
        if (this.server != null) {
            this.server.close();
        }
        this.server = null;
    }

    private boolean checkKey(String key) {
        return StringUtils.equals((CharSequence)this.key, (CharSequence)key);
    }

    private void callback(Models.EmojiDiscordList model) {
        File dictDir = DiscordEmojiIdDictionary.instance.getDictionaryDirectory();
        File file = new File(dictDir, String.format("%s.json", model.id));
        DataUtils.saveFile(file, Models.EmojiDiscordList.class, model, "Emoji Data Save");
        this.callbacked.set(true);
    }

    public boolean pollCallbacked() {
        return this.callbacked.getAndSet(false);
    }

    public static class EmojicordWebTokenModel {
        public String token;
    }
}

