/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import java.awt.Color;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;

public class OpenGL {
    private static FloatBuffer buf = GLAllocation.func_74529_h((int)16);
    @Nullable
    private static ContextCapabilities capabilities;

    public static void glEnable(int attrib) {
        GL11.glEnable((int)attrib);
    }

    public static void glDisable(int attrib) {
        GL11.glDisable((int)attrib);
    }

    public static boolean glIsEnabled(int attrib) {
        return GL11.glIsEnabled((int)attrib);
    }

    public static boolean glEnabled(int attrib) {
        if (!OpenGL.glIsEnabled(attrib)) {
            OpenGL.glEnable(attrib);
            return true;
        }
        return false;
    }

    public static boolean glDisabled(int attrib) {
        if (OpenGL.glIsEnabled(attrib)) {
            OpenGL.glEnable(attrib);
            return true;
        }
        return false;
    }

    public static void glHint(int target, int mode) {
        GL11.glHint((int)target, (int)mode);
    }

    public static void glAlphaFunc(int func, float ref) {
        GL11.glAlphaFunc((int)func, (float)ref);
    }

    public static void glBlendFunc(int sfactor, int dfactor) {
        GL11.glBlendFunc((int)sfactor, (int)dfactor);
    }

    public static void glBlendFuncSeparate(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        GL14.glBlendFuncSeparate((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
    }

    public static void glCallList(int list) {
        GL11.glCallList((int)list);
    }

    public static void glClear(int mask) {
        GL11.glClear((int)mask);
    }

    public static void glClearColor(float red, float green, float blue, float alpha) {
        GL11.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glClearDepth(double depth) {
        GL11.glClearDepth((double)depth);
    }

    public static void glColor3f(float red, float green, float blue) {
        GL11.glColor3f((float)red, (float)green, (float)blue);
    }

    public static void glColor4f(float red, float green, float blue, float alpha) {
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void glColor4i(int red, int green, int blue, int alpha) {
        OpenGL.glColor4f((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public static void glColor4ub(byte red, byte green, byte blue, byte alpha) {
        GL11.glColor4ub((byte)red, (byte)green, (byte)blue, (byte)alpha);
    }

    public static void glColorRGB(int rgb) {
        int value = 0xFF000000 | rgb;
        OpenGL.glColor4i(value >> 16 & 0xFF, value >> 8 & 0xFF, value >> 0 & 0xFF, value >> 24 & 0xFF);
    }

    public static void glColorRGBA(int rgba) {
        OpenGL.glColor4i(rgba >> 16 & 0xFF, rgba >> 8 & 0xFF, rgba >> 0 & 0xFF, rgba >> 24 & 0xFF);
    }

    public static void glColor(Color color) {
        OpenGL.glColor4i(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static void glColor(org.lwjgl.util.Color color) {
        OpenGL.glColor4i(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private static int toColorCode(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    private static int toColorCode(float r, float g, float b, float a) {
        return OpenGL.toColorCode((int)(r * 255.0f + 0.5f), (int)(g * 255.0f + 0.5f), (int)(b * 255.0f + 0.5f), (int)(a * 255.0f + 0.5f));
    }

    public static int glGetColorRGBA() {
        buf.clear();
        OpenGL.glGetFloat(2816, buf);
        float r = buf.get(0);
        float g = buf.get(1);
        float b = buf.get(2);
        float a = buf.get(3);
        return OpenGL.toColorCode(r, g, b, a);
    }

    public static Color glGetColor() {
        buf.clear();
        OpenGL.glGetFloat(2816, buf);
        float r = Math.min(1.0f, buf.get(0));
        float g = Math.min(1.0f, buf.get(1));
        float b = Math.min(1.0f, buf.get(2));
        float a = Math.min(1.0f, buf.get(3));
        return new Color(r, g, b, a);
    }

    public static org.lwjgl.util.Color glGetLwjglColor() {
        buf.clear();
        OpenGL.glGetFloat(2816, buf);
        float r = buf.get(0);
        float g = buf.get(1);
        float b = buf.get(2);
        float a = buf.get(3);
        return new org.lwjgl.util.Color((int)((double)(r * 255.0f) + 0.5) & 0xFF, (int)((double)(g * 255.0f) + 0.5) & 0xFF, (int)((double)(b * 255.0f) + 0.5) & 0xFF, (int)((double)(a * 255.0f) + 0.5) & 0xFF);
    }

    public static void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GL11.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    public static void glColorMaterial(int face, int mode) {
        GL11.glColorMaterial((int)face, (int)mode);
    }

    public static void glCullFace(int mode) {
        GL11.glCullFace((int)mode);
    }

    public static void glDepthFunc(int func) {
        GL11.glDepthFunc((int)func);
    }

    public static void glDepthMask(boolean flag) {
        GL11.glDepthMask((boolean)flag);
    }

    public static void glGetFloat(int pname, FloatBuffer params) {
        GL11.glGetFloat((int)pname, (FloatBuffer)params);
    }

    public static void glLoadIdentity() {
        GL11.glLoadIdentity();
    }

    public static void glLogicOp(int opcode) {
        GL11.glLogicOp((int)opcode);
    }

    public static void glMatrixMode(int mode) {
        GL11.glMatrixMode((int)mode);
    }

    public static void glMultMatrix(FloatBuffer m) {
        GL11.glMultMatrix((FloatBuffer)m);
    }

    public static void glOrtho(double left, double right, double bottom, double top, double zNear, double zFar) {
        GL11.glOrtho((double)left, (double)right, (double)bottom, (double)top, (double)zNear, (double)zFar);
    }

    public static void glPolygonOffset(float factor, float units) {
        GL11.glPolygonOffset((float)factor, (float)units);
    }

    public static void glPopAttrib() {
        GL11.glPopAttrib();
    }

    public static void glPopMatrix() {
        GL11.glPopMatrix();
    }

    public static void glPushAttrib() {
        GL11.glPushAttrib((int)8256);
    }

    public static void glPushMatrix() {
        GL11.glPushMatrix();
    }

    public static void glRotatef(float angle, float x, float y, float z) {
        GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
    }

    public static void glScaled(double x, double y, double z) {
        GL11.glScaled((double)x, (double)y, (double)z);
    }

    public static void glScalef(float x, float y, float z) {
        GL11.glScalef((float)x, (float)y, (float)z);
    }

    public static void glSetActiveTextureUnit(int texture) {
        OpenGlHelper.func_77473_a((int)texture);
    }

    public static void glShadeModel(int mode) {
        GL11.glShadeModel((int)mode);
    }

    public static void glTranslated(double x, double y, double z) {
        GL11.glTranslated((double)x, (double)y, (double)z);
    }

    public static void glTranslatef(float x, float y, float z) {
        GL11.glTranslatef((float)x, (float)y, (float)z);
    }

    public static void glViewport(int x, int y, int width, int height) {
        GL11.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    public static void glBegin(int mode) {
        GL11.glBegin((int)mode);
    }

    public static void glEnd() {
        GL11.glEnd();
    }

    public static int glGenTextures() {
        return GL11.glGenTextures();
    }

    public static int glGetTexLevelParameteri(int target, int level, int pname) {
        return GL11.glGetTexLevelParameteri((int)target, (int)level, (int)pname);
    }

    public static int glGetTexParameteri(int target, int pname) {
        return GL11.glGetTexParameteri((int)target, (int)pname);
    }

    public static void glNormal3f(float nx, float ny, float nz) {
        GL11.glNormal3f((float)nx, (float)ny, (float)nz);
    }

    public static void glPushAttrib(int mask) {
        GL11.glPushAttrib((int)mask);
    }

    public static void glTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        GL11.glTexImage2D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)border, (int)format, (int)type, (IntBuffer)pixels);
    }

    public static void glTexParameteri(int target, int pname, int param) {
        GL11.glTexParameteri((int)target, (int)pname, (int)param);
    }

    public static void glTexCoord2f(float sCoord, float tCoord) {
        GL11.glTexCoord2f((float)sCoord, (float)tCoord);
    }

    public static void glVertex2f(float x, float y) {
        GL11.glVertex2f((float)x, (float)y);
    }

    public static void glVertex3f(float x, float y, float z) {
        GL11.glVertex3f((float)x, (float)y, (float)z);
    }

    public static void glLineWidth(float width) {
        GL11.glLineWidth((float)width);
    }

    public static void glStencilFunc(int func, int ref, int mask) {
        GL11.glStencilFunc((int)func, (int)ref, (int)mask);
    }

    public static void glStencilMask(int mask) {
        GL11.glStencilMask((int)mask);
    }

    public static void glStencilOp(int fail, int zfail, int zpass) {
        GL11.glStencilOp((int)fail, (int)zfail, (int)zpass);
    }

    public static boolean openGl30() {
        ContextCapabilities cap;
        if (capabilities == null) {
            capabilities = GLContext.getCapabilities();
        }
        return (cap = capabilities) != null && cap.OpenGL30;
    }

    public static void glGenerateMipmap(int target) {
        GL30.glGenerateMipmap((int)target);
    }

    public static void glBindTexture(int target, int texture) {
        GL11.glBindTexture((int)target, (int)texture);
    }

    public static void glDeleteTextures(int texture) {
        TextureUtil.func_147942_a((int)texture);
    }
}

