/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import cpw.mods.fml.common.versioning.ComparableVersion;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VersionChecker {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_HTTP_REDIRECTS = Integer.getInteger("http.maxRedirects", 20);
    private static Optional<CheckResult> results = Optional.empty();
    private static final CheckResult PENDING_CHECK = new CheckResult(Status.PENDING, null, null, null);

    public static void startVersionCheck(final String modId, final String modVersion, final String updateURL) {
        new Thread("Emojicord Version Check"){

            @Override
            public void run() {
                this.process(modId, modVersion, updateURL);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private InputStream openUrlStream(URL url) throws IOException {
                URL currentUrl = url;
                for (int redirects = 0; redirects < MAX_HTTP_REDIRECTS; ++redirects) {
                    URLConnection c = currentUrl.openConnection();
                    if (c instanceof HttpURLConnection) {
                        HttpURLConnection huc = (HttpURLConnection)c;
                        huc.setInstanceFollowRedirects(false);
                        int responseCode = huc.getResponseCode();
                        if (responseCode >= 300 && responseCode <= 399) {
                            try {
                                String loc = huc.getHeaderField("Location");
                                currentUrl = new URL(currentUrl, loc);
                                continue;
                            }
                            finally {
                                huc.disconnect();
                            }
                        }
                    }
                    return c.getInputStream();
                }
                throw new IOException("Too many redirects while trying to fetch " + url);
            }

            private void process(String modId2, String modVersion2, String updateURL2) {
                Status status = Status.PENDING;
                ComparableVersion target = null;
                LinkedHashMap changes = null;
                String display_url = null;
                try {
                    URL url = new URL(updateURL2);
                    LOGGER.info("[{}] Starting version check at {}", new Object[]{modId2, url.toString()});
                    InputStream con = this.openUrlStream(url);
                    String data = new String(ByteStreams.toByteArray((InputStream)con), StandardCharsets.UTF_8);
                    con.close();
                    LOGGER.debug("[{}] Received version check data:\n{}", new Object[]{modId2, data});
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    Map promos = (Map)json.get("promos");
                    display_url = (String)json.get("homepage");
                    String mcVersion = "1.7.10";
                    String rec = (String)promos.get("1.7.10-recommended");
                    String lat = (String)promos.get("1.7.10-latest");
                    ComparableVersion current = new ComparableVersion(modVersion2);
                    if (rec != null) {
                        ComparableVersion recommended = new ComparableVersion(rec);
                        int diff = recommended.compareTo(current);
                        if (diff == 0) {
                            status = Status.UP_TO_DATE;
                        } else if (diff < 0) {
                            ComparableVersion latest;
                            status = Status.AHEAD;
                            if (lat != null && current.compareTo(latest = new ComparableVersion(lat)) < 0) {
                                status = Status.OUTDATED;
                                target = latest;
                            }
                        } else {
                            status = Status.OUTDATED;
                            target = recommended;
                        }
                    } else if (lat != null) {
                        ComparableVersion latest = new ComparableVersion(lat);
                        status = current.compareTo(latest) < 0 ? Status.BETA_OUTDATED : Status.BETA;
                        target = latest;
                    } else {
                        status = Status.BETA;
                    }
                    LOGGER.info("[{}] Found status: {} Current: {} Target: {}", new Object[]{modId2, status, current, target});
                    changes = new LinkedHashMap();
                    Map tmp = (Map)json.get("1.7.10");
                    if (tmp != null) {
                        ArrayList<ComparableVersion> ordered = new ArrayList<ComparableVersion>();
                        for (String key : tmp.keySet()) {
                            ComparableVersion ver = new ComparableVersion(key);
                            if (ver.compareTo(current) <= 0 || target != null && ver.compareTo(target) >= 1) continue;
                            ordered.add(ver);
                        }
                        Collections.sort(ordered);
                        for (ComparableVersion ver : ordered) {
                            changes.put(ver, tmp.get(ver.toString()));
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to process update information", (Throwable)e);
                    status = Status.FAILED;
                }
                results = Optional.of(new CheckResult(status, target, changes, display_url));
            }
        }.start();
    }

    public static CheckResult getResult() {
        return results.orElse(PENDING_CHECK);
    }

    public static class CheckResult {
        @Nonnull
        public final Status status;
        @Nullable
        public final ComparableVersion target;
        @Nullable
        public final Map<ComparableVersion, String> changes;
        @Nullable
        public final String url;

        private CheckResult(@Nonnull Status status, @Nullable ComparableVersion target, @Nullable Map<ComparableVersion, String> changes, @Nullable String url) {
            this.status = status;
            this.target = target;
            this.changes = changes == null ? Collections.emptyMap() : Collections.unmodifiableMap(changes);
            this.url = url;
        }
    }

    public static enum Status {
        PENDING,
        FAILED,
        UP_TO_DATE,
        OUTDATED(3, true),
        AHEAD,
        BETA,
        BETA_OUTDATED(6, true);

        final int sheetOffset;
        final boolean draw;
        final boolean animated;

        private Status() {
            this(0, false, false);
        }

        private Status(int sheetOffset) {
            this(sheetOffset, true, false);
        }

        private Status(int sheetOffset, boolean animated) {
            this(sheetOffset, true, animated);
        }

        private Status(int sheetOffset, boolean draw, boolean animated) {
            this.sheetOffset = sheetOffset;
            this.draw = draw;
            this.animated = animated;
        }

        public int getSheetOffset() {
            return this.sheetOffset;
        }

        public boolean shouldDraw() {
            return this.draw;
        }

        public boolean isAnimated() {
            return this.animated;
        }
    }
}

