/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.teamfruit.emojicord.Log;
import net.teamfruit.emojicord.compat.CompatEvents;
import net.teamfruit.emojicord.compat.CompatGui;
import net.teamfruit.emojicord.emoji.EmojiFrequently;
import net.teamfruit.emojicord.emoji.EmojiText;
import net.teamfruit.emojicord.emoji.PickerItem;
import net.teamfruit.emojicord.gui.EmojiSelectionChat;
import net.teamfruit.emojicord.gui.EmojiSettings;
import net.teamfruit.emojicord.gui.IChatOverlay;
import net.teamfruit.emojicord.gui.SuggestionChat;

public class EventHandler
extends CompatEvents.CompatHandler {
    @Nonnull
    static final Pattern skintonePattern = Pattern.compile("\\:skin-tone-(\\d)\\:");
    private final List<Function<CompatGui.CompatChatScreen, IChatOverlay>> overlayFactories = Arrays.asList(EmojiSettings::new, EmojiSelectionChat::new, SuggestionChat::new);
    private List<IChatOverlay> overlays = Collections.emptyList();
    private WatchService watcher;
    private AtomicBoolean changed = new AtomicBoolean(false);

    public void registerDictionaryWatcher(File dictDir) {
        try {
            Path dir = dictDir.toPath();
            WatchService watcher = FileSystems.getDefault().newWatchService();
            dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.watcher = watcher;
        }
        catch (IOException e) {
            Log.log.warn("Could not watch the dictionary directory: ", (Throwable)e);
        }
        if (this.watcher != null) {
            ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("emojicord-directory-watch-%d").build());
            executor.submit(() -> {
                while (true) {
                    try {
                        while (true) {
                            WatchKey watchKey = this.watcher.take();
                            for (WatchEvent<?> event : watchKey.pollEvents()) {
                                if (event.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                                this.changed.set(true);
                            }
                            watchKey.reset();
                        }
                    }
                    catch (InterruptedException e) {
                        this.changed.set(true);
                        continue;
                    }
                    break;
                }
            });
            executor.shutdown();
        }
    }

    public boolean hasDictionaryDirectoryChanged() {
        if (this.watcher == null) {
            return true;
        }
        return this.changed.getAndSet(false);
    }

    @Override
    public void onChat(CompatEvents.CompatClientChatEvent event) {
        String message = event.getMessage();
        if (!message.startsWith("/")) {
            String untoned = skintonePattern.matcher(message).replaceAll("");
            EmojiText emojiText = EmojiText.create(untoned, EnumSet.of(EmojiText.ParseFlag.ESCAPE, EmojiText.ParseFlag.ENCODE, EmojiText.ParseFlag.ENCODE_ALIAS, EmojiText.ParseFlag.ENCODE_UTF, EmojiText.ParseFlag.PARSE));
            PickerItem.fromText(emojiText).forEach(EmojiFrequently.instance::use);
            if (EmojiFrequently.instance.hasChanged()) {
                EmojiFrequently.instance.save();
            }
            EmojiText emojiText2 = EmojiText.create(message, EnumSet.of(EmojiText.ParseFlag.ESCAPE, EmojiText.ParseFlag.ENCODE, EmojiText.ParseFlag.ENCODE_ALIAS, EmojiText.ParseFlag.ENCODE_UTF));
            event.setMessage(emojiText2.getEncoded());
        }
    }

    @Override
    public void onTick(CompatEvents.CompatClientTickEvent event) {
        if (event.getPhase() == CompatEvents.CompatClientTickEvent.CompatPhase.START) {
            for (IChatOverlay overlay : this.overlays) {
                overlay.onTick();
            }
        }
    }

    @Override
    public void onDraw(CompatEvents.CompatRenderGameOverlayEvent.CompatPost event) {
    }

    @Override
    public void onText(CompatEvents.CompatRenderGameOverlayEvent.CompatText event) {
    }

    @Override
    public void onConfigChanged(CompatEvents.CompatConfigChangedEvent.CompatOnConfigChangedEvent event) {
    }

    @Override
    public void onInitGui(CompatEvents.CompatGuiScreenEvent.CompatInitGuiEvent.CompatPost event) {
        CompatGui.CompatChatScreen chatScreen = CompatGui.CompatChatScreen.cast(event.getGui());
        this.overlays = chatScreen != null ? this.overlayFactories.stream().map(e -> (IChatOverlay)e.apply(chatScreen)).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public void onDraw(CompatEvents.CompatGuiScreenEvent.CompatDrawScreenEvent.CompatPost event) {
        ListIterator<IChatOverlay> itr = this.overlays.listIterator(this.overlays.size());
        while (itr.hasPrevious()) {
            IChatOverlay overlay = itr.previous();
            overlay.onMouseInput(event.getMouseX(), event.getMouseY());
            if (!overlay.onDraw()) continue;
            event.setCanceled(true);
        }
    }

    @Override
    public void onMouseClicked(CompatEvents.CompatGuiScreenEvent.CompatMouseClickedEvent.CompatPre event) {
        for (IChatOverlay overlay : this.overlays) {
            if (!overlay.onMouseClicked(event.getButton())) continue;
            event.setCanceled(true);
            break;
        }
    }

    @Override
    public void onMouseReleased(CompatEvents.CompatGuiScreenEvent.CompatMouseReleasedEvent.CompatPre event) {
        for (IChatOverlay overlay : this.overlays) {
            if (!overlay.onMouseReleased(event.getButton())) continue;
            event.setCanceled(true);
            break;
        }
    }

    @Override
    public void onMouseScroll(CompatEvents.CompatGuiScreenEvent.CompatMouseScrollEvent.CompatPre event) {
        for (IChatOverlay overlay : this.overlays) {
            if (!overlay.onMouseScroll(event.getScrollDelta())) continue;
            event.setCanceled(true);
            break;
        }
    }

    @Override
    public void onCharTyped(CompatEvents.CompatGuiScreenEvent.CompatKeyboardCharTypedEvent.CompatPre event) {
        for (IChatOverlay overlay : this.overlays) {
            if (!overlay.onCharTyped(event.getCodePoint(), event.getModifiers())) continue;
            event.setCanceled(true);
            break;
        }
    }

    @Override
    public void onKeyPressed(CompatEvents.CompatGuiScreenEvent.CompatKeyboardKeyPressedEvent.CompatPre event) {
        for (IChatOverlay overlay : this.overlays) {
            if (!overlay.onKeyPressed(event.getKeyCode())) continue;
            event.setCanceled(true);
            break;
        }
    }
}

