/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.teamfruit.emojicord.Log;
import net.teamfruit.emojicord.asm.FontRendererTransform;
import net.teamfruit.emojicord.asm.GuiScreenInputEventTransform;
import net.teamfruit.emojicord.asm.GuiTextFieldTransform;
import net.teamfruit.emojicord.asm.SendChatMessageTransform;
import net.teamfruit.emojicord.asm.lib.ClassName;
import net.teamfruit.emojicord.asm.lib.INodeTransformer;
import net.teamfruit.emojicord.asm.lib.INodeTreeTransformer;
import net.teamfruit.emojicord.asm.lib.VisitorHelper;
import net.teamfruit.emojicord.compat.CompatTransformer;
import org.objectweb.asm.tree.ClassNode;

public class EmojicordTransformer
extends CompatTransformer {
    private final INodeTreeTransformer[] transformers = new INodeTreeTransformer[]{new SendChatMessageTransform(), new GuiTextFieldTransform(), new FontRendererTransform(), new GuiScreenInputEventTransform()};
    private final Set<String> transformerNames = Stream.of(this.transformers).map(INodeTransformer::getClassName).map(ClassName::getName).collect(Collectors.toSet());
    CompatTransformer.DeferredTransform[] deferredTransforms = new CompatTransformer.DeferredTransform[]{new CompatTransformer.DeferredTransform(EmojicordTransformer.class.getName(), "com.tsoft_web.IntelliInput.asm.IntelliInputTransformer")};

    @Override
    public ClassNode read(@Nonnull byte[] bytes) {
        return VisitorHelper.read(bytes, 4);
    }

    @Override
    public byte[] write(@Nonnull ClassNode node) {
        return VisitorHelper.write(node, 2);
    }

    @Override
    public ClassNode transform(ClassNode input, CompatTransformer.CompatTransformerVotingContext context) {
        try {
            for (INodeTreeTransformer transformer : this.transformers) {
                if (!transformer.getMatcher().test(input)) continue;
                return VisitorHelper.transform(input, transformer, Log.log);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not transform: ", e);
        }
        return input;
    }

    @Override
    public CompatTransformer.DeferredTransform[] deferredTransforms() {
        return this.deferredTransforms;
    }

    @Override
    public Set<String> targetNames() {
        return this.transformerNames;
    }
}

