/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm;

import java.util.Optional;
import java.util.function.Supplier;
import net.teamfruit.emojicord.asm.ASMDeobfNames;
import net.teamfruit.emojicord.asm.lib.ASMValidate;
import net.teamfruit.emojicord.asm.lib.ClassName;
import net.teamfruit.emojicord.asm.lib.DescHelper;
import net.teamfruit.emojicord.asm.lib.INodeTreeTransformer;
import net.teamfruit.emojicord.asm.lib.MethodMatcher;
import net.teamfruit.emojicord.asm.lib.VisitorHelper;
import net.teamfruit.emojicord.compat.CompatBaseVersion;
import net.teamfruit.emojicord.compat.CompatVersion;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FontRendererTransform
implements INodeTreeTransformer {
    @Override
    public ClassName getClassName() {
        return ClassName.of("net.minecraft.client.gui.FontRenderer");
    }

    @Override
    public ClassNode apply(ClassNode node) {
        ASMValidate validator = ASMValidate.create(this.getSimpleName());
        validator.test("renderStringAtPos.updateEmojiContext");
        validator.test("renderStringAtPos.emoji");
        validator.test("renderGlyph.render", CompatVersion.version().newer(CompatBaseVersion.V13));
        validator.test("getStringWidth.updateEmojiContext");
        validator.test("getStringWidth.findGlyph", CompatVersion.version().newer(CompatBaseVersion.V13));
        validator.test("getCharWidth.width");
        validator.test("renderChar", !CompatVersion.version().newer(CompatBaseVersion.V13));
        MethodMatcher matcher = ((Supplier<MethodMatcher>)() -> {
            if (!CompatVersion.version().newer(CompatBaseVersion.V13)) {
                return new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Void.TYPE, ClassName.of("java.lang.String"), Boolean.TYPE), ASMDeobfNames.FontRendererRenderStringAtPos);
            }
            return new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Float.TYPE, ClassName.of("java.lang.String"), Float.TYPE, Float.TYPE, Integer.TYPE, Boolean.TYPE), ASMDeobfNames.FontRendererRenderStringAtPos);
        }).get();
        node.methods.stream().filter(matcher).forEach(method -> {
            MethodMatcher matcher0;
            InsnList insertion = new InsnList();
            insertion.add((AbstractInsnNode)new VarInsnNode(25, 1));
            insertion.add((AbstractInsnNode)new MethodInsnNode(184, ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer").getBytecodeName(), "updateEmojiContext", DescHelper.toDescMethod(ClassName.of("java.lang.String"), ClassName.of("java.lang.String")), false));
            insertion.add((AbstractInsnNode)new VarInsnNode(58, 1));
            method.instructions.insert(insertion);
            validator.check("renderStringAtPos.updateEmojiContext");
            if (!CompatVersion.version().newer(CompatBaseVersion.V13)) {
                matcher0 = ((Supplier<MethodMatcher>)() -> {
                    if (CompatVersion.version().older(CompatBaseVersion.V7)) {
                        return new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Float.TYPE, Integer.TYPE, Character.TYPE, Boolean.TYPE), ASMDeobfNames.FontRendererRenderCharAtPos);
                    }
                    return new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Float.TYPE, Character.TYPE, Boolean.TYPE), ASMDeobfNames.FontRendererRenderChar);
                }).get();
                VisitorHelper.stream(method.instructions).filter(matcher0.insnMatcher()).findFirst().ifPresent(marker -> {
                    InsnList insertion = new InsnList();
                    insertion.add((AbstractInsnNode)new VarInsnNode(21, 3));
                    insertion.add((AbstractInsnNode)new FieldInsnNode(179, ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer").getBytecodeName(), "index", DescHelper.toDesc(Integer.TYPE)));
                    insertion.add((AbstractInsnNode)new VarInsnNode(21, 2));
                    insertion.add((AbstractInsnNode)new FieldInsnNode(179, ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer").getBytecodeName(), "shadow", DescHelper.toDesc(Boolean.TYPE)));
                    method.instructions.insertBefore(marker, insertion);
                    insertion = new InsnList();
                    insertion.add((AbstractInsnNode)new InsnNode(3));
                    insertion.add((AbstractInsnNode)new FieldInsnNode(179, ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer").getBytecodeName(), "shadow", DescHelper.toDesc(Boolean.TYPE)));
                    method.instructions.insert(marker, insertion);
                    validator.check("renderStringAtPos.emoji");
                });
            } else {
                matcher0 = new MethodMatcher(ClassName.of("net.minecraft.client.gui.fonts.Font"), DescHelper.toDescMethod(ClassName.of("net.minecraft.client.gui.fonts.IGlyph"), Character.TYPE), ASMDeobfNames.FontFindGlyph);
                Optional<AbstractInsnNode> marker0 = VisitorHelper.stream(method.instructions).filter(matcher0.insnMatcher()).findFirst();
                Optional<AbstractInsnNode> marker1 = VisitorHelper.stream(method.instructions).filter(e -> e instanceof VarInsnNode && e.getOpcode() == 58 && ((VarInsnNode)e).var == 26).findFirst();
                if (marker0.isPresent() && marker1.isPresent()) {
                    LabelNode label0 = new LabelNode();
                    AbstractInsnNode marker2 = marker0.get().getPrevious().getPrevious().getPrevious();
                    InsnList insertion2 = new InsnList();
                    int index = 40;
                    insertion2.add((AbstractInsnNode)new VarInsnNode(21, 24));
                    insertion2.add((AbstractInsnNode)new VarInsnNode(21, 23));
                    insertion2.add((AbstractInsnNode)new MethodInsnNode(184, ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer").getBytecodeName(), "getEmojiGlyph", DescHelper.toDescMethod(ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer$EmojiGlyph"), Character.TYPE, Integer.TYPE), false));
                    insertion2.add((AbstractInsnNode)new VarInsnNode(58, 40));
                    insertion2.add((AbstractInsnNode)new VarInsnNode(25, 40));
                    LabelNode label1 = new LabelNode();
                    insertion2.add((AbstractInsnNode)new JumpInsnNode(198, label1));
                    insertion2.add((AbstractInsnNode)new VarInsnNode(25, 40));
                    insertion2.add((AbstractInsnNode)new VarInsnNode(58, 25));
                    insertion2.add((AbstractInsnNode)new VarInsnNode(25, 40));
                    insertion2.add((AbstractInsnNode)new MethodInsnNode(182, ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer$EmojiGlyph").getBytecodeName(), "getTexturedGlyph", DescHelper.toDescMethod(ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer$EmojiTexturedGlyph"), new Object[0]), false));
                    insertion2.add((AbstractInsnNode)new VarInsnNode(58, 26));
                    insertion2.add((AbstractInsnNode)new JumpInsnNode(167, label0));
                    insertion2.add((AbstractInsnNode)label1);
                    method.instructions.insertBefore(marker2, insertion2);
                    AbstractInsnNode marker3 = marker1.get();
                    insertion2 = new InsnList();
                    insertion2.add((AbstractInsnNode)label0);
                    method.instructions.insert(marker3, insertion2);
                    validator.check("renderStringAtPos.emoji");
                }
            }
        });
        if (CompatVersion.version().newer(CompatBaseVersion.V13)) {
            matcher = new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Void.TYPE, ClassName.of("net.minecraft.client.gui.fonts.TexturedGlyph"), Boolean.TYPE, Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, ClassName.of("net.minecraft.client.renderer.BufferBuilder"), Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE), ASMDeobfNames.FontRendererRenderGlyph);
            node.methods.stream().filter(matcher).forEach(method -> {
                MethodMatcher matcher0 = new MethodMatcher(ClassName.of("net.minecraft.client.gui.fonts.TexturedGlyph"), DescHelper.toDescMethod(Void.TYPE, ClassName.of("net.minecraft.client.renderer.texture.TextureManager"), Boolean.TYPE, Float.TYPE, Float.TYPE, ClassName.of("net.minecraft.client.renderer.BufferBuilder"), Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE), ASMDeobfNames.TexturedGlyphRender);
                VisitorHelper.stream(method.instructions).filter(matcher0.insnMatcher()).skip(1L).findFirst().ifPresent(marker -> {
                    InsnList insertion = new InsnList();
                    insertion.add((AbstractInsnNode)new InsnNode(4));
                    insertion.add((AbstractInsnNode)new FieldInsnNode(179, ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer").getBytecodeName(), "shadow", DescHelper.toDesc(Boolean.TYPE)));
                    method.instructions.insertBefore(marker, insertion);
                    insertion = new InsnList();
                    insertion.add((AbstractInsnNode)new InsnNode(3));
                    insertion.add((AbstractInsnNode)new FieldInsnNode(179, ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer").getBytecodeName(), "shadow", DescHelper.toDesc(Boolean.TYPE)));
                    method.instructions.insert(marker, insertion);
                    validator.check("renderGlyph.render");
                });
            });
        }
        matcher = new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Integer.TYPE, ClassName.of("java.lang.String")), ASMDeobfNames.FontRendererGetStringWidth);
        node.methods.stream().filter(matcher).forEach(method -> {
            InsnList insertion = new InsnList();
            insertion.add((AbstractInsnNode)new VarInsnNode(25, 1));
            insertion.add((AbstractInsnNode)new MethodInsnNode(184, ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer").getBytecodeName(), "updateEmojiContext", DescHelper.toDescMethod(ClassName.of("java.lang.String"), ClassName.of("java.lang.String")), false));
            insertion.add((AbstractInsnNode)new VarInsnNode(58, 1));
            method.instructions.insert(insertion);
            validator.check("getStringWidth.updateEmojiContext");
            if (CompatVersion.version().newer(CompatBaseVersion.V13)) {
                MethodMatcher matcher0 = new MethodMatcher(ClassName.of("net.minecraft.client.gui.fonts.Font"), DescHelper.toDescMethod(ClassName.of("net.minecraft.client.gui.fonts.IGlyph"), Character.TYPE), ASMDeobfNames.FontFindGlyph);
                VisitorHelper.stream(method.instructions).filter(matcher0.insnMatcher()).findFirst().ifPresent(marker0 -> {
                    AbstractInsnNode marker1 = marker0.getPrevious().getPrevious().getPrevious().getPrevious();
                    LabelNode label0 = new LabelNode();
                    LabelNode label1 = new LabelNode();
                    InsnList insertion = new InsnList();
                    insertion.add((AbstractInsnNode)new VarInsnNode(21, 5));
                    insertion.add((AbstractInsnNode)new VarInsnNode(21, 4));
                    insertion.add((AbstractInsnNode)new MethodInsnNode(184, ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer").getBytecodeName(), "getEmojiGlyph", DescHelper.toDescMethod(ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer$EmojiGlyph"), Character.TYPE, Integer.TYPE), false));
                    insertion.add((AbstractInsnNode)new VarInsnNode(58, 6));
                    method.instructions.insertBefore(marker1, insertion);
                    insertion = new InsnList();
                    insertion.add((AbstractInsnNode)new VarInsnNode(25, 6));
                    insertion.add((AbstractInsnNode)new JumpInsnNode(198, label0));
                    insertion.add((AbstractInsnNode)new VarInsnNode(25, 6));
                    insertion.add((AbstractInsnNode)new JumpInsnNode(167, label1));
                    insertion.add((AbstractInsnNode)label0);
                    method.instructions.insert(marker1, insertion);
                    insertion = new InsnList();
                    insertion.add((AbstractInsnNode)label1);
                    method.instructions.insert(marker0, insertion);
                    validator.check("getStringWidth.findGlyph");
                });
            }
        });
        matcher = ((Supplier<MethodMatcher>)() -> {
            if (!CompatVersion.version().newer(CompatBaseVersion.V13)) {
                return new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Integer.TYPE, Character.TYPE), ASMDeobfNames.FontRendererGetCharWidth);
            }
            return new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Float.TYPE, Character.TYPE), ASMDeobfNames.FontRendererGetCharWidth);
        }).get();
        node.methods.stream().filter(matcher).forEach(method -> {
            InsnList insertion = new InsnList();
            insertion.add((AbstractInsnNode)new VarInsnNode(21, 1));
            insertion.add((AbstractInsnNode)new IntInsnNode(16, 0));
            LabelNode label = new LabelNode();
            insertion.add((AbstractInsnNode)new JumpInsnNode(160, label));
            if (!CompatVersion.version().newer(CompatBaseVersion.V13)) {
                insertion.add((AbstractInsnNode)new IntInsnNode(16, 10));
                insertion.add((AbstractInsnNode)new InsnNode(172));
            } else {
                insertion.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(10.0f)));
                insertion.add((AbstractInsnNode)new InsnNode(174));
            }
            insertion.add((AbstractInsnNode)label);
            method.instructions.insert(insertion);
            validator.check("getCharWidth.width");
        });
        if (!CompatVersion.version().newer(CompatBaseVersion.V13)) {
            matcher = ((Supplier<MethodMatcher>)() -> {
                if (CompatVersion.version().older(CompatBaseVersion.V7)) {
                    return new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Float.TYPE, Integer.TYPE, Character.TYPE, Boolean.TYPE), ASMDeobfNames.FontRendererRenderCharAtPos);
                }
                return new MethodMatcher(this.getClassName(), DescHelper.toDescMethod(Float.TYPE, Character.TYPE, Boolean.TYPE), ASMDeobfNames.FontRendererRenderChar);
            }).get();
            node.methods.stream().filter(matcher).forEach(method -> {
                InsnList insertion = new InsnList();
                if (CompatVersion.version().older(CompatBaseVersion.V7)) {
                    insertion.add((AbstractInsnNode)new VarInsnNode(21, 2));
                    insertion.add((AbstractInsnNode)new VarInsnNode(21, 3));
                } else {
                    insertion.add((AbstractInsnNode)new VarInsnNode(21, 1));
                    insertion.add((AbstractInsnNode)new VarInsnNode(21, 2));
                }
                insertion.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insertion.add((AbstractInsnNode)new FieldInsnNode(180, this.getClassName().getBytecodeName(), ASMDeobfNames.FontRendererPosX.name(), DescHelper.toDesc(Float.TYPE)));
                insertion.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insertion.add((AbstractInsnNode)new FieldInsnNode(180, this.getClassName().getBytecodeName(), ASMDeobfNames.FontRendererPosY.name(), DescHelper.toDesc(Float.TYPE)));
                insertion.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insertion.add((AbstractInsnNode)new FieldInsnNode(180, this.getClassName().getBytecodeName(), ASMDeobfNames.FontRendererRed.name(), DescHelper.toDesc(Float.TYPE)));
                insertion.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insertion.add((AbstractInsnNode)new FieldInsnNode(180, this.getClassName().getBytecodeName(), ASMDeobfNames.FontRendererGreen.name(), DescHelper.toDesc(Float.TYPE)));
                insertion.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insertion.add((AbstractInsnNode)new FieldInsnNode(180, this.getClassName().getBytecodeName(), ASMDeobfNames.FontRendererBlue.name(), DescHelper.toDesc(Float.TYPE)));
                insertion.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insertion.add((AbstractInsnNode)new FieldInsnNode(180, this.getClassName().getBytecodeName(), ASMDeobfNames.FontRendererAlpha.name(), DescHelper.toDesc(Float.TYPE)));
                insertion.add((AbstractInsnNode)new MethodInsnNode(184, ClassName.of("net.teamfruit.emojicord.emoji.EmojiFontRenderer").getBytecodeName(), "renderEmojiChar", DescHelper.toDescMethod(Boolean.TYPE, Character.TYPE, Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE), false));
                LabelNode label = new LabelNode();
                insertion.add((AbstractInsnNode)new JumpInsnNode(153, label));
                insertion.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(10.0f)));
                insertion.add((AbstractInsnNode)new InsnNode(174));
                insertion.add((AbstractInsnNode)label);
                method.instructions.insert(insertion);
                validator.check("renderChar");
            });
        }
        validator.validate();
        return node;
    }
}

