/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm.lib;

import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.teamfruit.emojicord.asm.lib.ClassName;
import net.teamfruit.emojicord.asm.lib.INodeCoreTransformer;
import net.teamfruit.emojicord.asm.lib.INodeTreeTransformer;
import net.teamfruit.emojicord.asm.lib.StopTransforming;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;

public class VisitorHelper {
    public static ClassNode read(@Nonnull byte[] bytes, int readerFlags) {
        Validate.notNull((Object)bytes);
        ClassReader cr = new ClassReader(bytes);
        ClassNode node = new ClassNode(327680);
        cr.accept((ClassVisitor)node, readerFlags);
        return node;
    }

    public static byte[] write(@Nonnull ClassNode node, int writerFlags) {
        Validate.notNull((Object)node);
        ClassWriter cw = new ClassWriter(writerFlags){

            protected String getCommonSuperClass(@Nullable String type1, @Nullable String type2) {
                Class<?> d;
                Class<?> c;
                if (type1 == null || type2 == null) {
                    throw new NullPointerException();
                }
                ClassLoader classLoader = ClassWriter.class.getClassLoader();
                try {
                    try {
                        c = Class.forName(ClassName.of(type1).getName(), false, classLoader);
                        d = Class.forName(ClassName.of(type2).getName(), false, classLoader);
                    }
                    catch (ClassNotFoundException e) {
                        ClassLoader launchClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
                        try {
                            c = Class.forName(ClassName.of(type1).getName(), false, launchClassLoader);
                            d = Class.forName(ClassName.of(type2).getName(), false, launchClassLoader);
                        }
                        catch (ClassNotFoundException e1) {
                            throw new RuntimeException(String.format("ClassLoader: %s, LaunchClassLoader: %s", e.toString(), e1.toString()));
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.toString());
                }
                if (c.isAssignableFrom(d)) {
                    return type1;
                }
                if (d.isAssignableFrom(c)) {
                    return type2;
                }
                if (c.isInterface() || d.isInterface()) {
                    return ClassName.of("java.lang.Object").getBytecodeName();
                }
                while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
                }
                return ClassName.of(c.getName()).getBytecodeName();
            }
        };
        node.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public static <T> Stream<AbstractInsnNode> stream(InsnList instructions) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(instructions.iterator(), 0), false);
    }

    public static ClassNode apply(@Nonnull ClassNode node, @Nonnull INodeCoreTransformer context) {
        ClassNode cw = new ClassNode(327680);
        ClassVisitor mod = context.createVisitor(node.name, (ClassVisitor)cw);
        try {
            node.accept(mod);
            node = cw;
        }
        catch (StopTransforming stopTransforming) {
            // empty catch block
        }
        return node;
    }

    public static ClassNode apply(@Nonnull ClassNode node, @Nonnull INodeCoreTransformer context, @Nonnull Logger logger) {
        String name = context.getSimpleName();
        String rawname = ClassName.of(node.name).getName();
        logger.info(String.format("Patching %s (class: %s)", name, rawname));
        node = VisitorHelper.apply(node, context);
        logger.debug(String.format("Finished Patching %s (class: %s)", name, rawname));
        return node;
    }

    public static ClassNode transform(@Nonnull ClassNode node, @Nonnull INodeTreeTransformer context) {
        node = (ClassNode)Validate.notNull((Object)context.apply(node));
        return node;
    }

    public static ClassNode transform(@Nonnull ClassNode node, @Nonnull INodeTreeTransformer context, @Nonnull Logger logger) {
        String name = context.getSimpleName();
        String rawname = ClassName.of(node.name).getName();
        logger.info(String.format("Patching %s (class: %s)", name, rawname));
        node = VisitorHelper.transform(node, context);
        logger.debug(String.format("Finished Patching %s (class: %s)", name, rawname));
        return node;
    }
}

