/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Session;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import net.minecraftforge.fml.relauncher.Side;
import net.teamfruit.emojicord.compat.CompatSign;
import net.teamfruit.emojicord.compat.OpenGL;

public class Compat {

    public static class CompatMinecraftVersion {
        public static String getMinecraftVersion() {
            return "1.9.4";
        }

        public static String getForgeVersion() {
            return ForgeVersion.getVersion();
        }
    }

    public static class CompatSession {
        private final Session session;

        public CompatSession(Session session) {
            this.session = session;
        }

        public String getPlayerID() {
            return this.session.func_148255_b();
        }

        public String getUsername() {
            return this.session.func_111285_a();
        }

        public String getToken() {
            return this.session.func_148254_d();
        }
    }

    public static class CompatVersionChecker {
        public static void startVersionCheck(String modId, String modVersion, String updateURL) {
        }

        public static CompatCheckResult getResult(String modId) {
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(modId);
            return CompatCheckResult.from(ForgeVersion.getResult((ModContainer)container));
        }

        public static enum CompatStatus {
            PENDING,
            FAILED,
            UP_TO_DATE,
            OUTDATED,
            AHEAD,
            BETA,
            BETA_OUTDATED;


            public static CompatStatus getStatus(ForgeVersion.Status status) {
                switch (status) {
                    default: {
                        return PENDING;
                    }
                    case FAILED: {
                        return FAILED;
                    }
                    case UP_TO_DATE: {
                        return UP_TO_DATE;
                    }
                    case OUTDATED: {
                        return OUTDATED;
                    }
                    case AHEAD: {
                        return AHEAD;
                    }
                    case BETA: {
                        return BETA;
                    }
                    case BETA_OUTDATED: 
                }
                return BETA_OUTDATED;
            }
        }

        public static class CompatCheckResult {
            @Nonnull
            public final CompatStatus status;
            @Nullable
            public final String target;
            @Nullable
            public final Map<String, String> changes;
            @Nullable
            public final String url;

            public CompatCheckResult(@Nonnull CompatStatus status, @Nullable String target, @Nullable Map<String, String> changes, @Nullable String url) {
                this.status = status;
                this.target = target;
                this.changes = changes == null ? Collections.emptyMap() : Collections.unmodifiableMap(changes);
                this.url = url;
            }

            public static CompatCheckResult from(ForgeVersion.CheckResult result) {
                Map<String, String> compatChanges = null;
                if (result.changes != null) {
                    compatChanges = result.changes.entrySet().stream().collect(Collectors.toMap(e -> ((ComparableVersion)e.getKey()).toString(), e -> (String)e.getValue()));
                }
                return new CompatCheckResult(CompatStatus.getStatus(result.status), result.target != null ? result.target.toString() : null, compatChanges, result.url);
            }
        }
    }

    public static abstract class CompatTexturedGlyph {
        public CompatTexturedGlyph(ResourceLocation texture, float width, float height) {
        }

        public void onRender(TextureManager textureManager, boolean hasShadow, float x, float y, CompatBufferBuilder vbuilder, float red, float green, float blue, float alpha) {
        }
    }

    public static abstract class CompatGlyph {
        public CompatGlyph(float width, float height) {
        }
    }

    public static class CompatBufferBuilder {
    }

    public static enum CompatSide {
        COMMON,
        CLIENT,
        SERVER;


        public Side toSide() {
            switch (this) {
                case CLIENT: {
                    return Side.CLIENT;
                }
                case SERVER: {
                    return Side.SERVER;
                }
            }
            return Side.SERVER;
        }

        public static CompatSide fromSide(Side type) {
            switch (type) {
                case CLIENT: {
                    return CLIENT;
                }
                case SERVER: {
                    return SERVER;
                }
            }
            return COMMON;
        }
    }

    public static class CompatSimpleTexture
    extends SimpleTexture {
        public CompatSimpleTexture(ResourceLocation textureResourceLocation) {
            super(textureResourceLocation);
        }

        public int getRawGlTextureId() {
            return super.func_110552_b();
        }

        public void func_110551_a(IResourceManager manager) throws IOException {
            this.loadTexture(new CompatResourceManager(manager));
        }

        public void loadTexture(CompatResourceManager manager) throws IOException {
            super.func_110551_a(manager.getManagerObj());
        }
    }

    public static class CompatResourceManager {
        private final IResourceManager manager;

        public CompatResourceManager(IResourceManager manager) {
            this.manager = manager;
        }

        public IResourceManager getManagerObj() {
            return this.manager;
        }
    }

    public static class CompatTexture {
        private final CompatSimpleTexture texture;

        public CompatTexture(CompatSimpleTexture texture) {
            this.texture = texture;
        }

        public static CompatTexture getTexture(CompatSimpleTexture texture) {
            return new CompatTexture(texture);
        }

        public CompatSimpleTexture getTextureObj() {
            return this.texture;
        }

        public void bindTexture() {
            OpenGL.glBindTexture(3553, this.texture.func_110552_b());
        }

        public void uploadTexture(InputStream image) throws IOException {
            this.texture.func_147631_c();
            BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)image);
            boolean blur = true;
            boolean clamp = false;
            if (bufferedimage != null) {
                TextureUtil.func_110989_a((int)this.texture.getRawGlTextureId(), (BufferedImage)bufferedimage, (boolean)true, (boolean)false);
            }
        }

        public void uploadTexture(BufferedImage bufferedimage) throws IOException {
            this.texture.func_147631_c();
            boolean blur = true;
            boolean clamp = false;
            if (bufferedimage != null) {
                TextureUtil.func_110989_a((int)this.texture.getRawGlTextureId(), (BufferedImage)bufferedimage, (boolean)true, (boolean)false);
            }
        }
    }

    public static class CompatI18n {
        public static String format(String format, Object ... args) {
            return I18n.func_135052_a((String)format, (Object[])args);
        }

        public static boolean hasKey(String key) {
            return I18n.func_188566_a((String)key);
        }

        public static String translateToLocal(String text) {
            return net.minecraft.util.text.translation.I18n.func_74838_a((String)text);
        }
    }

    public static class CompatMathHelper {
        public static int floor_float(float value) {
            return MathHelper.func_76141_d((float)value);
        }

        public static int floor_double(double value) {
            return MathHelper.func_76128_c((double)value);
        }
    }

    public static class CompatTextureUtil {
        public static final DynamicTexture missingTexture = TextureUtil.field_111001_a;

        public static void processPixelValues(int[] pixel, int displayWidth, int displayHeight) {
            TextureUtil.func_147953_a((int[])pixel, (int)displayWidth, (int)displayHeight);
        }

        public static void allocateTextureImpl(int id, int miplevel, int width, int height, float anisotropicFiltering) {
            TextureUtil.func_180600_a((int)id, (int)miplevel, (int)width, (int)height);
        }
    }

    public static class CompatSoundHandler {
        public static void playSound(@Nonnull ResourceLocation location, float volume) {
            CompatMinecraft.getMinecraft().getMinecraftObj().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)new SoundEvent(location), (float)volume));
        }
    }

    public static class CompatGameSettings {
        private final GameSettings settings;

        public CompatGameSettings(GameSettings settings) {
            this.settings = settings;
        }

        public GameSettings getSettingsObj() {
            return this.settings;
        }

        public int getAnisotropicFiltering() {
            return 0;
        }

        public String getLanguage() {
            return this.settings.field_74363_ab;
        }
    }

    public static class CompatFontRenderer {
        private final FontRenderer font;

        public CompatFontRenderer(FontRenderer font) {
            this.font = font;
        }

        public int drawString(String msg, float x, float y, int color, boolean shadow) {
            return this.font.func_175065_a(msg, x, y, color, shadow);
        }

        public int drawString(String msg, float x, float y, int color) {
            return this.drawString(msg, x, y, color, false);
        }

        public int drawStringWithShadow(String msg, float x, float y, int color) {
            return this.drawString(msg, x, y, color, true);
        }

        public String wrapFormattedStringToWidth(String msg, int width) {
            return this.font.func_78280_d(msg, width);
        }

        public int getStringWidth(@Nullable String s) {
            return this.font.func_78256_a(s);
        }

        public int getStringWidthWithoutFormattingCodes(@Nullable String s) {
            return this.getStringWidth(TextFormatting.func_110646_a((String)s));
        }

        public FontRenderer getFontRendererObj() {
            return this.font;
        }
    }

    public static class CompatMinecraft {
        private final Minecraft mc;

        public CompatMinecraft(Minecraft mc) {
            this.mc = mc;
        }

        public Minecraft getMinecraftObj() {
            return this.mc;
        }

        @Nonnull
        public static CompatMinecraft getMinecraft() {
            return new CompatMinecraft(FMLClientHandler.instance().getClient());
        }

        @Nonnull
        public CompatFontRenderer getFontRenderer() {
            return new CompatFontRenderer(this.mc.field_71466_p);
        }

        @Nullable
        public CompatSign.CompatWorld getWorld() {
            WorldClient world = this.mc.field_71441_e;
            if (world != null) {
                return new CompatSign.CompatWorld((World)world);
            }
            return null;
        }

        @Nullable
        public CompatSign.CompatEntityPlayer getPlayer() {
            EntityPlayerSP player = this.mc.field_71439_g;
            if (player != null) {
                return new CompatSign.CompatEntityPlayer((EntityPlayer)player);
            }
            return null;
        }

        @Nonnull
        public CompatGameSettings getSettings() {
            return new CompatGameSettings(this.mc.field_71474_y);
        }

        @Nullable
        public CompatSign.CompatNetHandlerPlayClient getConnection() {
            NetHandlerPlayClient connection = this.mc.func_147114_u();
            return connection != null ? new CompatSign.CompatNetHandlerPlayClient(connection) : null;
        }

        public TextureManager getTextureManager() {
            return this.mc.func_110434_K();
        }

        public File getGameDir() {
            return this.mc.field_71412_D;
        }

        public boolean isGameFocused() {
            return this.mc.field_71415_G;
        }

        public CompatSession getSession() {
            return new CompatSession(this.mc.func_110432_I());
        }
    }
}

