/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import javax.annotation.Nullable;

public enum CompatBaseVersion {
    V7(7),
    V8(8),
    V9(9),
    V10(10),
    V11(11),
    V12(12),
    V13(13),
    V14(14);

    public final int value;

    private CompatBaseVersion(int value) {
        this.value = value;
    }

    public boolean is(CompatBaseVersion version) {
        return version == this;
    }

    public boolean is(CompatBaseVersion ... versions) {
        for (CompatBaseVersion version : versions) {
            if (version != this) continue;
            return true;
        }
        return false;
    }

    public boolean range(@Nullable CompatBaseVersion min, @Nullable CompatBaseVersion max) {
        if (min != null && this.value < min.value) {
            return false;
        }
        return max == null || this.value <= max.value;
    }

    public boolean older(@Nullable CompatBaseVersion max) {
        return max == null || this.value <= max.value;
    }

    public boolean newer(@Nullable CompatBaseVersion min) {
        return min == null || this.value >= min.value;
    }
}

